static char const Ident[] = "@(#) $XX: cxform-auto.c   c:1.30 pl:1.40 $";
/*
** This file is automatically generated.  *** DO NOT EDIT BY HAND! ***
**
** Generated by the script `gen_cxform_auto.pl', version 1.40,
** from input `cxform-manual.c' version 1.30.
**
** This code is simply a set of wrapper functions for the basic 
** coordinate transformations (J2000 to GEI, GEI to GSE, and so on).
** Although there are only a small set of "real" transforms, we want
** to be able to go from one to another without having to think (after
** all, that's what computers are for).  
**
** This module performs the mappings for going from any coordinate
** system to any other.  It also provides the front end "cxform()",
** so the source/destination frames can be passed as strings, instead
** of having to hardcode "gse_to_gsm()" or whatever.
*/

#include <stdio.h>
#include <string.h>
#include "cxform.h"


/*
** First, though, we want a way to convert from a char string ("GSE")
** to a numeric representation.  Here we define an enum listing all
** the known coordinate systems, plus UNKNOWN.  We then define a
** complicated-looking function that looks at the input string, char
** by char, and returns the numeric representation of the desired
** coordinate system.  Note that upper/lower case combos are fine.
*/
enum systems { UNKNOWN, J2000, GEI, GEO, MAG, GSE, GSM, SM, RTN, GSEQ, HEE, HAE, HEEQ };
enum systems system_number( const char *system )
{
  if (system == NULL)
    return UNKNOWN;

  switch (system[0]) {
    case 'g':                                   /* GEI, GEO, GSE, GSM, GSEQ */
    case 'G':
      switch (system[1]) {
        case 'e':                               /* GEI, GEO */
        case 'E':
          switch (system[2]) {
            case 'i':                           /* GEI */
            case 'I':
              switch (system[3]) {
                case '\0':
                  return GEI;
                default:
                  return UNKNOWN;
              }
            case 'o':                           /* GEO */
            case 'O':
              switch (system[3]) {
                case '\0':
                  return GEO;
                default:
                  return UNKNOWN;
              }
            default:
              return UNKNOWN;
          }
        case 's':                               /* GSE, GSM, GSEQ */
        case 'S':
          switch (system[2]) {
            case 'e':                           /* GSE, GSEQ */
            case 'E':
              switch (system[3]) {
                case '\0':
                  return GSE;
                case 'q':                       /* GSEQ */
                case 'Q':
                  switch (system[4]) {
                    case '\0':
                      return GSEQ;
                    default:
                      return UNKNOWN;
                  }
                default:
                  return UNKNOWN;
              }
            case 'm':                           /* GSM */
            case 'M':
              switch (system[3]) {
                case '\0':
                  return GSM;
                default:
                  return UNKNOWN;
              }
            default:
              return UNKNOWN;
          }
        default:
          return UNKNOWN;
      }
    case 'h':                                   /* HEE, HAE, HEEQ */
    case 'H':
      switch (system[1]) {
        case 'a':                               /* HAE */
        case 'A':
          switch (system[2]) {
            case 'e':                           /* HAE */
            case 'E':
              switch (system[3]) {
                case '\0':
                  return HAE;
                default:
                  return UNKNOWN;
              }
            default:
              return UNKNOWN;
          }
        case 'e':                               /* HEE, HEEQ */
        case 'E':
          switch (system[2]) {
            case 'e':                           /* HEE, HEEQ */
            case 'E':
              switch (system[3]) {
                case '\0':
                  return HEE;
                case 'q':                       /* HEEQ */
                case 'Q':
                  switch (system[4]) {
                    case '\0':
                      return HEEQ;
                    default:
                      return UNKNOWN;
                  }
                default:
                  return UNKNOWN;
              }
            default:
              return UNKNOWN;
          }
        default:
          return UNKNOWN;
      }
    case 'j':                                   /* J2000 */
    case 'J':
      switch (system[1]) {
        case '2':                               /* J2000 */
          switch (system[2]) {
            case '0':                           /* J2000 */
              switch (system[3]) {
                case '0':                       /* J2000 */
                  switch (system[4]) {
                    case '0':                   /* J2000 */
                      switch (system[5]) {
                        case '\0':
                          return J2000;
                        default:
                          return UNKNOWN;
                      }
                    default:
                      return UNKNOWN;
                  }
                default:
                  return UNKNOWN;
              }
            default:
              return UNKNOWN;
          }
        default:
          return UNKNOWN;
      }
    case 'm':                                   /* MAG */
    case 'M':
      switch (system[1]) {
        case 'a':                               /* MAG */
        case 'A':
          switch (system[2]) {
            case 'g':                           /* MAG */
            case 'G':
              switch (system[3]) {
                case '\0':
                  return MAG;
                default:
                  return UNKNOWN;
              }
            default:
              return UNKNOWN;
          }
        default:
          return UNKNOWN;
      }
    case 'r':                                   /* RTN */
    case 'R':
      switch (system[1]) {
        case 't':                               /* RTN */
        case 'T':
          switch (system[2]) {
            case 'n':                           /* RTN */
            case 'N':
              switch (system[3]) {
                case '\0':
                  return RTN;
                default:
                  return UNKNOWN;
              }
            default:
              return UNKNOWN;
          }
        default:
          return UNKNOWN;
      }
    case 's':                                   /* SM */
    case 'S':
      switch (system[1]) {
        case 'm':                               /* SM */
        case 'M':
          switch (system[2]) {
            case '\0':
              return SM;
            default:
              return UNKNOWN;
          }
        default:
          return UNKNOWN;
      }
    default:
      return UNKNOWN;
  }
}


/*
** The following boring list of prototypes is for the benefit of cxform().
**
** The first cluster, below, lists the functions defined in cxform-manual.c
*/
extern int j2000_twixt_gei   (double t, Vec in, Vec out, Direction d);
extern int   gei_twixt_geo   (double t, Vec in, Vec out, Direction d);
extern int   gei_twixt_gse   (double t, Vec in, Vec out, Direction d);
extern int   geo_twixt_mag   (double t, Vec in, Vec out, Direction d);
extern int   gse_twixt_gsm   (double t, Vec in, Vec out, Direction d);
extern int   gse_twixt_rtn   (double t, Vec in, Vec out, Direction d);
extern int   gse_twixt_gseq  (double t, Vec in, Vec out, Direction d);
extern int   gse_twixt_hee   (double t, Vec in, Vec out, Direction d);
extern int   gsm_twixt_sm    (double t, Vec in, Vec out, Direction d);
extern int   hae_twixt_hee   (double t, Vec in, Vec out, Direction d);
extern int   hae_twixt_heeq  (double t, Vec in, Vec out, Direction d);

/*
** This second (long) cluster defines the wrappers we generate automatically.
*/
static int j2000_to_gei   (double t, Vec in, Vec out);
static int j2000_to_geo   (double t, Vec in, Vec out);
static int j2000_to_mag   (double t, Vec in, Vec out);
static int j2000_to_gse   (double t, Vec in, Vec out);
static int j2000_to_gsm   (double t, Vec in, Vec out);
static int j2000_to_sm    (double t, Vec in, Vec out);
static int j2000_to_rtn   (double t, Vec in, Vec out);
static int j2000_to_gseq  (double t, Vec in, Vec out);
static int j2000_to_hee   (double t, Vec in, Vec out);
static int j2000_to_hae   (double t, Vec in, Vec out);
static int j2000_to_heeq  (double t, Vec in, Vec out);
static int   gei_to_j2000 (double t, Vec in, Vec out);
static int   gei_to_geo   (double t, Vec in, Vec out);
static int   gei_to_mag   (double t, Vec in, Vec out);
static int   gei_to_gse   (double t, Vec in, Vec out);
static int   gei_to_gsm   (double t, Vec in, Vec out);
static int   gei_to_sm    (double t, Vec in, Vec out);
static int   gei_to_rtn   (double t, Vec in, Vec out);
static int   gei_to_gseq  (double t, Vec in, Vec out);
static int   gei_to_hee   (double t, Vec in, Vec out);
static int   gei_to_hae   (double t, Vec in, Vec out);
static int   gei_to_heeq  (double t, Vec in, Vec out);
static int   geo_to_j2000 (double t, Vec in, Vec out);
static int   geo_to_gei   (double t, Vec in, Vec out);
static int   geo_to_mag   (double t, Vec in, Vec out);
static int   geo_to_gse   (double t, Vec in, Vec out);
static int   geo_to_gsm   (double t, Vec in, Vec out);
static int   geo_to_sm    (double t, Vec in, Vec out);
static int   geo_to_rtn   (double t, Vec in, Vec out);
static int   geo_to_gseq  (double t, Vec in, Vec out);
static int   geo_to_hee   (double t, Vec in, Vec out);
static int   geo_to_hae   (double t, Vec in, Vec out);
static int   geo_to_heeq  (double t, Vec in, Vec out);
static int   mag_to_j2000 (double t, Vec in, Vec out);
static int   mag_to_gei   (double t, Vec in, Vec out);
static int   mag_to_geo   (double t, Vec in, Vec out);
static int   mag_to_gse   (double t, Vec in, Vec out);
static int   mag_to_gsm   (double t, Vec in, Vec out);
static int   mag_to_sm    (double t, Vec in, Vec out);
static int   mag_to_rtn   (double t, Vec in, Vec out);
static int   mag_to_gseq  (double t, Vec in, Vec out);
static int   mag_to_hee   (double t, Vec in, Vec out);
static int   mag_to_hae   (double t, Vec in, Vec out);
static int   mag_to_heeq  (double t, Vec in, Vec out);
static int   gse_to_j2000 (double t, Vec in, Vec out);
static int   gse_to_gei   (double t, Vec in, Vec out);
static int   gse_to_geo   (double t, Vec in, Vec out);
static int   gse_to_mag   (double t, Vec in, Vec out);
static int   gse_to_gsm   (double t, Vec in, Vec out);
static int   gse_to_sm    (double t, Vec in, Vec out);
static int   gse_to_rtn   (double t, Vec in, Vec out);
static int   gse_to_gseq  (double t, Vec in, Vec out);
static int   gse_to_hee   (double t, Vec in, Vec out);
static int   gse_to_hae   (double t, Vec in, Vec out);
static int   gse_to_heeq  (double t, Vec in, Vec out);
static int   gsm_to_j2000 (double t, Vec in, Vec out);
static int   gsm_to_gei   (double t, Vec in, Vec out);
static int   gsm_to_geo   (double t, Vec in, Vec out);
static int   gsm_to_mag   (double t, Vec in, Vec out);
static int   gsm_to_gse   (double t, Vec in, Vec out);
static int   gsm_to_sm    (double t, Vec in, Vec out);
static int   gsm_to_rtn   (double t, Vec in, Vec out);
static int   gsm_to_gseq  (double t, Vec in, Vec out);
static int   gsm_to_hee   (double t, Vec in, Vec out);
static int   gsm_to_hae   (double t, Vec in, Vec out);
static int   gsm_to_heeq  (double t, Vec in, Vec out);
static int    sm_to_j2000 (double t, Vec in, Vec out);
static int    sm_to_gei   (double t, Vec in, Vec out);
static int    sm_to_geo   (double t, Vec in, Vec out);
static int    sm_to_mag   (double t, Vec in, Vec out);
static int    sm_to_gse   (double t, Vec in, Vec out);
static int    sm_to_gsm   (double t, Vec in, Vec out);
static int    sm_to_rtn   (double t, Vec in, Vec out);
static int    sm_to_gseq  (double t, Vec in, Vec out);
static int    sm_to_hee   (double t, Vec in, Vec out);
static int    sm_to_hae   (double t, Vec in, Vec out);
static int    sm_to_heeq  (double t, Vec in, Vec out);
static int   rtn_to_j2000 (double t, Vec in, Vec out);
static int   rtn_to_gei   (double t, Vec in, Vec out);
static int   rtn_to_geo   (double t, Vec in, Vec out);
static int   rtn_to_mag   (double t, Vec in, Vec out);
static int   rtn_to_gse   (double t, Vec in, Vec out);
static int   rtn_to_gsm   (double t, Vec in, Vec out);
static int   rtn_to_sm    (double t, Vec in, Vec out);
static int   rtn_to_gseq  (double t, Vec in, Vec out);
static int   rtn_to_hee   (double t, Vec in, Vec out);
static int   rtn_to_hae   (double t, Vec in, Vec out);
static int   rtn_to_heeq  (double t, Vec in, Vec out);
static int  gseq_to_j2000 (double t, Vec in, Vec out);
static int  gseq_to_gei   (double t, Vec in, Vec out);
static int  gseq_to_geo   (double t, Vec in, Vec out);
static int  gseq_to_mag   (double t, Vec in, Vec out);
static int  gseq_to_gse   (double t, Vec in, Vec out);
static int  gseq_to_gsm   (double t, Vec in, Vec out);
static int  gseq_to_sm    (double t, Vec in, Vec out);
static int  gseq_to_rtn   (double t, Vec in, Vec out);
static int  gseq_to_hee   (double t, Vec in, Vec out);
static int  gseq_to_hae   (double t, Vec in, Vec out);
static int  gseq_to_heeq  (double t, Vec in, Vec out);
static int   hee_to_j2000 (double t, Vec in, Vec out);
static int   hee_to_gei   (double t, Vec in, Vec out);
static int   hee_to_geo   (double t, Vec in, Vec out);
static int   hee_to_mag   (double t, Vec in, Vec out);
static int   hee_to_gse   (double t, Vec in, Vec out);
static int   hee_to_gsm   (double t, Vec in, Vec out);
static int   hee_to_sm    (double t, Vec in, Vec out);
static int   hee_to_rtn   (double t, Vec in, Vec out);
static int   hee_to_gseq  (double t, Vec in, Vec out);
static int   hee_to_hae   (double t, Vec in, Vec out);
static int   hee_to_heeq  (double t, Vec in, Vec out);
static int   hae_to_j2000 (double t, Vec in, Vec out);
static int   hae_to_gei   (double t, Vec in, Vec out);
static int   hae_to_geo   (double t, Vec in, Vec out);
static int   hae_to_mag   (double t, Vec in, Vec out);
static int   hae_to_gse   (double t, Vec in, Vec out);
static int   hae_to_gsm   (double t, Vec in, Vec out);
static int   hae_to_sm    (double t, Vec in, Vec out);
static int   hae_to_rtn   (double t, Vec in, Vec out);
static int   hae_to_gseq  (double t, Vec in, Vec out);
static int   hae_to_hee   (double t, Vec in, Vec out);
static int   hae_to_heeq  (double t, Vec in, Vec out);
static int  heeq_to_j2000 (double t, Vec in, Vec out);
static int  heeq_to_gei   (double t, Vec in, Vec out);
static int  heeq_to_geo   (double t, Vec in, Vec out);
static int  heeq_to_mag   (double t, Vec in, Vec out);
static int  heeq_to_gse   (double t, Vec in, Vec out);
static int  heeq_to_gsm   (double t, Vec in, Vec out);
static int  heeq_to_sm    (double t, Vec in, Vec out);
static int  heeq_to_rtn   (double t, Vec in, Vec out);
static int  heeq_to_gseq  (double t, Vec in, Vec out);
static int  heeq_to_hee   (double t, Vec in, Vec out);
static int  heeq_to_hae   (double t, Vec in, Vec out);

static char cxform_err_buf[1024];
char *cxform_err(void)
{
  return cxform_err_buf;
}


/*
** Here's the main code.  Simple, actually.  All we do is:
**
**    1) determine the source ("from") and destination ("to") frames,
**       and make sure they are valid ones.
**
**    2) call the appropriate <from>_to_<to>() function.
**
** The <from>_to_<to> functions are declared further down below (except
** for the "real" transformation functions, which are in cxform-manual.c).
*/
int cxform(const char *from, const char *to, const double t, Vec v_in, Vec v_out)
{
  enum systems from_n, to_n;

  cxform_err_buf[0] = '\0';

  if (from == NULL) {
    strcpy(cxform_err_buf, "No source frame given.");
    return 1;
  }
  if (to == NULL) {
    strcpy(cxform_err_buf, "No destination frame given.");
    return 1;
  }

  if ((from_n = system_number(from)) == UNKNOWN) {
    sprintf(cxform_err_buf, "Source frame '%s' is unknown;", from);
    strcat(cxform_err_buf, " must be one of: J2000 GEI GEO MAG GSE GSM SM RTN GSEQ HEE HAE HEEQ");
    return 1;
  }
  if ((to_n   = system_number(to)) == UNKNOWN) {
    sprintf(cxform_err_buf, "Destination frame '%s' is unknown;", to);
    strcat(cxform_err_buf, " must be one of: J2000 GEI GEO MAG GSE GSM SM RTN GSEQ HEE HAE HEEQ");
    return 1;
  }

  /*
  ** Check to see if the source and destination are the same.  If so,
  ** return the input vector as output.
  */
  if (from_n == to_n) {
    int i;
    for (i=0; i<3; i++)
      v_out[i] = v_in[i];

    return 0;
  }

  /* For the "default" cases in the switches below */
  strcpy(cxform_err_buf, "Internal error -- this is impossible");

  /*
  ** Find the source, then find the dest, then call the appropriate xform.
  */
  switch (from_n) {
    case J2000:
      switch (to_n) {
        case GEI:
          return j2000_to_gei(t,v_in,v_out);
        case GEO:
          return j2000_to_geo(t,v_in,v_out);
        case MAG:
          return j2000_to_mag(t,v_in,v_out);
        case GSE:
          return j2000_to_gse(t,v_in,v_out);
        case GSM:
          return j2000_to_gsm(t,v_in,v_out);
        case SM:
          return j2000_to_sm(t,v_in,v_out);
        case RTN:
          return j2000_to_rtn(t,v_in,v_out);
        case GSEQ:
          return j2000_to_gseq(t,v_in,v_out);
        case HEE:
          return j2000_to_hee(t,v_in,v_out);
        case HAE:
          return j2000_to_hae(t,v_in,v_out);
        case HEEQ:
          return j2000_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case GEI:
      switch (to_n) {
        case J2000:
          return gei_to_j2000(t,v_in,v_out);
        case GEO:
          return gei_to_geo(t,v_in,v_out);
        case MAG:
          return gei_to_mag(t,v_in,v_out);
        case GSE:
          return gei_to_gse(t,v_in,v_out);
        case GSM:
          return gei_to_gsm(t,v_in,v_out);
        case SM:
          return gei_to_sm(t,v_in,v_out);
        case RTN:
          return gei_to_rtn(t,v_in,v_out);
        case GSEQ:
          return gei_to_gseq(t,v_in,v_out);
        case HEE:
          return gei_to_hee(t,v_in,v_out);
        case HAE:
          return gei_to_hae(t,v_in,v_out);
        case HEEQ:
          return gei_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case GEO:
      switch (to_n) {
        case J2000:
          return geo_to_j2000(t,v_in,v_out);
        case GEI:
          return geo_to_gei(t,v_in,v_out);
        case MAG:
          return geo_to_mag(t,v_in,v_out);
        case GSE:
          return geo_to_gse(t,v_in,v_out);
        case GSM:
          return geo_to_gsm(t,v_in,v_out);
        case SM:
          return geo_to_sm(t,v_in,v_out);
        case RTN:
          return geo_to_rtn(t,v_in,v_out);
        case GSEQ:
          return geo_to_gseq(t,v_in,v_out);
        case HEE:
          return geo_to_hee(t,v_in,v_out);
        case HAE:
          return geo_to_hae(t,v_in,v_out);
        case HEEQ:
          return geo_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case MAG:
      switch (to_n) {
        case J2000:
          return mag_to_j2000(t,v_in,v_out);
        case GEI:
          return mag_to_gei(t,v_in,v_out);
        case GEO:
          return mag_to_geo(t,v_in,v_out);
        case GSE:
          return mag_to_gse(t,v_in,v_out);
        case GSM:
          return mag_to_gsm(t,v_in,v_out);
        case SM:
          return mag_to_sm(t,v_in,v_out);
        case RTN:
          return mag_to_rtn(t,v_in,v_out);
        case GSEQ:
          return mag_to_gseq(t,v_in,v_out);
        case HEE:
          return mag_to_hee(t,v_in,v_out);
        case HAE:
          return mag_to_hae(t,v_in,v_out);
        case HEEQ:
          return mag_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case GSE:
      switch (to_n) {
        case J2000:
          return gse_to_j2000(t,v_in,v_out);
        case GEI:
          return gse_to_gei(t,v_in,v_out);
        case GEO:
          return gse_to_geo(t,v_in,v_out);
        case MAG:
          return gse_to_mag(t,v_in,v_out);
        case GSM:
          return gse_to_gsm(t,v_in,v_out);
        case SM:
          return gse_to_sm(t,v_in,v_out);
        case RTN:
          return gse_to_rtn(t,v_in,v_out);
        case GSEQ:
          return gse_to_gseq(t,v_in,v_out);
        case HEE:
          return gse_to_hee(t,v_in,v_out);
        case HAE:
          return gse_to_hae(t,v_in,v_out);
        case HEEQ:
          return gse_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case GSM:
      switch (to_n) {
        case J2000:
          return gsm_to_j2000(t,v_in,v_out);
        case GEI:
          return gsm_to_gei(t,v_in,v_out);
        case GEO:
          return gsm_to_geo(t,v_in,v_out);
        case MAG:
          return gsm_to_mag(t,v_in,v_out);
        case GSE:
          return gsm_to_gse(t,v_in,v_out);
        case SM:
          return gsm_to_sm(t,v_in,v_out);
        case RTN:
          return gsm_to_rtn(t,v_in,v_out);
        case GSEQ:
          return gsm_to_gseq(t,v_in,v_out);
        case HEE:
          return gsm_to_hee(t,v_in,v_out);
        case HAE:
          return gsm_to_hae(t,v_in,v_out);
        case HEEQ:
          return gsm_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case SM:
      switch (to_n) {
        case J2000:
          return sm_to_j2000(t,v_in,v_out);
        case GEI:
          return sm_to_gei(t,v_in,v_out);
        case GEO:
          return sm_to_geo(t,v_in,v_out);
        case MAG:
          return sm_to_mag(t,v_in,v_out);
        case GSE:
          return sm_to_gse(t,v_in,v_out);
        case GSM:
          return sm_to_gsm(t,v_in,v_out);
        case RTN:
          return sm_to_rtn(t,v_in,v_out);
        case GSEQ:
          return sm_to_gseq(t,v_in,v_out);
        case HEE:
          return sm_to_hee(t,v_in,v_out);
        case HAE:
          return sm_to_hae(t,v_in,v_out);
        case HEEQ:
          return sm_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case RTN:
      switch (to_n) {
        case J2000:
          return rtn_to_j2000(t,v_in,v_out);
        case GEI:
          return rtn_to_gei(t,v_in,v_out);
        case GEO:
          return rtn_to_geo(t,v_in,v_out);
        case MAG:
          return rtn_to_mag(t,v_in,v_out);
        case GSE:
          return rtn_to_gse(t,v_in,v_out);
        case GSM:
          return rtn_to_gsm(t,v_in,v_out);
        case SM:
          return rtn_to_sm(t,v_in,v_out);
        case GSEQ:
          return rtn_to_gseq(t,v_in,v_out);
        case HEE:
          return rtn_to_hee(t,v_in,v_out);
        case HAE:
          return rtn_to_hae(t,v_in,v_out);
        case HEEQ:
          return rtn_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case GSEQ:
      switch (to_n) {
        case J2000:
          return gseq_to_j2000(t,v_in,v_out);
        case GEI:
          return gseq_to_gei(t,v_in,v_out);
        case GEO:
          return gseq_to_geo(t,v_in,v_out);
        case MAG:
          return gseq_to_mag(t,v_in,v_out);
        case GSE:
          return gseq_to_gse(t,v_in,v_out);
        case GSM:
          return gseq_to_gsm(t,v_in,v_out);
        case SM:
          return gseq_to_sm(t,v_in,v_out);
        case RTN:
          return gseq_to_rtn(t,v_in,v_out);
        case HEE:
          return gseq_to_hee(t,v_in,v_out);
        case HAE:
          return gseq_to_hae(t,v_in,v_out);
        case HEEQ:
          return gseq_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case HEE:
      switch (to_n) {
        case J2000:
          return hee_to_j2000(t,v_in,v_out);
        case GEI:
          return hee_to_gei(t,v_in,v_out);
        case GEO:
          return hee_to_geo(t,v_in,v_out);
        case MAG:
          return hee_to_mag(t,v_in,v_out);
        case GSE:
          return hee_to_gse(t,v_in,v_out);
        case GSM:
          return hee_to_gsm(t,v_in,v_out);
        case SM:
          return hee_to_sm(t,v_in,v_out);
        case RTN:
          return hee_to_rtn(t,v_in,v_out);
        case GSEQ:
          return hee_to_gseq(t,v_in,v_out);
        case HAE:
          return hee_to_hae(t,v_in,v_out);
        case HEEQ:
          return hee_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case HAE:
      switch (to_n) {
        case J2000:
          return hae_to_j2000(t,v_in,v_out);
        case GEI:
          return hae_to_gei(t,v_in,v_out);
        case GEO:
          return hae_to_geo(t,v_in,v_out);
        case MAG:
          return hae_to_mag(t,v_in,v_out);
        case GSE:
          return hae_to_gse(t,v_in,v_out);
        case GSM:
          return hae_to_gsm(t,v_in,v_out);
        case SM:
          return hae_to_sm(t,v_in,v_out);
        case RTN:
          return hae_to_rtn(t,v_in,v_out);
        case GSEQ:
          return hae_to_gseq(t,v_in,v_out);
        case HEE:
          return hae_to_hee(t,v_in,v_out);
        case HEEQ:
          return hae_to_heeq(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    case HEEQ:
      switch (to_n) {
        case J2000:
          return heeq_to_j2000(t,v_in,v_out);
        case GEI:
          return heeq_to_gei(t,v_in,v_out);
        case GEO:
          return heeq_to_geo(t,v_in,v_out);
        case MAG:
          return heeq_to_mag(t,v_in,v_out);
        case GSE:
          return heeq_to_gse(t,v_in,v_out);
        case GSM:
          return heeq_to_gsm(t,v_in,v_out);
        case SM:
          return heeq_to_sm(t,v_in,v_out);
        case RTN:
          return heeq_to_rtn(t,v_in,v_out);
        case GSEQ:
          return heeq_to_gseq(t,v_in,v_out);
        case HEE:
          return heeq_to_hee(t,v_in,v_out);
        case HAE:
          return heeq_to_hae(t,v_in,v_out);
        default:		/* Cannot happen */
          return 1;
      }
    default:		/*Cannot happen */
      return 1;
  }

  /* We should never get here */
  strcat(cxform_err_buf, "INTERNAL ERROR: switch statements fell through!");
  return 2;
}


/*
** Stub routines... all we do is call one of The Six, in various orders
*/

/*
** J2000 to GEI
*/
int j2000_to_gei(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD);   /* J2000 to GEI   */
}

/*
** J2000 to GEO
*/
int j2000_to_geo(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** J2000 to MAG
*/
int j2000_to_mag(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** J2000 to GSE
*/
int j2000_to_gse(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD);   /*   GEI to GSE   */
}

/*
** J2000 to GSM
*/
int j2000_to_gsm(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** J2000 to SM
*/
int j2000_to_sm(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** J2000 to RTN
*/
int j2000_to_rtn(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** J2000 to GSEQ
*/
int j2000_to_gseq(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** J2000 to HEE
*/
int j2000_to_hee(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** J2000 to HAE
*/
int j2000_to_hae(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** J2000 to HEEQ
*/
int j2000_to_heeq(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, FORWARD)    /* J2000 to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** GEI to J2000
*/
int gei_to_j2000(double t, Vec v_in, Vec v_out)
{
  return j2000_twixt_gei  (t, v_in , v_out, BACK);      /*   GEI to J2000 */
}

/*
** GEI to GEO
*/
int gei_to_geo(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** GEI to MAG
*/
int gei_to_mag(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** GEI to GSE
*/
int gei_to_gse(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, FORWARD);   /*   GEI to GSE   */
}

/*
** GEI to GSM
*/
int gei_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** GEI to SM
*/
int gei_to_sm(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** GEI to RTN
*/
int gei_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** GEI to GSEQ
*/
int gei_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** GEI to HEE
*/
int gei_to_hee(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** GEI to HAE
*/
int gei_to_hae(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** GEI to HEEQ
*/
int gei_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** GEO to J2000
*/
int geo_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** GEO to GEI
*/
int geo_to_gei(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK);      /*   GEO to GEI   */
}

/*
** GEO to MAG
*/
int geo_to_mag(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** GEO to GSE
*/
int geo_to_gse(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD);   /*   GEI to GSE   */
}

/*
** GEO to GSM
*/
int geo_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** GEO to SM
*/
int geo_to_sm(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** GEO to RTN
*/
int geo_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** GEO to GSEQ
*/
int geo_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** GEO to HEE
*/
int geo_to_hee(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** GEO to HAE
*/
int geo_to_hae(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** GEO to HEEQ
*/
int geo_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_geo  (t, v_in , v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** MAG to J2000
*/
int mag_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** MAG to GEI
*/
int mag_to_gei(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK);      /*   GEO to GEI   */
}

/*
** MAG to GEO
*/
int mag_to_geo(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK);      /*   MAG to GEO   */
}

/*
** MAG to GSE
*/
int mag_to_gse(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD);   /*   GEI to GSE   */
}

/*
** MAG to GSM
*/
int mag_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** MAG to SM
*/
int mag_to_sm(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** MAG to RTN
*/
int mag_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** MAG to GSEQ
*/
int mag_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** MAG to HEE
*/
int mag_to_hee(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** MAG to HAE
*/
int mag_to_hae(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** MAG to HEEQ
*/
int mag_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   geo_twixt_mag  (t, v_in , v_out, BACK)       /*   MAG to GEO   */
      ||   gei_twixt_geo  (t, v_out, v_out, BACK)       /*   GEO to GEI   */
      ||   gei_twixt_gse  (t, v_out, v_out, FORWARD)    /*   GEI to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** GSE to J2000
*/
int gse_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, BACK)       /*   GSE to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** GSE to GEI
*/
int gse_to_gei(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, BACK);      /*   GSE to GEI   */
}

/*
** GSE to GEO
*/
int gse_to_geo(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** GSE to MAG
*/
int gse_to_mag(double t, Vec v_in, Vec v_out)
{
  return   gei_twixt_gse  (t, v_in , v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** GSE to GSM
*/
int gse_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** GSE to SM
*/
int gse_to_sm(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** GSE to RTN
*/
int gse_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** GSE to GSEQ
*/
int gse_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** GSE to HEE
*/
int gse_to_hee(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** GSE to HAE
*/
int gse_to_hae(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** GSE to HEEQ
*/
int gse_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** GSM to J2000
*/
int gsm_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** GSM to GEI
*/
int gsm_to_gei(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK);      /*   GSE to GEI   */
}

/*
** GSM to GEO
*/
int gsm_to_geo(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** GSM to MAG
*/
int gsm_to_mag(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** GSM to GSE
*/
int gsm_to_gse(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK);      /*   GSM to GSE   */
}

/*
** GSM to SM
*/
int gsm_to_sm(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, FORWARD);   /*   GSM to SM    */
}

/*
** GSM to RTN
*/
int gsm_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** GSM to GSEQ
*/
int gsm_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** GSM to HEE
*/
int gsm_to_hee(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** GSM to HAE
*/
int gsm_to_hae(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** GSM to HEEQ
*/
int gsm_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gsm  (t, v_in , v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** SM to J2000
*/
int sm_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** SM to GEI
*/
int sm_to_gei(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK);      /*   GSE to GEI   */
}

/*
** SM to GEO
*/
int sm_to_geo(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** SM to MAG
*/
int sm_to_mag(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** SM to GSE
*/
int sm_to_gse(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK);      /*   GSM to GSE   */
}

/*
** SM to GSM
*/
int sm_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK);      /*    SM to GSM   */
}

/*
** SM to RTN
*/
int sm_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** SM to GSEQ
*/
int sm_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** SM to HEE
*/
int sm_to_hee(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** SM to HAE
*/
int sm_to_hae(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** SM to HEEQ
*/
int sm_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   gsm_twixt_sm   (t, v_in , v_out, BACK)       /*    SM to GSM   */
      ||   gse_twixt_gsm  (t, v_out, v_out, BACK)       /*   GSM to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** RTN to J2000
*/
int rtn_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** RTN to GEI
*/
int rtn_to_gei(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK);      /*   GSE to GEI   */
}

/*
** RTN to GEO
*/
int rtn_to_geo(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** RTN to MAG
*/
int rtn_to_mag(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** RTN to GSE
*/
int rtn_to_gse(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK);      /*   RTN to GSE   */
}

/*
** RTN to GSM
*/
int rtn_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** RTN to SM
*/
int rtn_to_sm(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** RTN to GSEQ
*/
int rtn_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** RTN to HEE
*/
int rtn_to_hee(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** RTN to HAE
*/
int rtn_to_hae(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** RTN to HEEQ
*/
int rtn_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_rtn  (t, v_in , v_out, BACK)       /*   RTN to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** GSEQ to J2000
*/
int gseq_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** GSEQ to GEI
*/
int gseq_to_gei(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK);      /*   GSE to GEI   */
}

/*
** GSEQ to GEO
*/
int gseq_to_geo(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** GSEQ to MAG
*/
int gseq_to_mag(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** GSEQ to GSE
*/
int gseq_to_gse(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK);      /*  GSEQ to GSE   */
}

/*
** GSEQ to GSM
*/
int gseq_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** GSEQ to SM
*/
int gseq_to_sm(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** GSEQ to RTN
*/
int gseq_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** GSEQ to HEE
*/
int gseq_to_hee(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD);   /*   GSE to HEE   */
}

/*
** GSEQ to HAE
*/
int gseq_to_hae(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to HAE   */
}

/*
** GSEQ to HEEQ
*/
int gseq_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_gseq (t, v_in , v_out, BACK)       /*  GSEQ to GSE   */
      ||   gse_twixt_hee  (t, v_out, v_out, FORWARD)    /*   GSE to HEE   */
      ||   hae_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** HEE to J2000
*/
int hee_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** HEE to GEI
*/
int hee_to_gei(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK);      /*   GSE to GEI   */
}

/*
** HEE to GEO
*/
int hee_to_geo(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** HEE to MAG
*/
int hee_to_mag(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** HEE to GSE
*/
int hee_to_gse(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK);      /*   HEE to GSE   */
}

/*
** HEE to GSM
*/
int hee_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** HEE to SM
*/
int hee_to_sm(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** HEE to RTN
*/
int hee_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** HEE to GSEQ
*/
int hee_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   gse_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** HEE to HAE
*/
int hee_to_hae(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, BACK);      /*   HEE to HAE   */
}

/*
** HEE to HEEQ
*/
int hee_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, BACK)       /*   HEE to HAE   */
      ||   hae_twixt_heeq (t, v_out, v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** HAE to J2000
*/
int hae_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** HAE to GEI
*/
int hae_to_gei(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK);      /*   GSE to GEI   */
}

/*
** HAE to GEO
*/
int hae_to_geo(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** HAE to MAG
*/
int hae_to_mag(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** HAE to GSE
*/
int hae_to_gse(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to GSE   */
}

/*
** HAE to GSM
*/
int hae_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** HAE to SM
*/
int hae_to_sm(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** HAE to RTN
*/
int hae_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** HAE to GSEQ
*/
int hae_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** HAE to HEE
*/
int hae_to_hee(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_hee  (t, v_in , v_out, FORWARD);   /*   HAE to HEE   */
}

/*
** HAE to HEEQ
*/
int hae_to_heeq(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, FORWARD);   /*   HAE to HEEQ  */
}

/*
** HEEQ to J2000
*/
int heeq_to_j2000(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      || j2000_twixt_gei  (t, v_out, v_out, BACK);      /*   GEI to J2000 */
}

/*
** HEEQ to GEI
*/
int heeq_to_gei(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK);      /*   GSE to GEI   */
}

/*
** HEEQ to GEO
*/
int heeq_to_geo(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD);   /*   GEI to GEO   */
}

/*
** HEEQ to MAG
*/
int heeq_to_mag(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gei_twixt_gse  (t, v_out, v_out, BACK)       /*   GSE to GEI   */
      ||   gei_twixt_geo  (t, v_out, v_out, FORWARD)    /*   GEI to GEO   */
      ||   geo_twixt_mag  (t, v_out, v_out, FORWARD);   /*   GEO to MAG   */
}

/*
** HEEQ to GSE
*/
int heeq_to_gse(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK);      /*   HEE to GSE   */
}

/*
** HEEQ to GSM
*/
int heeq_to_gsm(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD);   /*   GSE to GSM   */
}

/*
** HEEQ to SM
*/
int heeq_to_sm(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gsm  (t, v_out, v_out, FORWARD)    /*   GSE to GSM   */
      ||   gsm_twixt_sm   (t, v_out, v_out, FORWARD);   /*   GSM to SM    */
}

/*
** HEEQ to RTN
*/
int heeq_to_rtn(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_rtn  (t, v_out, v_out, FORWARD);   /*   GSE to RTN   */
}

/*
** HEEQ to GSEQ
*/
int heeq_to_gseq(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD)    /*   HAE to HEE   */
      ||   gse_twixt_hee  (t, v_out, v_out, BACK)       /*   HEE to GSE   */
      ||   gse_twixt_gseq (t, v_out, v_out, FORWARD);   /*   GSE to GSEQ  */
}

/*
** HEEQ to HEE
*/
int heeq_to_hee(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK)       /*  HEEQ to HAE   */
      ||   hae_twixt_hee  (t, v_out, v_out, FORWARD);   /*   HAE to HEE   */
}

/*
** HEEQ to HAE
*/
int heeq_to_hae(double t, Vec v_in, Vec v_out)
{
  return   hae_twixt_heeq (t, v_in , v_out, BACK);      /*  HEEQ to HAE   */
}
