/*****************************************************************************************
 *                                                                                       *
 * OpenSpace                                                                             *
 *                                                                                       *
 * Copyright (c) 2014-2020                                                               *
 *                                                                                       *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this  *
 * software and associated documentation files (the "Software"), to deal in the Software *
 * without restriction, including without limitation the rights to use, copy, modify,    *
 * merge, publish, distribute, sublicense, and/or sell copies of the Software, and to    *
 * permit persons to whom the Software is furnished to do so, subject to the following   *
 * conditions:                                                                           *
 *                                                                                       *
 * The above copyright notice and this permission notice shall be included in all copies *
 * or substantial portions of the Software.                                              *
 *                                                                                       *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,   *
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A         *
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT    *
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF  *
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE  *
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                                         *
 ****************************************************************************************/

#include <modules/server/include/topics/topic.h>

#include <modules/server/servermodule.h>
#include <openspace/json.h>
#include <ghoul/misc/profiling.h>

namespace openspace {

void Topic::initialize(Connection* connection, size_t topicId) {
    _connection = connection;
    _topicId = topicId;
}

nlohmann::json Topic::wrappedPayload(const nlohmann::json& payload) const {
    ZoneScoped

    // TODO: add message time
    nlohmann::json j = {
        { "topic", _topicId },
        { "payload", payload }
    };
    return j;
}

nlohmann::json Topic::wrappedError(std::string message, int code) {
    ZoneScoped

    nlohmann::json j = {
        { "topic", _topicId },
        { "status", "error" },
        { "message", message },
        { "code", code }
    };
    return j;
}

} // namespace openspace
