/*****************************************************************************************
 *                                                                                       *
 * OpenSpace                                                                             *
 *                                                                                       *
 * Copyright (c) 2014-2020                                                               *
 *                                                                                       *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this  *
 * software and associated documentation files (the "Software"), to deal in the Software *
 * without restriction, including without limitation the rights to use, copy, modify,    *
 * merge, publish, distribute, sublicense, and/or sell copies of the Software, and to    *
 * permit persons to whom the Software is furnished to do so, subject to the following   *
 * conditions:                                                                           *
 *                                                                                       *
 * The above copyright notice and this permission notice shall be included in all copies *
 * or substantial portions of the Software.                                              *
 *                                                                                       *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,   *
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A         *
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT    *
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF  *
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE  *
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                                         *
 ****************************************************************************************/

#ifndef __OPENSPACE_MODULE_SPACECRAFTINSTRUMENTS___RENDERABLESHADOWCYLINDER___H__
#define __OPENSPACE_MODULE_SPACECRAFTINSTRUMENTS___RENDERABLESHADOWCYLINDER___H__

#include <openspace/rendering/renderable.h>

#include <openspace/properties/optionproperty.h>
#include <openspace/properties/stringproperty.h>
#include <openspace/properties/scalar/intproperty.h>
#include <openspace/properties/scalar/floatproperty.h>
#include <openspace/properties/vector/vec3property.h>

#include <ghoul/opengl/ghoul_gl.h>
#include <ghoul/opengl/uniformcache.h>

namespace ghoul::opengl { class ProgramObject; }

namespace openspace {

namespace documentation { struct Documentation; }

struct RenderData;
struct UpdateData;

class RenderableShadowCylinder : public Renderable {
public:
    RenderableShadowCylinder(const ghoul::Dictionary& dictionary);

    void initializeGL() override;
    void deinitializeGL() override;

    bool isReady() const override;
    void render(const RenderData& data, RendererTasks& rendererTask) override;
    void update(const UpdateData& data) override;

    static documentation::Documentation Documentation();

private:
    struct CylinderVBOLayout {
        float x = 0.f;
        float y = 0.f;
        float z = 0.f;
        float e = 0.f;
    };

    void createCylinder(double time);

    properties::IntProperty _numberOfPoints;
    properties::FloatProperty _shadowLength;
    properties::Vec3Property _shadowColor;
    properties::OptionProperty _terminatorType;
    properties::StringProperty _lightSource;
    properties::StringProperty _observer;
    properties::StringProperty _body;
    properties::StringProperty _bodyFrame;
    properties::OptionProperty _aberration;

    ghoul::opengl::ProgramObject* _shader = nullptr;
    UniformCache(modelViewProjectionTransform, shadowColor, opacity) _uniformCache;

    glm::dmat3 _stateMatrix = glm::dmat3(1.0);

    GLuint _vao = 0;
    GLuint _vbo = 0;

    std::vector<CylinderVBOLayout> _vertices;
};

} // namespace openspace

#endif // __OPENSPACE_MODULE_SPACECRAFTINSTRUMENTS___RENDERABLESHADOWCYLINDER___H__
