
    #version __CONTEXT__

    in vec2 texCoords;
    in vec2 outlineTexCoords;

    out vec4 FragColor;

    uniform sampler2D tex;
    uniform vec4 baseColor;
    uniform vec4 outlineColor;
    uniform bool hasOutline;

    void main() {
        if (hasOutline) {
            float inside = texture(tex, texCoords).r;
            float outline = texture(tex, outlineTexCoords).r;
            vec4 blend = mix(outlineColor, baseColor, inside);
            FragColor = blend * vec4(1.0, 1.0, 1.0, max(inside, outline));
        }
        else {
            FragColor = vec4(baseColor.rgb, baseColor.a * texture(tex, texCoords).r);
        }
    }