
    #version __CONTEXT__

    layout (location = 0) in vec3 in_position;
    layout (location = 1) in vec2 in_texCoords;
    layout (location = 2) in vec2 in_outlineTexCoords;

    out vec2 texCoords;
    out vec2 outlineTexCoords;

    uniform dmat4 mvpMatrix;
    uniform dmat4 modelViewTransform;

    out float depth;
    out vec3 vsPosition;
    void main() {
        texCoords = in_texCoords;
        outlineTexCoords = in_outlineTexCoords;
        vec4 finalPos = vec4(mvpMatrix * dvec4(in_position.xyz, 1.0));
        depth = finalPos.w;
        finalPos.z = 0.0;
        vsPosition = vec3(modelViewTransform * dvec4(in_position.xyz, 1.0));
        gl_Position = finalPos;
    }