
#version __CONTEXT__

#include "fragment.glsl"

uniform bool hasTexture = false;
uniform bvec2 shouldFlipTexture = bvec2(false, false);
uniform sampler2D tex;
uniform vec4 color = vec4(1.0, 1.0, 1.0, 1.0);

in float depth;
in vec2 out_uv;
in vec4 out_color;

out vec4 FragColor;

void main() {
    if (hasTexture) {
        vec2 uv = out_uv;
        if (shouldFlipTexture.x) {
            uv.x = 1.0 - uv.x;
        }
        if (shouldFlipTexture.y) {
            uv.y = 1.0 - uv.y;
        }
        FragColor = out_color * color * texture(tex, uv);
    }
    else {
        FragColor = out_color * color;
    }
}
