<?xml version='1.0' encoding='UTF-8'?>
<Folder
  Browseable="True"
  Group="Explorer"
  Name="JWST"
  Searchable="False"
  Thumbnail="http://cdn.worldwidetelescope.org/thumbnails/jwst.jpg"
  Type="Sky"
>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="DOR"
    DataSetType="Sky"
    Dec="-69.0952628486634"
    Magnitude="0"
    Name="Tarantula Nebula (NIRCam Image)"
    Opacity="100"
    RA="5.646556429159745"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/09_jwst/weic2212a/thumb.jpg"
    ZoomLevel="0.7153023739291948"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13648989903120679"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.698360507255"
        CenterY="-69.095265930274"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Tarantula Nebula (NIRCam Image)"
        OffsetX="4.165341156958215e-06"
        OffsetY="4.165341156958215e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-13.457358852842315"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/packages/2022/09_jwst/weic2212a/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA, ESA, CSA, and STScI</Credits>
        <CreditsUrl>https://esawebb.org/images/weic2212a/</CreditsUrl>
        <Description>In this mosaic image stretching 340 light-years across, Webb’s Near-Infrared Camera (NIRCam) displays the Tarantula Nebula star-forming region in a new light, including tens of thousands of never-before-seen young stars that were previously shrouded in cosmic dust. The most active region appears to sparkle with massive young stars, appearing pale blue. Scattered among them are still-embedded stars, appearing red, yet to emerge from the dusty cocoon of the nebula. NIRCam is able to detect these dust-enshrouded stars thanks to its unprecedented resolution at near-infrared wavelengths. To the upper left of the cluster of young stars, and the top of the nebula’s cavity, an older star prominently displays NIRCam’s distinctive eight diffraction spikes, an artefact of the telescope’s structure. Following the top central spike of this star upward, it almost points to a distinctive bubble in the cloud. Young stars still surrounded by dusty material are blowing this bubble, beginning to carve out their own cavity. Astronomers used two of Webb’s spectrographs to take a closer look at this region and determine the chemical makeup of the star and its surrounding gas. This spectral information will tell astronomers about the age of the nebula and how many generations of star birth it has seen. Farther from the core region of hot young stars, cooler gas takes on a rust colour, telling astronomers that the nebula is rich with complex hydrocarbons. This dense gas is the material that will form future stars. As winds from the massive stars sweep away gas and dust, some of it will pile up and, with gravity’s help, form new stars.</Description>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/09_jwst/weic2212a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="DOR"
    DataSetType="Sky"
    Dec="-69.0924495620627"
    Magnitude="0"
    Name="Tarantula Nebula (MIRI Image)"
    Opacity="100"
    RA="5.645326226004792"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/09_jwst/weic2212b/thumb.jpg"
    ZoomLevel="0.33000088248955006"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06256751720441024"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="84.679936129291"
        CenterY="-69.092464860613"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Tarantula Nebula (MIRI Image)"
        OffsetX="1.527527275498297e-05"
        OffsetY="1.527527275498297e-05"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="0.08735812730011287"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/packages/2022/09_jwst/weic2212b/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits> NASA, ESA, CSA, and STScI</Credits>
        <CreditsUrl>https://esawebb.org/images/weic2212b/</CreditsUrl>
        <Description>At the longer wavelengths of light captured by its Mid-Infrared Instrument (MIRI), Webb focuses on the area surrounding the central star cluster and unveils a very different view of the Tarantula Nebula. In this light, the young hot stars of the cluster fade in brilliance, and glowing gas and dust come forward. Abundant hydrocarbons light up the surfaces of the dust clouds, shown in blue and purple. Much of the nebula takes on a more ghostly, diffuse appearance because mid-infrared light is able to show more of what is happening deeper inside the clouds. Still-embedded protostars pop into view within their dusty cocoons, including a bright group at the very top edge of the image, left of centre. Other areas appear dark, like in the lower-right corner of the image. This indicates the densest areas of dust in the nebula, that even mid-infrared wavelengths cannot penetrate. These could be the sites of future, or current, star formation. MIRI was contributed by ESA and NASA, with the instrument designed and built by a consortium of nationally funded European Institutes (The MIRI European Consortium) in partnership with JPL and the University of Arizona.</Description>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/09_jwst/weic2212b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="PSC"
    DataSetType="Sky"
    Dec="15.780423545707809"
    Magnitude="0"
    Name="Webb Inspects the Heart of the Phantom Galaxy"
    Opacity="100"
    RA="1.6116250464859263"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/08_jwst/potm2208a/thumb.jpg"
    ZoomLevel="0.45"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06325540930640385"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="24.1735269215604"
        CenterY="15.7827400082881"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Webb Inspects the Heart of the Phantom Galaxy"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-110.07250040209001"
        Sparse="False"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/packages/2022/08_jwst/potm2208a/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>ESA/Webb, NASA &amp; CSA, J. Lee and the PHANGS-JWST Team. Acknowledgement: J. Schmidt</Credits>
        <CreditsUrl>https://esawebb.org/images/potm2208a/</CreditsUrl>
        <Description>This image from the NASA/ESA/CSA James Webb Space Telescope shows the heart of M74, otherwise known as the Phantom Galaxy. Webb’s sharp vision has revealed delicate filaments of gas and dust in the grandiose spiral arms which wind outwards from the centre of this image. A lack of gas in the nuclear region also provides an unobscured view of the nuclear star cluster at the galaxy's centre. M74 is a particular class of spiral galaxy known as a ‘grand design spiral’, meaning that its spiral arms are prominent and well-defined, unlike the patchy and ragged structure seen in some spiral galaxies. The Phantom Galaxy is around 32 million light-years away from Earth in the constellation Pisces, and lies almost face-on to Earth. This, coupled with its well-defined spiral arms, makes it a favourite target for astronomers studying the origin and structure of galactic spirals. Webb gazed into M74 with its Mid-InfraRed Instrument (MIRI) in order to learn more about the earliest phases of star formation in the local Universe. These observations are part of a larger effort to chart 19 nearby star-forming galaxies in the infrared by the international PHANGS collaboration. Those galaxies have already been observed using the NASA/ESA Hubble Space Telescope and ground-based observatories. The addition of crystal-clear Webb observations at longer wavelengths will allow astronomers to pinpoint star-forming regions in the galaxies, accurately measure the masses and ages of star clusters, and gain insights into the nature of the small grains of dust drifting in interstellar space.Hubble observations of M74 have revealed particularly bright areas of star formation known as HII regions. Hubble’s sharp vision at ultraviolet and visible wavelengths complements Webb’s unparalleled sensitivity at infrared wavelengths, as do observations from ground-based radio telescopes such as the Atacama Large Millimeter/submillimeter Array, ALMA. By combining data from telescopes operating across the electromagnetic spectrum, scientists can gain greater insight into astronomical objects than by using a single observatory — even one as powerful as Webb! MIRI was contributed by ESA and NASA, with the instrument designed and built by a consortium of nationally funded European Institutes (the MIRI European Consortium) in partnership with JPL and the University of Arizona. Links  Pan of the Phantom Galaxy Hubble and Webb Showcase M74 Pan of Combined optical/mid-infrared image of M74 (Hubble and Webb) Image B Image C </Description>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/08_jwst/potm2208a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="PSC"
    DataSetType="Sky"
    Dec="15.780423545707809"
    Magnitude="0"
    Name="The Phantom Galaxy Across the Spectrum"
    Opacity="100"
    RA="1.6116250464859263"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/08_jwst/potm2208b/thumb.jpg"
    ZoomLevel="0.45"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.09113423618609526"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="24.174379141634"
        CenterY="15.780430679732"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="The Phantom Galaxy Across the Spectrum"
        OffsetX="5.562392345343197e-06"
        OffsetY="5.562392345342728e-06"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-110.07999999999974"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/packages/2022/08_jwst/potm2208b/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>ESA/Webb, NASA &amp; CSA, J. Lee and the PHANGS-JWST Team; ESA/Hubble &amp; NASA, R. Chandar. Acknowledgement: J. Schmidt</Credits>
        <CreditsUrl>https://esawebb.org/images/potm2208b/</CreditsUrl>
        <Description>M74 shines at its brightest in this combined optical/mid-infrared image, featuring data from both the NASA/ESA Hubble Space Telescope and the NASA/ESA/CSA James Webb Space Telescope. With Hubble’s venerable Advanced Camera for Surveys (ACS) and Webb’s powerful Mid-InfraRed Instrument (MIRI) capturing a range of wavelengths, this new image has remarkable depth. The red colours mark dust threaded through the arms of the galaxy, lighter oranges being areas of hotter dust. The young stars throughout the arms and the nuclear core are picked out in blue. Heavier, older stars towards the galaxy’s centre are shown in cyan and green, projecting a spooky glow from the core of the Phantom Galaxy. Bubbles of star formation are also visible in pink across the arms. Such a variety of galactic features is rare to see in a single image. Scientists combine data from telescopes operating across the electromagnetic spectrum to truly understand astronomical objects. In this way, data from Hubble and Webb compliment each other to provide a comprehensive view of the spectacular M74 galaxy. Links  Pan of the Phantom Galaxy Hubble and Webb Showcase M74 Pan of Combined optical/mid-infrared image of M74 (Hubble and Webb) Image A Image C </Description>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/08_jwst/potm2208b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="BOO"
    DataSetType="Sky"
    Dec="52.9112674947119"
    Magnitude="0"
    Name="CEERS NIRCam 220804"
    Opacity="100"
    RA="14.3262647334323"
    Rotation="-0.860796387083604"
    Thumbnail="http://data1.wwtassets.org/packages/2022/08_jwst/ceers_nircam/thumb.jpg"
    ZoomLevel="0.997078409949675"
  >
    <Description>Two new images from NASA's James Webb Space Telescope show what may be among the earliest galaxies ever observed. Both images include objects from more than 13 billion years ago, and one offers a much wider field of view than Webb's First Deep Field image, which was released amid great fanfare July 12. The images represent some of the first out of a major collaboration of astronomers and other academic researchers teaming with NASA and global partners to uncover new insights about the universe.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="IR"
        BaseDegreesPerTile="0.27326404667707516"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="214.9171906825857"
        CenterY="52.901998632045"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="CEERS NIRCam 220804"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-49.74000000000036"
        Sparse="True"
        StockSet="False"
        TileLevels="7"
        Url="http://data1.wwtassets.org/packages/2022/08_jwst/ceers_nircam/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA/STScI/CEERS/TACC/S. Finkelstein/G. Yang./C. Papovich/Z. Levay</Credits>
        <CreditsUrl>https://cns.utexas.edu/news/widest-view-of-early-universe-hints-at-galaxy-among-the-earliest-ever-detected</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/08_jwst/ceers_nircam/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="SCL"
    DataSetType="Sky"
    Dec="-33.71323492947051"
    Magnitude="0"
    Name="Cartwheel Galaxy (JWST NIRCam and MIRI Composite Image)"
    Opacity="100"
    RA="0.6282314953373124"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/08_jwst/cartwheel/thumb.jpg"
    ZoomLevel="0.25"
  >
    <Description>&lt;p&gt;This image of the Cartwheel and its companion galaxies is a composite from Webb’s Near-Infrared Camera (NIRCam) and Mid-Infrared Instrument (MIRI), which reveals details that are difficult to see in the individual images alone.&lt;/p&gt; &lt;p&gt;This galaxy formed as the result of a high-speed collision that occurred about 400 million years ago. The Cartwheel is composed of two rings, a bright inner ring and a colorful outer ring. Both rings expand outward from the center of the collision like shockwaves.&lt;/p&gt; &lt;p&gt;However, despite the impact, much of the character of the large, spiral galaxy that existed before the collision remains, including its rotating arms. This leads to the “spokes” that inspired the name of the Cartwheel Galaxy, which are the bright red streaks seen between the inner and outer rings. These brilliant red hues, located not only throughout the Cartwheel, but also the companion spiral galaxy at the top left, are caused by glowing, hydrocarbon-rich dust.&lt;/p&gt; &lt;p&gt;In this near- and mid-infrared composite image, MIRI data are colored red while NIRCam data are colored blue, orange, and yellow. Amidst the red swirls of dust, there are many individual blue dots, which represent individual stars or pockets of star formation. NIRCam also defines the difference between the older star populations and dense dust in the core and the younger star populations outside of it.&lt;/p&gt; &lt;p&gt;Webb’s observations capture the Cartwheel in a very transitory stage. The form that the Cartwheel Galaxy will eventually take, given these two competing forces, is still a mystery. However, this snapshot provides perspective on what happened to the galaxy in the past and what it will do in the future.&lt;/p&gt;</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="IR"
        BaseDegreesPerTile="0.06826499576553885"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="9.42321092732"
        CenterY="-33.71306150293"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Cartwheel Galaxy (JWST NIRCam and MIRI Composite Image)"
        OffsetX="-0.00011075975428868112"
        OffsetY="-0.00025519827378850607"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-27.974015276436532"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/packages/2022/08_jwst/cartwheel/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA, ESA, CSA, STScI, Webb ERO Production Team</Credits>
        <CreditsUrl>https://webbtelescope.org/contents/news-releases/2022/news-2022-039</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/08_jwst/cartwheel/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="CAR"
    DataSetType="Sky"
    Dec="-58.620167596399455"
    Magnitude="0"
    Name="JWST Carina NIRCam"
    Opacity="100"
    RA="10.614202486602357"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/07_jwst/carina_nircam/thumb.jpg"
    ZoomLevel="0.7175138317174115"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13653881984592092"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="159.21261854583"
        CenterY="-58.62001801087"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="JWST Carina NIRCam"
        OffsetX="-9.676683405186081e-05"
        OffsetY="0.0002460841694251934"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="102.98491848225136"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/packages/2022/07_jwst/carina_nircam/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA, ESA, CSA, STScI, Webb ERO Production Team</Credits>
        <CreditsUrl>https://webbtelescope.org/contents/news-releases/2022/news-2022-031</CreditsUrl>
        <Description>What looks much like craggy mountains on a moonlit evening is actually the edge of a nearby, young, star-forming region NGC 3324 in the Carina Nebula. Captured in infrared light by the Near-Infrared Camera (NIRCam) on NASA’s James Webb Space Telescope, this image reveals previously obscured areas of star birth.
Called the Cosmic Cliffs, the region is actually the edge of a gigantic, gaseous cavity within NGC 3324, roughly 7,600 light-years away. The cavernous area has been carved from the nebula by the intense ultraviolet radiation and stellar winds from extremely massive, hot, young stars located in the center of the bubble, above the area shown in this image. The high-energy radiation from these stars is sculpting the nebula’s wall by slowly eroding it away.  
NIRCam – with its crisp resolution and unparalleled sensitivity – unveils hundreds of previously hidden stars, and even numerous background galaxies. Several prominent features in this image are described below.
•	The “steam” that appears to rise from the celestial “mountains” is actually hot, ionized gas and hot dust streaming away from the nebula due to intense, ultraviolet radiation. 
•	Dramatic pillars rise above the glowing wall of gas, resisting the blistering ultraviolet radiation from the young stars.
•	Bubbles and cavities are being blown by the intense radiation and stellar winds of newborn stars.
•	Protostellar jets and outflows, which appear in gold, shoot from dust-enshrouded, nascent stars.
•	A “blow-out” erupts at the top-center of the ridge, spewing gas and dust into the interstellar medium. 
•	An unusual “arch” appears, looking like a bent-over cylinder.
This period of very early star formation is difficult to capture because, for an individual star, it lasts only about 50,000 to 100,000 years – but Webb’s extreme sensitivity and exquisite spatial resolution have chronicled this rare event.
Located roughly 7,600 light-years away, NGC 3324 was first catalogued by James Dunlop in 1826. Visible from the Southern Hemisphere, it is located at the northwest corner of the Carina Nebula (NGC 3372), which resides in the constellation Carina. The Carina Nebula is home to the Keyhole Nebula and the active, unstable supergiant star called Eta Carinae. 
NIRCam was built by a team at the University of Arizona and Lockheed Martin’s Advanced Technology Center.</Description>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/07_jwst/carina_nircam/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="CAR"
    DataSetType="Sky"
    Dec="-58.620167596399455"
    Magnitude="0"
    Name="JWST Carina MIRI"
    Opacity="100"
    RA="10.614202486602357"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/07_jwst/carina_miri/thumb.jpg"
    ZoomLevel="0.7175138317174115"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13608475168336676"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="159.225778067319"
        CenterY="-58.6133228431339"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="JWST Carina MIRI"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="117.79623295101801"
        Sparse="False"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/packages/2022/07_jwst/carina_miri/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/07_jwst/carina_miri/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="VEL"
    DataSetType="Sky"
    Dec="-40.43593551739831"
    Magnitude="0"
    Name="JWST Southern Ring Nebula (MIRI)"
    Opacity="100"
    RA="10.117059441311776"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/07_jwst/jwst_s_ring_miri/thumb.jpg"
    ZoomLevel="0.3826336529248513"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06263730715855399"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="151.75342140040956"
        CenterY="-40.435283048321544"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="JWST Southern Ring Nebula (MIRI)"
        OffsetX="0.0004614603238030514"
        OffsetY="0.002670092708239829"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="124.75158258895605"
        Sparse="True"
        StockSet="False"
        TileLevels="3"
        Url="http://data1.wwtassets.org/packages/2022/07_jwst/jwst_s_ring_miri/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA, ESA, CSA, STScI, Webb ERO Production Team</Credits>
        <CreditsUrl>https://webbtelescope.org/contents/news-releases/2022/news-2022-033</CreditsUrl>
        <Description>NASA’s Webb Telescope has revealed the cloak of dust around the second star, shown at left in red, at the center of the Southern Ring Nebula for the first time. It is a hot, dense white dwarf star. 

As it transformed into a white dwarf, the star periodically ejected mass – the shells of material you see here. As if on repeat, it contracted, heated up – and then, unable to push out more material, pulsated. 

At this stage, it should have shed its last layers. So why is the red star still cloaked in dust? Was material transferred from its companion? Researchers will begin to pursue answers soon.

The bluer star at right in this image has also shaped the scene. It helps stir up the ejected material. The disk around the stars is also wobbling, shooting out spirals of gas and dust over long periods of time. This scene is like witnessing a rotating sprinkler that’s finished shooting out material in all directions over thousands of years.

Webb captured this scene in mid-infrared light – which can only be observed from space. Mid-infrared light helps researchers detect objects enshrouded in dust, like the red star. 

This Mid-Infrared Instrument (MIRI) image also offers an incredible amount of detail, including a cache of distant galaxies in the background. Most of the multi-colored points of light are galaxies, not stars. Tiny triangles mark the circular edges of stars, including a blue one within the nebula’s red bottom-most edges, while galaxies look like misshapen circles, straight lines, and spirals.

For a full array of Webb’s first images and spectra, including downloadable files, please visit: https://webbtelescope.org/news/first-images 

MIRI was contributed by ESA and NASA, with the instrument designed and built by a consortium of nationally funded European Institutes (The MIRI European Consortium) in partnership with JPL and the University of Arizona.</Description>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/07_jwst/jwst_s_ring_miri/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="VEL"
    DataSetType="Sky"
    Dec="-40.43593551739831"
    Magnitude="0"
    Name="JWST Southern Ring Nebula (NIRCam)"
    Opacity="100"
    RA="10.117059441311776"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/07_jwst/jwst_s_ring_nircam/thumb.jpg"
    ZoomLevel="0.3826336529248513"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0682753480655798"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="151.7570552015"
        CenterY="-40.43643336052"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="JWST Southern Ring Nebula (NIRCam)"
        OffsetX="0.0001300159024991165"
        OffsetY="-0.0010076180875328632"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="111.98888905823296"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/packages/2022/07_jwst/jwst_s_ring_nircam/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA, ESA, CSA, STScI, Webb ERO Production Team</Credits>
        <CreditsUrl>https://webbtelescope.org/contents/news-releases/2022/news-2022-033</CreditsUrl>
        <Description>The bright star at the center of NGC 3132, while prominent when viewed by NASA’s Webb Telescope in near-infrared light, plays a supporting role in sculpting the surrounding nebula. A second star, barely visible at lower left along one of the bright star’s diffraction spikes, is the nebula’s source. It has ejected at least eight layers of gas and dust over thousands of years.

But the bright central star visible here has helped “stir” the pot, changing the shape of this planetary nebula’s highly intricate rings by creating turbulence. The pair of stars are locked in a tight orbit, which leads the dimmer star to spray ejected material in a range of directions as they orbit one another, resulting in these jagged rings.

Hundreds of straight, brightly-lit lines pierce through the rings of gas and dust. These “spotlights” emanate from the bright star and stream through holes in the nebula like sunlight through gaps in a cloud.

But not all of the starlight can escape. The density of the central region, set off in teal, is reflected by how transparent or opaque it is. Areas that are a deeper teal indicate that the gas and dust are denser – and light is unable to break free.

Data from Webb’s Near-Infrared Camera (NIRCam) were used to make this extremely detailed image. It is teeming with scientific information – and research will begin following its release.

This is not only a crisp image of a planetary nebula – it also shows us objects in the vast distances of space behind it. The transparent red sections of the planetary nebula – and all the areas outside it – are filled with distant galaxies. 

Look for the bright angled line at the upper left. It is not starlight – it is a faraway galaxy seen edge-on. Distant spirals, of many shapes and colors, also dot the scene. Those that are farthest away – or very dusty – are small and red.

For a full array of Webb’s first images and spectra, including downloadable files, please visit: https://webbtelescope.org/news/first-images 

NIRCam was built by a team at the University of Arizona and Lockheed Martin’s Advanced Technology Center.</Description>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/07_jwst/jwst_s_ring_nircam/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="PEG"
    DataSetType="Sky"
    Dec="33.9621954626131"
    Magnitude="0"
    Name="JWST Stephan's Quintet (NIRCam and MIRI)"
    Opacity="100"
    RA="22.6001036467436"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/07_jwst/weic2208a/thumb.jpg"
    ZoomLevel="1.031446312671409"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.13656329708830614"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="338.957209422"
        CenterY="33.9614640787"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="JWST Stephan's Quintet (NIRCam and MIRI)"
        OffsetX="-0.0165777055597548"
        OffsetY="0.029078594982448"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="61.94540334829502"
        Sparse="True"
        StockSet="False"
        TileLevels="6"
        Url="http://data1.wwtassets.org/packages/2022/07_jwst/weic2208a/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA, ESA, CSA, STScI, Webb ERO Production Team</Credits>
        <CreditsUrl>https://webbtelescope.org/contents/news-releases/2022/news-2022-034</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/07_jwst/weic2208a/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="PEG"
    DataSetType="Sky"
    Dec="33.9621954626131"
    Magnitude="0"
    Name="JWST Stephan's Quintet (MIRI)"
    Opacity="100"
    RA="22.6001036467436"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/07_jwst/weic2208b/thumb.jpg"
    ZoomLevel="1.031446312671409"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.12519334465700208"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="339.006091227726"
        CenterY="33.9598767383477"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="JWST Stephan's Quintet MIRI"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="63.0269001983675"
        Sparse="False"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/packages/2022/07_jwst/weic2208b/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/07_jwst/weic2208b/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="VOL"
    DataSetType="Sky"
    Dec="-73.45389956415659"
    Magnitude="0"
    Name="JWST SMACS 0723"
    Opacity="100"
    RA="7.388518370448916"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/07_jwst/smacs0723/thumb.jpg"
    ZoomLevel="0.39337455578028513"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.06824517526732732"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="110.785677941"
        CenterY="-73.4497732804"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Webb Delivers Deepest Infrared Image of Universe Yet: SMACS 0723"
        OffsetX="-0.0074597408661543655"
        OffsetY="-0.010255996337093122"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-34.968546008628586"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/packages/2022/07_jwst/smacs0723/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA, ESA, CSA, STScI, Webb ERO Production Team</Credits>
        <CreditsUrl>https://webbtelescope.org/contents/news-releases/2022/news-2022-035</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/07_jwst/smacs0723/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="CRB"
    DataSetType="Sky"
    Dec="28.44510984425"
    Magnitude="0"
    Name="Webb’s Fine Guidance Sensor Provides a Preview"
    Opacity="100"
    RA="16.3973759650016"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/07_jwst/jwst_fgs_preview/thumb.jpg"
    ZoomLevel="0.5209518574162532"
  >
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.0783219477164671"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="245.960639475024"
        CenterY="28.44510984425"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="Webb’s Fine Guidance Sensor Provides a Preview"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-157.864616609149"
        Sparse="False"
        StockSet="False"
        TileLevels="4"
        Url="http://data1.wwtassets.org/packages/2022/07_jwst/jwst_fgs_preview/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA/CSA/FGS Team</Credits>
        <CreditsUrl>https://blogs.nasa.gov/webb/2022/07/06/webbs-fine-guidance-sensor-provides-a-preview/</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/07_jwst/jwst_fgs_preview/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
  <Place
    Angle="0"
    AngularSize="0"
    Constellation="DRA"
    DataSetType="Sky"
    Dec="65.85822835386412"
    Magnitude="0"
    Name="JWST Telescope Alignment Evaluation Image"
    Opacity="100"
    RA="17.92733512725823"
    Rotation="0"
    Thumbnail="http://data1.wwtassets.org/packages/2022/03_jwst_taei/thumb.jpg"
    ZoomLevel="0.5"
  >
    <Description>While the purpose of this image was to focus on the bright star at the center for alignment evaluation, Webb's optics and NIRCam are so sensitive that the galaxies and stars seen in the background show up. At this stage of Webb’s mirror alignment, known as “fine phasing,” each of the primary mirror segments have been adjusted to produce one unified image of the same star using only the NIRCam instrument. This image of the star, which is called 2MASS J17554042+6551277, uses a red filter to optimize visual contrast. | Astrometric solution by Gabe Brammer.</Description>
    <ForegroundImageSet>
      <ImageSet
        BandPass="Visible"
        BaseDegreesPerTile="0.07140166377929005"
        BaseTileLevel="0"
        BottomsUp="False"
        CenterX="268.89940309321"
        CenterY="65.86811269447"
        DataSetType="Sky"
        ElevationModel="False"
        FileType=".png"
        Generic="False"
        Name="JWST Telescope Alignment Evaluation Image"
        OffsetX="0.009355139575007035"
        OffsetY="-0.005390190403045801"
        Projection="Tan"
        QuadTreeMap=""
        Rotation="-83.78134847776201"
        Sparse="True"
        StockSet="False"
        TileLevels="5"
        Url="http://data1.wwtassets.org/packages/2022/03_jwst_taei/{1}/{3}/{3}_{2}.png"
        WidthFactor="2"
      >
        <Credits>NASA/STScI; astrometric solution by Gabe Brammer</Credits>
        <CreditsUrl>https://github.com/gbrammer/jwst_EERS</CreditsUrl>
        <ThumbnailUrl>http://data1.wwtassets.org/packages/2022/03_jwst_taei/thumb.jpg</ThumbnailUrl>
      </ImageSet>
    </ForegroundImageSet>
  </Place>
</Folder>
