var data = {"documentation":[{"data":[{"description":"The 100 (or so) satellites that will appear brightest when viewed\n      from Earth.","name":"100 Brightest","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.BrightestSatellites.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.BrightestSatellites.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.BrightestSatellites.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.BrightestSatellites.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.BrightestSatellites.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.BrightestSatellites.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.BrightestSatellites.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.BrightestSatellites.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.BrightestSatellites.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.BrightestSatellites.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.BrightestSatellites.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.BrightestSatellites.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.BrightestSatellites.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.BrightestSatellites.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.BrightestSatellites.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.BrightestSatellites.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.BrightestSatellites.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.BrightestSatellites.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"If enabled, the contiguous set of objects starting from StartRenderIdx of size RenderSize will be rendered. If disabled, the number of objects defined by UpperLimit will rendered from an evenly dispersed sample of the full length of the data file.","identifier":"ContiguousMode","name":"Contiguous Mode","type":"BoolProperty","uri":"Scene.BrightestSatellites.Renderable.ContiguousMode"},{"description":"Number of objects to render sequentially from StartRenderIdx.","identifier":"RenderSize","name":"Contiguous Size of Render Block","type":"UIntProperty","uri":"Scene.BrightestSatellites.Renderable.RenderSize"},{"description":"Index of the first object in the block to render (all prior objects will be ignored). The block of objects to render will be determined by StartRenderIdx and RenderSize.","identifier":"StartRenderIdx","name":"Contiguous Starting Index of Render","type":"UIntProperty","uri":"Scene.BrightestSatellites.Renderable.StartRenderIdx"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.BrightestSatellites.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.BrightestSatellites.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.BrightestSatellites.Renderable.Fade"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.BrightestSatellites.Renderable.Opacity"},{"description":"The file path to the data file to read.","identifier":"Path","name":"Path","type":"StringProperty","uri":"Scene.BrightestSatellites.Renderable.Path"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.BrightestSatellites.Renderable.Type"},{"description":"A segment quality value for the orbital trail. A value from 1 (lowest) to 10 (highest) that controls the number of line segments in the rendering of the orbital trail. This does not control the direct number of segments because these automatically increase according to the eccentricity of the orbit.","identifier":"SegmentQuality","name":"Segment Quality","type":"UIntProperty","uri":"Scene.BrightestSatellites.Renderable.SegmentQuality"}],"propertyOwners":[{"description":"Appearance of RenderableOrbitalKepler","name":"Appearance","properties":[{"description":"The RGB main color for the trails and points.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.BrightestSatellites.Renderable.Appearance.Color"},{"description":"If true, the Max Size property will be used as an upper limit for the size of the point. This reduces the size of the points when approaching them, so that they stick to a maximum visual size depending on the Max Size value.","identifier":"EnableMaxSize","name":"Enable Max Size","type":"BoolProperty","uri":"Scene.BrightestSatellites.Renderable.Appearance.EnableMaxSize"},{"description":"Determines if the points should be rendered with an outline or not.","identifier":"EnableOutline","name":"Enable Point Outline","type":"BoolProperty","uri":"Scene.BrightestSatellites.Renderable.Appearance.EnableOutline"},{"description":"Controls the maximum allowed size for the points, when the max size control feature is enabled. This limits the visual size of the points based on the distance to the camera. The larger the value, the larger the points are allowed to be. In the background, the computations are made to limit the size of the angle between the CameraToPointMid and CameraToPointEdge vectors.","identifier":"MaxSize","name":"Max Size","type":"FloatProperty","uri":"Scene.BrightestSatellites.Renderable.Appearance.MaxSize"},{"description":"The color of the outline.","identifier":"OutlineColor","name":"Outline Color","type":"Vec3Property","uri":"Scene.BrightestSatellites.Renderable.Appearance.OutlineColor"},{"description":"Determines the thickness of the outline. A value of 0 will not show any outline, while a value of 1 will cover the whole point.","identifier":"OutlineWidth","name":"Outline Width","type":"FloatProperty","uri":"Scene.BrightestSatellites.Renderable.Appearance.OutlineWidth"},{"description":"An exponential scale value to set the absolute size of the point.","identifier":"PointSizeExponent","name":"Point Size Exponent","type":"FloatProperty","uri":"Scene.BrightestSatellites.Renderable.Appearance.PointSizeExponent"},{"description":"Determines how the trail should be rendered. If 'Trail' is selected, only the line part is visible, if 'Point' is selected, only the current satellite/debris point is visible.","identifier":"Rendering","name":"Rendering Mode","type":"OptionProperty","uri":"Scene.BrightestSatellites.Renderable.Appearance.Rendering"},{"description":"Determines how fast the trail fades out. A smaller number shows less of the trail and a larger number shows more.","identifier":"TrailFade","name":"Trail Fade","type":"FloatProperty","uri":"Scene.BrightestSatellites.Renderable.Appearance.TrailFade"},{"description":"The line width used for the trail, if the selected rendering method includes lines. If the rendering mode is set to Points, this value is ignored.","identifier":"TrailWidth","name":"Trail Width","type":"FloatProperty","uri":"Scene.BrightestSatellites.Renderable.Appearance.TrailWidth"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableOrbitalKepler"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.BrightestSatellites.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.BrightestSatellites.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.BrightestSatellites.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["earth_satellites"],"type":"SceneGraphNode"},{"description":"","name":"100kly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.100klyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.100klyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.100klyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.100klyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.100klyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.100klyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.100klyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.100klyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.100klyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.100klyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.100klyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.100klyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.100klyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.100klyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.100klyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.100klyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.100klyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.100klyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.100klyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.100klyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.100klyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.100klyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.100klyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.100klyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.100klyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.100klyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.100klyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.100klyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.100klyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.100klyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.100klyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.100klyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.100klyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.100klyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.100klyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.100klyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.100klyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.100klyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.100klyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.100klyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.100klyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"100ly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.100lyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.100lyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.100lyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.100lyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.100lyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.100lyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.100lyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.100lyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.100lyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.100lyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.100lyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.100lyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.100lyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.100lyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.100lyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.100lyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.100lyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.100lyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.100lyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.100lyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.100lyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.100lyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.100lyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.100lyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.100lyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.100lyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.100lyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.100lyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.100lyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.100lyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.100lyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.100lyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.100lyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.100lyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.100lyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.100lyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.100lyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.100lyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.100lyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.100lyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.100lyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"100Mly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.100MlyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.100MlyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.100MlyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.100MlyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.100MlyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.100MlyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.100MlyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.100MlyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.100MlyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.100MlyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.100MlyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.100MlyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.100MlyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.100MlyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.100MlyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.100MlyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.100MlyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.100MlyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.100MlyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.100MlyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.100MlyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.100MlyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.100MlyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.100MlyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.100MlyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.100MlyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.100MlyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.100MlyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.100MlyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.100MlyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.100MlyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.100MlyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.100MlyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.100MlyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.100MlyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.100MlyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.100MlyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.100MlyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.100MlyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.100MlyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.100MlyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"10kly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.10klyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.10klyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.10klyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.10klyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.10klyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.10klyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.10klyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.10klyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.10klyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.10klyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.10klyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.10klyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.10klyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.10klyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.10klyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.10klyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.10klyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.10klyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.10klyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.10klyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.10klyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.10klyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.10klyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.10klyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.10klyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.10klyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.10klyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.10klyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.10klyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.10klyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.10klyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.10klyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.10klyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.10klyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.10klyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.10klyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.10klyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.10klyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.10klyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.10klyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.10klyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"10ly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.10lyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.10lyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.10lyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.10lyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.10lyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.10lyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.10lyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.10lyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.10lyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.10lyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.10lyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.10lyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.10lyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.10lyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.10lyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.10lyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.10lyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.10lyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.10lyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.10lyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.10lyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.10lyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.10lyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.10lyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.10lyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.10lyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.10lyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.10lyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.10lyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.10lyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.10lyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.10lyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.10lyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.10lyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.10lyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.10lyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.10lyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.10lyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.10lyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.10lyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.10lyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"10Mly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.10MlyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.10MlyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.10MlyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.10MlyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.10MlyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.10MlyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.10MlyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.10MlyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.10MlyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.10MlyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.10MlyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.10MlyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.10MlyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.10MlyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.10MlyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.10MlyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.10MlyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.10MlyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.10MlyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.10MlyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.10MlyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.10MlyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.10MlyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.10MlyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.10MlyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.10MlyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.10MlyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.10MlyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.10MlyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.10MlyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.10MlyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.10MlyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.10MlyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.10MlyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.10MlyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.10MlyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.10MlyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.10MlyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.10MlyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.10MlyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.10MlyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"1kly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.1klyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.1klyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.1klyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.1klyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.1klyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.1klyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.1klyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.1klyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.1klyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.1klyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.1klyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.1klyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.1klyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.1klyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.1klyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.1klyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.1klyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.1klyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1klyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.1klyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1klyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1klyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.1klyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.1klyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.1klyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.1klyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.1klyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.1klyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1klyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.1klyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1klyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1klyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.1klyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1klyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.1klyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.1klyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1klyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.1klyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.1klyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.1klyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.1klyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"1ld Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.1ldGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.1ldGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.1ldGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.1ldGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.1ldGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.1ldGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.1ldGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.1ldGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.1ldGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.1ldGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.1ldGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.1ldGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.1ldGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.1ldGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.1ldGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.1ldGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.1ldGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.1ldGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1ldGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.1ldGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1ldGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1ldGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.1ldGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.1ldGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.1ldGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.1ldGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.1ldGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.1ldGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1ldGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.1ldGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1ldGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1ldGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.1ldGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1ldGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.1ldGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.1ldGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1ldGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.1ldGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.1ldGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.1ldGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.1ldGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"1lh Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.1lhGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.1lhGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.1lhGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.1lhGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.1lhGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.1lhGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.1lhGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.1lhGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.1lhGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.1lhGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.1lhGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.1lhGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.1lhGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.1lhGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.1lhGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.1lhGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.1lhGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.1lhGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1lhGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.1lhGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1lhGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1lhGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.1lhGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.1lhGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.1lhGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.1lhGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.1lhGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.1lhGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1lhGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.1lhGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1lhGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1lhGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.1lhGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1lhGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.1lhGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.1lhGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1lhGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.1lhGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.1lhGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.1lhGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.1lhGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"1lm Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.1lmGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.1lmGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.1lmGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.1lmGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.1lmGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.1lmGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.1lmGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.1lmGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.1lmGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.1lmGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.1lmGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.1lmGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.1lmGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.1lmGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.1lmGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.1lmGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.1lmGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.1lmGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1lmGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.1lmGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1lmGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1lmGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.1lmGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.1lmGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.1lmGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.1lmGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.1lmGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.1lmGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1lmGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.1lmGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1lmGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1lmGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.1lmGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1lmGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.1lmGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.1lmGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1lmGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.1lmGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.1lmGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.1lmGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.1lmGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"1ly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.1lyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.1lyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.1lyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.1lyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.1lyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.1lyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.1lyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.1lyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.1lyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.1lyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.1lyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.1lyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.1lyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.1lyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.1lyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.1lyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.1lyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.1lyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1lyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.1lyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1lyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1lyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.1lyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.1lyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.1lyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.1lyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.1lyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.1lyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1lyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.1lyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1lyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1lyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.1lyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1lyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.1lyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.1lyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1lyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.1lyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.1lyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.1lyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.1lyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"1Mly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.1MlyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.1MlyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.1MlyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.1MlyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.1MlyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.1MlyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.1MlyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.1MlyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.1MlyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.1MlyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.1MlyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.1MlyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.1MlyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.1MlyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.1MlyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.1MlyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.1MlyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.1MlyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1MlyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.1MlyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1MlyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1MlyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.1MlyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.1MlyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.1MlyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.1MlyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.1MlyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.1MlyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1MlyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.1MlyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.1MlyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.1MlyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.1MlyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.1MlyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.1MlyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.1MlyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.1MlyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.1MlyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.1MlyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.1MlyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.1MlyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"20Gly Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.20GlyGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.20GlyGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.20GlyGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.20GlyGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.20GlyGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.20GlyGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.20GlyGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.20GlyGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.20GlyGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.20GlyGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.20GlyGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.20GlyGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.20GlyGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.20GlyGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.20GlyGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.20GlyGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.20GlyGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.20GlyGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.20GlyGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.20GlyGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.20GlyGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.20GlyGrid.Renderable.Fade"},{"description":"The size of the grid (in the x and y direction), given in meters.","identifier":"Size","name":"Grid Size","type":"Vec2Property","uri":"Scene.20GlyGrid.Renderable.Size"},{"description":"The color of the highlighted lines in the grid.","identifier":"HighlightColor","name":"Highlight Color","type":"Vec3Property","uri":"Scene.20GlyGrid.Renderable.HighlightColor"},{"description":"The width of the highlighted grid lines. The larger number, the thicker the lines.","identifier":"HighlightLineWidth","name":"Highlight Line Width","type":"FloatProperty","uri":"Scene.20GlyGrid.Renderable.HighlightLineWidth"},{"description":"The rate that the columns and rows are highlighted, counted with respect to the center of the grid. If the number of segments in the grid is odd, the highlighting might be offset from the center.","identifier":"HighlightRate","name":"Highlight Rate","type":"IVec2Property","uri":"Scene.20GlyGrid.Renderable.HighlightRate"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.20GlyGrid.Renderable.LineWidth"},{"description":"The number of segments to split the grid into, in each direction (x and y).","identifier":"Segments","name":"Number of Segments","type":"IVec2Property","uri":"Scene.20GlyGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.20GlyGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.20GlyGrid.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.20GlyGrid.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.20GlyGrid.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.20GlyGrid.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.20GlyGrid.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.20GlyGrid.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.20GlyGrid.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.20GlyGrid.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.20GlyGrid.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.20GlyGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.20GlyGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.20GlyGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Census 229,293 galaxies. DU Version 1.7. <br> The Two-degree Field\n    (2dF) Survey was a project designed to map portions of the extragalactic universe. The\n    2dF instrument was mounted on the 3.9-meter (12.8-foot) Anglo-Australian Telescope\n    (AAT), located 450 km (280 miles) northwest of Sydney. The telescope has a two-degree\n    field of view on the sky, enabling large parts of the sky to be observed at one time.\n    For each pointing of the telescope, the instrument can acquire up to 400 spectra\n    simultaneously via optical fibers that feed into two spectrographs. Each spectrograph\n    sees light that is between 350 nm and 800 nm, spanning the visible spectrum. <br><br>\n    The 2dF survey has three main components: the North Galactic Pole strip, the South\n    Galactic Pole strip, and the random fields that surround the South Galactic Pole\n    strip. The galaxy survey is composed of about 230,000 galaxies with brightness and\n    redshift measurements. (Description from URL) <br><br> Data Reference: 2dF Galaxy\n    Redshift Survey (2dFGRS Team, 1998-2003)","name":"2dF Galaxies","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.2dF.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.2dF.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.2dF.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.2dF.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.2dF.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.2dF.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.2dF.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.2dF.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.2dF.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.2dF.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.2dF.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.2dF.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.2dF.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.2dF.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.2dF.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.2dF.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.2dF.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.2dF.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.2dF.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the points.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.2dF.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.2dF.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.2dF.Renderable.Fade"},{"description":"Set to true if orientation data was read from the dataset.","identifier":"HasOrientationData","name":"Has Orientation Data","type":"BoolProperty","uri":"Scene.2dF.Renderable.HasOrientationData"},{"description":"Information about how many points are being rendered.","identifier":"NumberOfDataPoints","name":"Number of Shown Data Points","type":"UIntProperty","uri":"Scene.2dF.Renderable.NumberOfDataPoints"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.2dF.Renderable.Opacity"},{"description":"Controls how the planes for the points will be oriented. \"Camera View Direction\" rotates the points so that the plane is orthogonal to the viewing direction of the camera (useful for planar displays), and \"Camera Position Normal\" rotates the points towards the position of the camera (useful for spherical displays, like dome theaters). In both these cases the points will be billboarded towards the camera. In contrast, \"Fixed Rotation\" does not rotate the points at all based on the camera and should be used when the dataset contains orientation information for the points.","identifier":"OrientationRenderOption","name":"Orientation Render Option","type":"OptionProperty","uri":"Scene.2dF.Renderable.OrientationRenderOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.2dF.Renderable.Type"},{"description":"If true (default), the color of points rendered on top of each other is blended additively, resulting in a brighter color where points overlap. If false, no such blending will take place and the color of the point will not be modified by blending. Note that this may lead to weird behaviors when the points are rendered with transparency.","identifier":"UseAdditiveBlending","name":"Use Additive Blending","type":"BoolProperty","uri":"Scene.2dF.Renderable.UseAdditiveBlending"},{"description":"If true, the orientation data in the dataset is included when rendering the points, if there is any. To see the rotation, you also need to set the \"Orientation Render Option\" to \"Fixed Rotation\".","identifier":"UseOrientationData","name":"Use Orientation Data","type":"BoolProperty","uri":"Scene.2dF.Renderable.UseOrientationData"}],"propertyOwners":[{"description":"","name":"Coloring","properties":[{"description":"If true and the outline is enabled, the color map will be applied to the outline rather than the point body. Only works if color mapping is enabled.","identifier":"ApplyColorMapToOutline","name":"Apply Color Map to Outline","type":"BoolProperty","uri":"Scene.2dF.Renderable.Coloring.ApplyColorMapToOutline"},{"description":"Determines whether each point should have an outline or not.","identifier":"EnableOutline","name":"Enable Point Outline","type":"BoolProperty","uri":"Scene.2dF.Renderable.Coloring.EnableOutline"},{"description":"The color of the points, when no color map is used.","identifier":"FixedColor","name":"Fixed Color","type":"Vec3Property","uri":"Scene.2dF.Renderable.Coloring.FixedColor"},{"description":"The color of the outline. Darker colors will be less visible if \"Additive Blending\" is enabled.","identifier":"OutlineColor","name":"Outline Color","type":"Vec3Property","uri":"Scene.2dF.Renderable.Coloring.OutlineColor"},{"description":"Decides the style of the outline (round, square, or a line at the bottom). The style also affects the shape of the points.","identifier":"OutlineStyle","name":"Outline Style","type":"OptionProperty","uri":"Scene.2dF.Renderable.Coloring.OutlineStyle"},{"description":"The thickness of the outline, given as a value relative to the size of the point. A value of 0 will not show any outline, while a value of 1 will cover the whole point.","identifier":"OutlineWidth","name":"Outline Width","type":"FloatProperty","uri":"Scene.2dF.Renderable.Coloring.OutlineWidth"}],"propertyOwners":[{"description":"","name":"Color Mapping","properties":[{"description":"The color to use for items with values larger than the one in the provided data range, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the above range values is provided, the UseAboveRangeColor property will automatically be set to true.","identifier":"AboveRangeColor","name":"Above Range Color","type":"Vec4Property","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.AboveRangeColor"},{"description":"The color to use for items with values smaller than the one in the provided data range, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the below range values is provided, the UseBelowRangeColor property will automatically be set to true.","identifier":"BelowRangeColor","name":"Below Range Color","type":"Vec4Property","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.BelowRangeColor"},{"description":"If this value is set to 'true', the provided color map is used (if one was provided in the configuration). If no color map was provided, changing this setting does not do anything.","identifier":"Enabled","name":"Color Map Enabled","type":"BoolProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.Enabled"},{"description":"The path to the color map file to use for coloring the points.","identifier":"File","name":"Color Map File","type":"StringProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.File"},{"description":"If true, points with values outside the provided range for the coloring will be hidden, i.e. not rendered at all.","identifier":"HideValuesOutsideRange","name":"Hide Values Outside Range","type":"BoolProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.HideValuesOutsideRange"},{"description":"If true, the colors of the color map will be read in the inverse order.","identifier":"Invert","name":"Invert Color Map","type":"BoolProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.Invert"},{"description":"The color to use for items with values corresponding to missing data values, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the below range values is provided, the ShowMissingData property will automatically be set to true.","identifier":"NoDataColor","name":"No Data Color","type":"Vec4Property","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.NoDataColor"},{"description":"This value determines which paramenter is used for coloring the points based on the color map. The property is set based on predefined options specified in the asset file. When changing the parameter, the value range to used for themapping will also be changed. Per default, it is set to the last parameter in the list of options.","identifier":"Parameter","name":"Parameter","type":"OptionProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.Parameter"},{"description":"Set the data range for the color mapping based on the available data for the curently selected data column.","identifier":"SetRangeFromData","name":"Set Data Range from Data","type":"TriggerProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.SetRangeFromData"},{"description":"If true, use a separate color (see NoDataColor) for items with values corresponding to missing data values.","identifier":"ShowMissingData","name":"Show Missing Data","type":"BoolProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.ShowMissingData"},{"description":"If true, use a separate color (see AboveRangeColor) for items with values larger than the one in the provided data range. Otherwise, the values will be clamped to use the color at the upper limit of the color map. If a color is provided in the color map, this value will automatically be set to true.","identifier":"UseAboveRangeColor","name":"Use Above Range Color","type":"BoolProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.UseAboveRangeColor"},{"description":"If true, use a separate color (see BelowRangeColor) for items with values smaller than the one in the provided data range. Otherwise, the values will be clamped to use the color at the lower limit of the color map. If a color is provided in the color map, this value will automatically be set to true.","identifier":"UseBelowRangeColor","name":"Use Below Range Color","type":"BoolProperty","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.UseBelowRangeColor"},{"description":"This value changes the range of values to be mapped with the current color map.","identifier":"ValueRange","name":"Value Range","type":"Vec2Property","uri":"Scene.2dF.Renderable.Coloring.ColorMapping.ValueRange"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"Sizing","properties":[{"description":"If true, the Max Size property will be used as an upper limit for the size of the point. This reduces the size of the points when approaching them, so that they stick to a maximum visual size depending on the Max Size value.","identifier":"EnableMaxSizeControl","name":"Enable Max Size Control","type":"BoolProperty","uri":"Scene.2dF.Renderable.Sizing.EnableMaxSizeControl"},{"description":"Controls the maximum allowed size for the points, when the max size control feature is enabled. This limits the visual size of the points based on the distance to the camera. The larger the value, the larger the points may be. In the background, the computations are made by limiting the size to a certain angle based on the field of view of the camera. So a value of 1 limits the point size to take up a maximum of one degree of the view space.","identifier":"MaxSize","name":"Max Size","type":"FloatProperty","uri":"Scene.2dF.Renderable.Sizing.MaxSize"},{"description":"An exponential scale value used to set the absolute size of the point. In general, the larger distance the dataset covers, the larger this value should be. If not included, it is computed based on the maximum positional component of the data points. This is useful for showing the dataset at all, but you will likely want to change it to something that looks good. Note that a scale exponent of 0 leads to the points having a diameter of 1 meter, i.e. no exponential scaling.","identifier":"ScaleExponent","name":"Scale Exponent","type":"FloatProperty","uri":"Scene.2dF.Renderable.Sizing.ScaleExponent"},{"description":"A multiplicative factor used to adjust the size of the points, after the exponential scaling and any max size control effects. Simply just increases or decreases the visual size of the points.","identifier":"ScaleFactor","name":"Scale Factor","type":"FloatProperty","uri":"Scene.2dF.Renderable.Sizing.ScaleFactor"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Texture","properties":[{"description":"If true, the textures will be compressed to preserve graphics card memory. This is enabled per default, but may lead to visible artefacts for certain images, especially up close. Set this to false to disable any hardware compression of the textures, and represent each color channel with 8 bits.","identifier":"AllowCompression","name":"Allow Compression","type":"BoolProperty","uri":"Scene.2dF.Renderable.Texture.AllowCompression"},{"description":"If true, use a provided sprite texture to render the point. If false, draw the points using the default point shape.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.2dF.Renderable.Texture.Enabled"},{"description":"The path to the texture of the point sprite. Note that if multiple textures option is set in the asset, by providing a texture folder, this value will be ignored.","identifier":"File","name":"Point Sprite Texture File","type":"StringProperty","uri":"Scene.2dF.Renderable.Texture.File"},{"description":"This tells which texture mode is being used for this renderable. There are three different texture modes: 1) One single sprite texture used for all points, 2) Multiple textures, that are mapped to the points based on a column in the dataset, and 3) Other, which is used for specific subtypes where the texture is internally controlled by the renderable and can't be set from a file (such as the RenderablePolygonCloud).","identifier":"TextureMode","name":"Texture Mode","type":"StringProperty","uri":"Scene.2dF.Renderable.Texture.TextureMode"},{"description":"If true, include transparency information in the loaded textures, if there is any. If false, all loaded textures will be converted to RGB format. \nThis setting can be used if you have textures with transparency, but do not need the transparency information. This may be the case when using additive blending, for example. Converting the files to RGB on load may then reduce the memory footprint and/or lead to some optimization in terms of rendering speed.","identifier":"UseAlphaChannel","name":"Use Alpha Channel","type":"BoolProperty","uri":"Scene.2dF.Renderable.Texture.UseAlphaChannel"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderablePointCloud"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.2dF.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.2dF.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.2dF.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"The Two Micron All-Sky Survey (2MASS) is an infrared survey of the\n    sky published in 2003. Because it is looking in the infrared, and this is a composite\n    of the 2MASS point-source catalog, most of the light from this survey is starlight. In\n    visible light, clouds of gas and dust obscure our view. However, in infrared, the\n    longer wavelengths of light can penetrate these clouds without being scattered,\n    thereby revealing stars that would normally be hidden to our eye.\n    (Description from URL)","name":"2MASS Galaxies","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.2MASS.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.2MASS.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.2MASS.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.2MASS.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.2MASS.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.2MASS.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.2MASS.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.2MASS.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.2MASS.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.2MASS.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.2MASS.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.2MASS.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.2MASS.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.2MASS.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.2MASS.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.2MASS.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.2MASS.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.2MASS.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.2MASS.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the points.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.2MASS.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.2MASS.Renderable.Fade"},{"description":"Set to true if orientation data was read from the dataset.","identifier":"HasOrientationData","name":"Has Orientation Data","type":"BoolProperty","uri":"Scene.2MASS.Renderable.HasOrientationData"},{"description":"Information about how many points are being rendered.","identifier":"NumberOfDataPoints","name":"Number of Shown Data Points","type":"UIntProperty","uri":"Scene.2MASS.Renderable.NumberOfDataPoints"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.2MASS.Renderable.Opacity"},{"description":"Controls how the planes for the points will be oriented. \"Camera View Direction\" rotates the points so that the plane is orthogonal to the viewing direction of the camera (useful for planar displays), and \"Camera Position Normal\" rotates the points towards the position of the camera (useful for spherical displays, like dome theaters). In both these cases the points will be billboarded towards the camera. In contrast, \"Fixed Rotation\" does not rotate the points at all based on the camera and should be used when the dataset contains orientation information for the points.","identifier":"OrientationRenderOption","name":"Orientation Render Option","type":"OptionProperty","uri":"Scene.2MASS.Renderable.OrientationRenderOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.2MASS.Renderable.Type"},{"description":"If true (default), the color of points rendered on top of each other is blended additively, resulting in a brighter color where points overlap. If false, no such blending will take place and the color of the point will not be modified by blending. Note that this may lead to weird behaviors when the points are rendered with transparency.","identifier":"UseAdditiveBlending","name":"Use Additive Blending","type":"BoolProperty","uri":"Scene.2MASS.Renderable.UseAdditiveBlending"},{"description":"If true, the orientation data in the dataset is included when rendering the points, if there is any. To see the rotation, you also need to set the \"Orientation Render Option\" to \"Fixed Rotation\".","identifier":"UseOrientationData","name":"Use Orientation Data","type":"BoolProperty","uri":"Scene.2MASS.Renderable.UseOrientationData"}],"propertyOwners":[{"description":"","name":"Coloring","properties":[{"description":"If true and the outline is enabled, the color map will be applied to the outline rather than the point body. Only works if color mapping is enabled.","identifier":"ApplyColorMapToOutline","name":"Apply Color Map to Outline","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Coloring.ApplyColorMapToOutline"},{"description":"Determines whether each point should have an outline or not.","identifier":"EnableOutline","name":"Enable Point Outline","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Coloring.EnableOutline"},{"description":"The color of the points, when no color map is used.","identifier":"FixedColor","name":"Fixed Color","type":"Vec3Property","uri":"Scene.2MASS.Renderable.Coloring.FixedColor"},{"description":"The color of the outline. Darker colors will be less visible if \"Additive Blending\" is enabled.","identifier":"OutlineColor","name":"Outline Color","type":"Vec3Property","uri":"Scene.2MASS.Renderable.Coloring.OutlineColor"},{"description":"Decides the style of the outline (round, square, or a line at the bottom). The style also affects the shape of the points.","identifier":"OutlineStyle","name":"Outline Style","type":"OptionProperty","uri":"Scene.2MASS.Renderable.Coloring.OutlineStyle"},{"description":"The thickness of the outline, given as a value relative to the size of the point. A value of 0 will not show any outline, while a value of 1 will cover the whole point.","identifier":"OutlineWidth","name":"Outline Width","type":"FloatProperty","uri":"Scene.2MASS.Renderable.Coloring.OutlineWidth"}],"propertyOwners":[{"description":"","name":"Color Mapping","properties":[{"description":"The color to use for items with values larger than the one in the provided data range, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the above range values is provided, the UseAboveRangeColor property will automatically be set to true.","identifier":"AboveRangeColor","name":"Above Range Color","type":"Vec4Property","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.AboveRangeColor"},{"description":"The color to use for items with values smaller than the one in the provided data range, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the below range values is provided, the UseBelowRangeColor property will automatically be set to true.","identifier":"BelowRangeColor","name":"Below Range Color","type":"Vec4Property","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.BelowRangeColor"},{"description":"If this value is set to 'true', the provided color map is used (if one was provided in the configuration). If no color map was provided, changing this setting does not do anything.","identifier":"Enabled","name":"Color Map Enabled","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.Enabled"},{"description":"The path to the color map file to use for coloring the points.","identifier":"File","name":"Color Map File","type":"StringProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.File"},{"description":"If true, points with values outside the provided range for the coloring will be hidden, i.e. not rendered at all.","identifier":"HideValuesOutsideRange","name":"Hide Values Outside Range","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.HideValuesOutsideRange"},{"description":"If true, the colors of the color map will be read in the inverse order.","identifier":"Invert","name":"Invert Color Map","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.Invert"},{"description":"The color to use for items with values corresponding to missing data values, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the below range values is provided, the ShowMissingData property will automatically be set to true.","identifier":"NoDataColor","name":"No Data Color","type":"Vec4Property","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.NoDataColor"},{"description":"This value determines which paramenter is used for coloring the points based on the color map. The property is set based on predefined options specified in the asset file. When changing the parameter, the value range to used for themapping will also be changed. Per default, it is set to the last parameter in the list of options.","identifier":"Parameter","name":"Parameter","type":"OptionProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.Parameter"},{"description":"Set the data range for the color mapping based on the available data for the curently selected data column.","identifier":"SetRangeFromData","name":"Set Data Range from Data","type":"TriggerProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.SetRangeFromData"},{"description":"If true, use a separate color (see NoDataColor) for items with values corresponding to missing data values.","identifier":"ShowMissingData","name":"Show Missing Data","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.ShowMissingData"},{"description":"If true, use a separate color (see AboveRangeColor) for items with values larger than the one in the provided data range. Otherwise, the values will be clamped to use the color at the upper limit of the color map. If a color is provided in the color map, this value will automatically be set to true.","identifier":"UseAboveRangeColor","name":"Use Above Range Color","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.UseAboveRangeColor"},{"description":"If true, use a separate color (see BelowRangeColor) for items with values smaller than the one in the provided data range. Otherwise, the values will be clamped to use the color at the lower limit of the color map. If a color is provided in the color map, this value will automatically be set to true.","identifier":"UseBelowRangeColor","name":"Use Below Range Color","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.UseBelowRangeColor"},{"description":"This value changes the range of values to be mapped with the current color map.","identifier":"ValueRange","name":"Value Range","type":"Vec2Property","uri":"Scene.2MASS.Renderable.Coloring.ColorMapping.ValueRange"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"Sizing","properties":[{"description":"If true, the Max Size property will be used as an upper limit for the size of the point. This reduces the size of the points when approaching them, so that they stick to a maximum visual size depending on the Max Size value.","identifier":"EnableMaxSizeControl","name":"Enable Max Size Control","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Sizing.EnableMaxSizeControl"},{"description":"Controls the maximum allowed size for the points, when the max size control feature is enabled. This limits the visual size of the points based on the distance to the camera. The larger the value, the larger the points may be. In the background, the computations are made by limiting the size to a certain angle based on the field of view of the camera. So a value of 1 limits the point size to take up a maximum of one degree of the view space.","identifier":"MaxSize","name":"Max Size","type":"FloatProperty","uri":"Scene.2MASS.Renderable.Sizing.MaxSize"},{"description":"An exponential scale value used to set the absolute size of the point. In general, the larger distance the dataset covers, the larger this value should be. If not included, it is computed based on the maximum positional component of the data points. This is useful for showing the dataset at all, but you will likely want to change it to something that looks good. Note that a scale exponent of 0 leads to the points having a diameter of 1 meter, i.e. no exponential scaling.","identifier":"ScaleExponent","name":"Scale Exponent","type":"FloatProperty","uri":"Scene.2MASS.Renderable.Sizing.ScaleExponent"},{"description":"A multiplicative factor used to adjust the size of the points, after the exponential scaling and any max size control effects. Simply just increases or decreases the visual size of the points.","identifier":"ScaleFactor","name":"Scale Factor","type":"FloatProperty","uri":"Scene.2MASS.Renderable.Sizing.ScaleFactor"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Texture","properties":[{"description":"If true, the textures will be compressed to preserve graphics card memory. This is enabled per default, but may lead to visible artefacts for certain images, especially up close. Set this to false to disable any hardware compression of the textures, and represent each color channel with 8 bits.","identifier":"AllowCompression","name":"Allow Compression","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Texture.AllowCompression"},{"description":"If true, use a provided sprite texture to render the point. If false, draw the points using the default point shape.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Texture.Enabled"},{"description":"The path to the texture of the point sprite. Note that if multiple textures option is set in the asset, by providing a texture folder, this value will be ignored.","identifier":"File","name":"Point Sprite Texture File","type":"StringProperty","uri":"Scene.2MASS.Renderable.Texture.File"},{"description":"This tells which texture mode is being used for this renderable. There are three different texture modes: 1) One single sprite texture used for all points, 2) Multiple textures, that are mapped to the points based on a column in the dataset, and 3) Other, which is used for specific subtypes where the texture is internally controlled by the renderable and can't be set from a file (such as the RenderablePolygonCloud).","identifier":"TextureMode","name":"Texture Mode","type":"StringProperty","uri":"Scene.2MASS.Renderable.Texture.TextureMode"},{"description":"If true, include transparency information in the loaded textures, if there is any. If false, all loaded textures will be converted to RGB format. \nThis setting can be used if you have textures with transparency, but do not need the transparency information. This may be the case when using additive blending, for example. Converting the files to RGB on load may then reduce the memory footprint and/or lead to some optimization in terms of rendering speed.","identifier":"UseAlphaChannel","name":"Use Alpha Channel","type":"BoolProperty","uri":"Scene.2MASS.Renderable.Texture.UseAlphaChannel"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderablePointCloud"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.2MASS.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.2MASS.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.2MASS.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Census 109,569 galaxies. DU Version 1.4.<br> The Six-degree Field\n        (6dF) Galaxy Survey mapped nearly half the sky from the Anglo-Australian\n        Observatory. Unlike previous datasets, this one is not all-sky, meaning there\n        are patches of sky that are not covered. In this case, the entire northern\n        hemisphere has no coverage at all. This catalog overlaps with the Tully\n        dataset, and there is a noticeable difference in the quality of these\n        datasets. Tully is much tighter and the structure is more apparent, while the\n        6dF data are more spread out. This is because of local motions within galaxy\n        clusters have not been corrected in these data. (Description from URL)\n        <br><br> Data Reference: The 6dF Galaxy Survey Redshift Catalogue\n        (Jones+, 2009)","name":"6dF Galaxies","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.6dF.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.6dF.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.6dF.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.6dF.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.6dF.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.6dF.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.6dF.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.6dF.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.6dF.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.6dF.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.6dF.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.6dF.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.6dF.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.6dF.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.6dF.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.6dF.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.6dF.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.6dF.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.6dF.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the points.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.6dF.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.6dF.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.6dF.Renderable.Fade"},{"description":"Set to true if orientation data was read from the dataset.","identifier":"HasOrientationData","name":"Has Orientation Data","type":"BoolProperty","uri":"Scene.6dF.Renderable.HasOrientationData"},{"description":"Information about how many points are being rendered.","identifier":"NumberOfDataPoints","name":"Number of Shown Data Points","type":"UIntProperty","uri":"Scene.6dF.Renderable.NumberOfDataPoints"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.6dF.Renderable.Opacity"},{"description":"Controls how the planes for the points will be oriented. \"Camera View Direction\" rotates the points so that the plane is orthogonal to the viewing direction of the camera (useful for planar displays), and \"Camera Position Normal\" rotates the points towards the position of the camera (useful for spherical displays, like dome theaters). In both these cases the points will be billboarded towards the camera. In contrast, \"Fixed Rotation\" does not rotate the points at all based on the camera and should be used when the dataset contains orientation information for the points.","identifier":"OrientationRenderOption","name":"Orientation Render Option","type":"OptionProperty","uri":"Scene.6dF.Renderable.OrientationRenderOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.6dF.Renderable.Type"},{"description":"If true (default), the color of points rendered on top of each other is blended additively, resulting in a brighter color where points overlap. If false, no such blending will take place and the color of the point will not be modified by blending. Note that this may lead to weird behaviors when the points are rendered with transparency.","identifier":"UseAdditiveBlending","name":"Use Additive Blending","type":"BoolProperty","uri":"Scene.6dF.Renderable.UseAdditiveBlending"},{"description":"If true, the orientation data in the dataset is included when rendering the points, if there is any. To see the rotation, you also need to set the \"Orientation Render Option\" to \"Fixed Rotation\".","identifier":"UseOrientationData","name":"Use Orientation Data","type":"BoolProperty","uri":"Scene.6dF.Renderable.UseOrientationData"}],"propertyOwners":[{"description":"","name":"Coloring","properties":[{"description":"If true and the outline is enabled, the color map will be applied to the outline rather than the point body. Only works if color mapping is enabled.","identifier":"ApplyColorMapToOutline","name":"Apply Color Map to Outline","type":"BoolProperty","uri":"Scene.6dF.Renderable.Coloring.ApplyColorMapToOutline"},{"description":"Determines whether each point should have an outline or not.","identifier":"EnableOutline","name":"Enable Point Outline","type":"BoolProperty","uri":"Scene.6dF.Renderable.Coloring.EnableOutline"},{"description":"The color of the points, when no color map is used.","identifier":"FixedColor","name":"Fixed Color","type":"Vec3Property","uri":"Scene.6dF.Renderable.Coloring.FixedColor"},{"description":"The color of the outline. Darker colors will be less visible if \"Additive Blending\" is enabled.","identifier":"OutlineColor","name":"Outline Color","type":"Vec3Property","uri":"Scene.6dF.Renderable.Coloring.OutlineColor"},{"description":"Decides the style of the outline (round, square, or a line at the bottom). The style also affects the shape of the points.","identifier":"OutlineStyle","name":"Outline Style","type":"OptionProperty","uri":"Scene.6dF.Renderable.Coloring.OutlineStyle"},{"description":"The thickness of the outline, given as a value relative to the size of the point. A value of 0 will not show any outline, while a value of 1 will cover the whole point.","identifier":"OutlineWidth","name":"Outline Width","type":"FloatProperty","uri":"Scene.6dF.Renderable.Coloring.OutlineWidth"}],"propertyOwners":[{"description":"","name":"Color Mapping","properties":[{"description":"The color to use for items with values larger than the one in the provided data range, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the above range values is provided, the UseAboveRangeColor property will automatically be set to true.","identifier":"AboveRangeColor","name":"Above Range Color","type":"Vec4Property","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.AboveRangeColor"},{"description":"The color to use for items with values smaller than the one in the provided data range, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the below range values is provided, the UseBelowRangeColor property will automatically be set to true.","identifier":"BelowRangeColor","name":"Below Range Color","type":"Vec4Property","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.BelowRangeColor"},{"description":"If this value is set to 'true', the provided color map is used (if one was provided in the configuration). If no color map was provided, changing this setting does not do anything.","identifier":"Enabled","name":"Color Map Enabled","type":"BoolProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.Enabled"},{"description":"The path to the color map file to use for coloring the points.","identifier":"File","name":"Color Map File","type":"StringProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.File"},{"description":"If true, points with values outside the provided range for the coloring will be hidden, i.e. not rendered at all.","identifier":"HideValuesOutsideRange","name":"Hide Values Outside Range","type":"BoolProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.HideValuesOutsideRange"},{"description":"If true, the colors of the color map will be read in the inverse order.","identifier":"Invert","name":"Invert Color Map","type":"BoolProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.Invert"},{"description":"The color to use for items with values corresponding to missing data values, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the below range values is provided, the ShowMissingData property will automatically be set to true.","identifier":"NoDataColor","name":"No Data Color","type":"Vec4Property","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.NoDataColor"},{"description":"This value determines which paramenter is used for coloring the points based on the color map. The property is set based on predefined options specified in the asset file. When changing the parameter, the value range to used for themapping will also be changed. Per default, it is set to the last parameter in the list of options.","identifier":"Parameter","name":"Parameter","type":"OptionProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.Parameter"},{"description":"Set the data range for the color mapping based on the available data for the curently selected data column.","identifier":"SetRangeFromData","name":"Set Data Range from Data","type":"TriggerProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.SetRangeFromData"},{"description":"If true, use a separate color (see NoDataColor) for items with values corresponding to missing data values.","identifier":"ShowMissingData","name":"Show Missing Data","type":"BoolProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.ShowMissingData"},{"description":"If true, use a separate color (see AboveRangeColor) for items with values larger than the one in the provided data range. Otherwise, the values will be clamped to use the color at the upper limit of the color map. If a color is provided in the color map, this value will automatically be set to true.","identifier":"UseAboveRangeColor","name":"Use Above Range Color","type":"BoolProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.UseAboveRangeColor"},{"description":"If true, use a separate color (see BelowRangeColor) for items with values smaller than the one in the provided data range. Otherwise, the values will be clamped to use the color at the lower limit of the color map. If a color is provided in the color map, this value will automatically be set to true.","identifier":"UseBelowRangeColor","name":"Use Below Range Color","type":"BoolProperty","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.UseBelowRangeColor"},{"description":"This value changes the range of values to be mapped with the current color map.","identifier":"ValueRange","name":"Value Range","type":"Vec2Property","uri":"Scene.6dF.Renderable.Coloring.ColorMapping.ValueRange"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"Sizing","properties":[{"description":"If true, the Max Size property will be used as an upper limit for the size of the point. This reduces the size of the points when approaching them, so that they stick to a maximum visual size depending on the Max Size value.","identifier":"EnableMaxSizeControl","name":"Enable Max Size Control","type":"BoolProperty","uri":"Scene.6dF.Renderable.Sizing.EnableMaxSizeControl"},{"description":"Controls the maximum allowed size for the points, when the max size control feature is enabled. This limits the visual size of the points based on the distance to the camera. The larger the value, the larger the points may be. In the background, the computations are made by limiting the size to a certain angle based on the field of view of the camera. So a value of 1 limits the point size to take up a maximum of one degree of the view space.","identifier":"MaxSize","name":"Max Size","type":"FloatProperty","uri":"Scene.6dF.Renderable.Sizing.MaxSize"},{"description":"An exponential scale value used to set the absolute size of the point. In general, the larger distance the dataset covers, the larger this value should be. If not included, it is computed based on the maximum positional component of the data points. This is useful for showing the dataset at all, but you will likely want to change it to something that looks good. Note that a scale exponent of 0 leads to the points having a diameter of 1 meter, i.e. no exponential scaling.","identifier":"ScaleExponent","name":"Scale Exponent","type":"FloatProperty","uri":"Scene.6dF.Renderable.Sizing.ScaleExponent"},{"description":"A multiplicative factor used to adjust the size of the points, after the exponential scaling and any max size control effects. Simply just increases or decreases the visual size of the points.","identifier":"ScaleFactor","name":"Scale Factor","type":"FloatProperty","uri":"Scene.6dF.Renderable.Sizing.ScaleFactor"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Texture","properties":[{"description":"If true, the textures will be compressed to preserve graphics card memory. This is enabled per default, but may lead to visible artefacts for certain images, especially up close. Set this to false to disable any hardware compression of the textures, and represent each color channel with 8 bits.","identifier":"AllowCompression","name":"Allow Compression","type":"BoolProperty","uri":"Scene.6dF.Renderable.Texture.AllowCompression"},{"description":"If true, use a provided sprite texture to render the point. If false, draw the points using the default point shape.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.6dF.Renderable.Texture.Enabled"},{"description":"The path to the texture of the point sprite. Note that if multiple textures option is set in the asset, by providing a texture folder, this value will be ignored.","identifier":"File","name":"Point Sprite Texture File","type":"StringProperty","uri":"Scene.6dF.Renderable.Texture.File"},{"description":"This tells which texture mode is being used for this renderable. There are three different texture modes: 1) One single sprite texture used for all points, 2) Multiple textures, that are mapped to the points based on a column in the dataset, and 3) Other, which is used for specific subtypes where the texture is internally controlled by the renderable and can't be set from a file (such as the RenderablePolygonCloud).","identifier":"TextureMode","name":"Texture Mode","type":"StringProperty","uri":"Scene.6dF.Renderable.Texture.TextureMode"},{"description":"If true, include transparency information in the loaded textures, if there is any. If false, all loaded textures will be converted to RGB format. \nThis setting can be used if you have textures with transparency, but do not need the transparency information. This may be the case when using additive blending, for example. Converting the files to RGB on load may then reduce the memory footprint and/or lead to some optimization in terms of rendering speed.","identifier":"UseAlphaChannel","name":"Use Alpha Channel","type":"BoolProperty","uri":"Scene.6dF.Renderable.Texture.UseAlphaChannel"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderablePointCloud"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.6dF.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.6dF.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.6dF.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Census 2,246 galaxies. DU Version 1.4. <br> The Abell catalog\n        includes all the nearby, and not so nearby, galaxy clusters. The northern\n        hemisphere survey, published in 1958, was compiled by George Abell (1927-1983)\n        from the Palomar Sky Survey plates. A subsequent southern hemisphere catalog\n        was published posthumously in 1989. Further analysis by Brent Tully determined\n        their distance and three-dimensional distribution. Each point in this data set\n        represents a cluster of tens to hundreds (possibly even thousands) of\n        galaxies, similar to the Virgo or Fornax Clusters. You will notice some points\n        are assigned colors while most are gray. The data set also has an arbitrary\n        cut-off for completeness, resulting in the rectangular shape of the data set.\n        (Description from URL) <br><br> Data Reference: Abell Clusters of Rich\n        Galaxies, Brent Tully (U Hawaii), Stuart Levy (NCSA/UIUC)","name":"Abell Galaxy Clusters","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Abell.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Abell.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Abell.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Abell.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Abell.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Abell.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Abell.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Abell.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Abell.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Abell.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Abell.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Abell.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Abell.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Abell.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Abell.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Abell.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Abell.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Abell.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Abell.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the points.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.Abell.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Abell.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Abell.Renderable.Fade"},{"description":"Set to true if orientation data was read from the dataset.","identifier":"HasOrientationData","name":"Has Orientation Data","type":"BoolProperty","uri":"Scene.Abell.Renderable.HasOrientationData"},{"description":"Information about how many points are being rendered.","identifier":"NumberOfDataPoints","name":"Number of Shown Data Points","type":"UIntProperty","uri":"Scene.Abell.Renderable.NumberOfDataPoints"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Abell.Renderable.Opacity"},{"description":"Controls how the planes for the points will be oriented. \"Camera View Direction\" rotates the points so that the plane is orthogonal to the viewing direction of the camera (useful for planar displays), and \"Camera Position Normal\" rotates the points towards the position of the camera (useful for spherical displays, like dome theaters). In both these cases the points will be billboarded towards the camera. In contrast, \"Fixed Rotation\" does not rotate the points at all based on the camera and should be used when the dataset contains orientation information for the points.","identifier":"OrientationRenderOption","name":"Orientation Render Option","type":"OptionProperty","uri":"Scene.Abell.Renderable.OrientationRenderOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Abell.Renderable.Type"},{"description":"If true (default), the color of points rendered on top of each other is blended additively, resulting in a brighter color where points overlap. If false, no such blending will take place and the color of the point will not be modified by blending. Note that this may lead to weird behaviors when the points are rendered with transparency.","identifier":"UseAdditiveBlending","name":"Use Additive Blending","type":"BoolProperty","uri":"Scene.Abell.Renderable.UseAdditiveBlending"},{"description":"If true, the orientation data in the dataset is included when rendering the points, if there is any. To see the rotation, you also need to set the \"Orientation Render Option\" to \"Fixed Rotation\".","identifier":"UseOrientationData","name":"Use Orientation Data","type":"BoolProperty","uri":"Scene.Abell.Renderable.UseOrientationData"}],"propertyOwners":[{"description":"","name":"Coloring","properties":[{"description":"If true and the outline is enabled, the color map will be applied to the outline rather than the point body. Only works if color mapping is enabled.","identifier":"ApplyColorMapToOutline","name":"Apply Color Map to Outline","type":"BoolProperty","uri":"Scene.Abell.Renderable.Coloring.ApplyColorMapToOutline"},{"description":"Determines whether each point should have an outline or not.","identifier":"EnableOutline","name":"Enable Point Outline","type":"BoolProperty","uri":"Scene.Abell.Renderable.Coloring.EnableOutline"},{"description":"The color of the points, when no color map is used.","identifier":"FixedColor","name":"Fixed Color","type":"Vec3Property","uri":"Scene.Abell.Renderable.Coloring.FixedColor"},{"description":"The color of the outline. Darker colors will be less visible if \"Additive Blending\" is enabled.","identifier":"OutlineColor","name":"Outline Color","type":"Vec3Property","uri":"Scene.Abell.Renderable.Coloring.OutlineColor"},{"description":"Decides the style of the outline (round, square, or a line at the bottom). The style also affects the shape of the points.","identifier":"OutlineStyle","name":"Outline Style","type":"OptionProperty","uri":"Scene.Abell.Renderable.Coloring.OutlineStyle"},{"description":"The thickness of the outline, given as a value relative to the size of the point. A value of 0 will not show any outline, while a value of 1 will cover the whole point.","identifier":"OutlineWidth","name":"Outline Width","type":"FloatProperty","uri":"Scene.Abell.Renderable.Coloring.OutlineWidth"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.Abell.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Abell.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.Abell.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Abell.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.Abell.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.Abell.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Abell.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.Abell.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Sizing","properties":[{"description":"If true, the Max Size property will be used as an upper limit for the size of the point. This reduces the size of the points when approaching them, so that they stick to a maximum visual size depending on the Max Size value.","identifier":"EnableMaxSizeControl","name":"Enable Max Size Control","type":"BoolProperty","uri":"Scene.Abell.Renderable.Sizing.EnableMaxSizeControl"},{"description":"Controls the maximum allowed size for the points, when the max size control feature is enabled. This limits the visual size of the points based on the distance to the camera. The larger the value, the larger the points may be. In the background, the computations are made by limiting the size to a certain angle based on the field of view of the camera. So a value of 1 limits the point size to take up a maximum of one degree of the view space.","identifier":"MaxSize","name":"Max Size","type":"FloatProperty","uri":"Scene.Abell.Renderable.Sizing.MaxSize"},{"description":"An exponential scale value used to set the absolute size of the point. In general, the larger distance the dataset covers, the larger this value should be. If not included, it is computed based on the maximum positional component of the data points. This is useful for showing the dataset at all, but you will likely want to change it to something that looks good. Note that a scale exponent of 0 leads to the points having a diameter of 1 meter, i.e. no exponential scaling.","identifier":"ScaleExponent","name":"Scale Exponent","type":"FloatProperty","uri":"Scene.Abell.Renderable.Sizing.ScaleExponent"},{"description":"A multiplicative factor used to adjust the size of the points, after the exponential scaling and any max size control effects. Simply just increases or decreases the visual size of the points.","identifier":"ScaleFactor","name":"Scale Factor","type":"FloatProperty","uri":"Scene.Abell.Renderable.Sizing.ScaleFactor"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Texture","properties":[{"description":"If true, the textures will be compressed to preserve graphics card memory. This is enabled per default, but may lead to visible artefacts for certain images, especially up close. Set this to false to disable any hardware compression of the textures, and represent each color channel with 8 bits.","identifier":"AllowCompression","name":"Allow Compression","type":"BoolProperty","uri":"Scene.Abell.Renderable.Texture.AllowCompression"},{"description":"If true, use a provided sprite texture to render the point. If false, draw the points using the default point shape.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Abell.Renderable.Texture.Enabled"},{"description":"The path to the texture of the point sprite. Note that if multiple textures option is set in the asset, by providing a texture folder, this value will be ignored.","identifier":"File","name":"Point Sprite Texture File","type":"StringProperty","uri":"Scene.Abell.Renderable.Texture.File"},{"description":"This tells which texture mode is being used for this renderable. There are three different texture modes: 1) One single sprite texture used for all points, 2) Multiple textures, that are mapped to the points based on a column in the dataset, and 3) Other, which is used for specific subtypes where the texture is internally controlled by the renderable and can't be set from a file (such as the RenderablePolygonCloud).","identifier":"TextureMode","name":"Texture Mode","type":"StringProperty","uri":"Scene.Abell.Renderable.Texture.TextureMode"},{"description":"If true, include transparency information in the loaded textures, if there is any. If false, all loaded textures will be converted to RGB format. \nThis setting can be used if you have textures with transparency, but do not need the transparency information. This may be the case when using additive blending, for example. Converting the files to RGB on load may then reduce the memory footprint and/or lead to some optimization in terms of rendering speed.","identifier":"UseAlphaChannel","name":"Use Alpha Channel","type":"BoolProperty","uri":"Scene.Abell.Renderable.Texture.UseAlphaChannel"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderablePointCloud"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.Abell.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.Abell.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.Abell.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"A local Altitude/Azimuth grid centered around your position on a\n    planetary surface. The grid can be toggled, hidden or shown using the accompanying\n    actions in the actions panel, under \"Night Sky\". Use these actions to move it to\n    another planet. The default is Earth.","name":"Altitude/Azimuth Grid","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.AltAzGrid.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.AltAzGrid.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.AltAzGrid.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.AltAzGrid.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.AltAzGrid.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.AltAzGrid.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.AltAzGrid.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.AltAzGrid.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.AltAzGrid.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.AltAzGrid.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.AltAzGrid.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.AltAzGrid.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.AltAzGrid.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.AltAzGrid.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.AltAzGrid.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.AltAzGrid.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.AltAzGrid.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.AltAzGrid.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the grid lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.AltAzGrid.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.AltAzGrid.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.AltAzGrid.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.AltAzGrid.Renderable.Fade"},{"description":"The width of the grid lines. The larger number, the thicker the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.AltAzGrid.Renderable.LineWidth"},{"description":"The number of segments the sphere is split into. Determines the resolution of the rendered sphere. Should be an even value (if an odd value is provided, the value will be set to the new value minus one).","identifier":"Segments","name":"Number of Segments","type":"IntProperty","uri":"Scene.AltAzGrid.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.AltAzGrid.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.AltAzGrid.Renderable.Type"}],"propertyOwners":[],"tags":[],"type":"RenderableSphericalGrid"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.AltAzGrid.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.AltAzGrid.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.AltAzGrid.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"Altitude/Azimuth Grid Position","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.AltAzGridPosition.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.AltAzGridPosition.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.AltAzGridPosition.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.AltAzGridPosition.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.AltAzGridPosition.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.AltAzGridPosition.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.AltAzGridPosition.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.AltAzGridPosition.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.AltAzGridPosition.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.AltAzGridPosition.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Rotation","properties":[{"description":"A rotation angle that can be used to rotate the object around its own y-axis, which will be pointing out of the globe's surface.","identifier":"Angle","name":"Angle","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.Rotation.Angle"},{"description":"The globe on which the longitude/latitude is specified.","identifier":"Globe","name":"Attached Globe","type":"StringProperty","uri":"Scene.AltAzGridPosition.Rotation.Globe"},{"description":"The latitude of the location on the globe's surface. The value can range from -90 to 90, with negative values representing the southern hemisphere of the globe. The default value is 0.0.","identifier":"Latitude","name":"Latitude","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.Rotation.Latitude"},{"description":"The longitude of the location on the globe's surface. The value can range from -180 to 180, with negative values representing the western hemisphere of the globe. The default value is 0.0.","identifier":"Longitude","name":"Longitude","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.Rotation.Longitude"},{"description":"If this value is 'true', the lat and lon are updated to match the camera.","identifier":"UseCamera","name":"Use Camera","type":"BoolProperty","uri":"Scene.AltAzGridPosition.Rotation.UseCamera"},{"description":"If set to true, the heightmap will be used when computing the surface normal. This means that the object will be rotated to lay flat on the surface at the given coordinate and follow the shape of the landscape.","identifier":"UseHeightmap","name":"Use Heightmap","type":"BoolProperty","uri":"Scene.AltAzGridPosition.Rotation.UseHeightmap"}],"propertyOwners":[],"tags":[],"type":"GlobeRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"The altitude in meters. If the 'UseHeightmap' property is 'true', this is an offset from the actual surface of the globe. If not, this is an offset from the reference ellipsoid. The default value is 0.0.","identifier":"Altitude","name":"Altitude","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.Translation.Altitude"},{"description":"The globe on which the longitude/latitude is specified.","identifier":"Globe","name":"Attached Globe","type":"StringProperty","uri":"Scene.AltAzGridPosition.Translation.Globe"},{"description":"The latitude of the location on the globe's surface. The value can range from -90 to 90, with negative values representing the southern hemisphere of the globe. The default value is 0.0.","identifier":"Latitude","name":"Latitude","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.Translation.Latitude"},{"description":"The longitude of the location on the globe's surface. The value can range from -180 to 180, with negative values representing the western hemisphere of the globe. The default value is 0.0.","identifier":"Longitude","name":"Longitude","type":"DoubleProperty","uri":"Scene.AltAzGridPosition.Translation.Longitude"},{"description":"If this value is 'true', the lat and lon are updated to match the camera.","identifier":"UseCamera","name":"Use Camera","type":"BoolProperty","uri":"Scene.AltAzGridPosition.Translation.UseCamera"},{"description":"If this value is 'true', the altitude is updated to match the camera.","identifier":"UseCameraAltitude","name":"Use Camera Altitude","type":"BoolProperty","uri":"Scene.AltAzGridPosition.Translation.UseCameraAltitude"},{"description":"If this value is 'true', the altitude specified in 'Altitude' will be treated as an offset from the heightmap. Otherwise, it will be an offset from the globe's reference ellipsoid. The default value is 'false'.","identifier":"UseHeightmap","name":"Use Heightmap","type":"BoolProperty","uri":"Scene.AltAzGridPosition.Translation.UseHeightmap"}],"propertyOwners":[],"tags":[],"type":"GlobeTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Andromeda Image","name":"Andromeda Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-And.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-And.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-And.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-And.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-And.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-And.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-And.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-And.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-And.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-And.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-And.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-And.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-And.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-And.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-And.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-And.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-And.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-And.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-And.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-And.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-And.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-And.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-And.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-And.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-And.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Antlia Image","name":"Antlia Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Ant.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Ant.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Ant.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Ant.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Ant.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Ant.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Ant.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Ant.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Ant.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Ant.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Ant.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Ant.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Ant.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Ant.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ant.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Ant.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Apus Image","name":"Apus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Aps.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Aps.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Aps.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Aps.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Aps.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Aps.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Aps.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Aps.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Aps.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Aps.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Aps.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Aps.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Aps.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Aps.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aps.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Aps.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Aquarius Image","name":"Aquarius Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Aqr.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Aqr.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Aqr.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Aqr.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Aqr.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Aqr.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Aqr.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Aqr.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Aqr.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aqr.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Aqr.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","zodiac","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Aquila Image","name":"Aquila Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Aql.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Aql.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Aql.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Aql.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Aql.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Aql.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Aql.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Aql.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Aql.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Aql.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Aql.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Aql.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Aql.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Aql.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aql.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Aql.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","equatorial","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Ara Image","name":"Ara Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Ara.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Ara.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Ara.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Ara.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Ara.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Ara.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Ara.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Ara.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Ara.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Ara.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Ara.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Ara.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Ara.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Ara.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ara.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Ara.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"","name":"Ariel","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Ariel.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Ariel.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Ariel.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Ariel.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Ariel.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Ariel.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Ariel.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Ariel.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Ariel.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Ariel.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Ariel.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Ariel.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Ariel.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Ariel.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Ariel.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Ariel.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Ariel.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Ariel.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The intensity factor for the ambient light used for light shading.","identifier":"AmbientIntensity","name":"Ambient Intensity","type":"FloatProperty","uri":"Scene.Ariel.Renderable.AmbientIntensity"},{"description":"The currently used scale factor whose target value is deteremined by 'TargetLodScaleFactor'.","identifier":"CurrentLodScaleFactor","name":"Current Level of Detail Scale Factor (Read Only)","type":"FloatProperty","uri":"Scene.Ariel.Renderable.CurrentLodScaleFactor"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Ariel.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Ariel.Renderable.Fade"},{"description":"The identifier of a scene graph node that should be used as the source of illumination for the globe. If not specified, the solar system's Sun is used.","identifier":"LightSourceNode","name":"Light Source","type":"StringProperty","uri":"Scene.Ariel.Renderable.LightSourceNode"},{"description":"The number of currently active layers. If this value reaches the maximum, bad things will happen.","identifier":"NActiveLayers","name":"Number of active layers","type":"IntProperty","uri":"Scene.Ariel.Renderable.NActiveLayers"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Ariel.Renderable.Opacity"},{"description":"The roughness factor that is used for the Oren-Nayar lighting mode.","identifier":"OrenNayarRoughness","name":"orenNayarRoughness","type":"FloatProperty","uri":"Scene.Ariel.Renderable.OrenNayarRoughness"},{"description":"Specifies whether the planet should be shaded by the primary light source or not. If disabled, all parts of the planet are illuminated. Note that if the globe has a corresponding atmosphere, there is a separate setting to control the shadowing induced by the atmosphere.","identifier":"PerformShading","name":"Perform shading","type":"BoolProperty","uri":"Scene.Ariel.Renderable.PerformShading"},{"description":"Tells the rendering engine not to perform distance based performance culling for this globe. Turning this property on will let the globe to be seen at far away distances when normally it would be hidden.","identifier":"RenderAtDistance","name":"Render at Distance","type":"BoolProperty","uri":"Scene.Ariel.Renderable.RenderAtDistance"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Ariel.Renderable.Type"},{"description":"Determines the targeted level-of-detail of the tiles for this globe. A higher value means that the tiles rendered are a higher resolution for the same distance of the camera to the planet.","identifier":"TargetLodScaleFactor","name":"Target Level of Detail Scale Factor","type":"FloatProperty","uri":"Scene.Ariel.Renderable.TargetLodScaleFactor"},{"description":"Determines whether higher-accuracy normals should be used in the rendering. These normals are calculated based on the height field information and are thus only available if the planet has a height map layer.","identifier":"UseAccurateNormals","name":"Use Accurate Normals","type":"BoolProperty","uri":"Scene.Ariel.Renderable.UseAccurateNormals"}],"propertyOwners":[{"description":"","name":"Debug","properties":[{"description":"The number of checks that have to fail/succeed in a row before the dynamic level-of-detail adjusts the actual level-of-detail up or down during a session recording.","identifier":"DynamicLodIterationCount","name":"Data availability checks before LOD factor impact","type":"IntProperty","uri":"Scene.Ariel.Renderable.Debug.DynamicLodIterationCount"},{"description":"If true, the tile level is determined by the area projected on screen. If false, the distance to the center of the tile is used instead.","identifier":"LevelByProjectedAreaElseDistance","name":"Level by projected area (else distance)","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Debug.LevelByProjectedAreaElseDistance"},{"description":"The tile level that is used as the cut off between rendering tiles using the globe model rendering vs the flat in-game rendering method. The value is a trade-off between not having precision errors in the rendering and representing a tile as flat or curved.","identifier":"ModelSpaceRenderingCutoffLevel","name":"Model Space Rendering Cutoff Level","type":"IntProperty","uri":"Scene.Ariel.Renderable.Debug.ModelSpaceRenderingCutoffLevel"},{"description":"If this value is set to true, frustum culling will be performed.","identifier":"PerformFrustumCulling","name":"Perform frustum culling","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Debug.PerformFrustumCulling"},{"description":"Reset all tile provides for the globe and reload the data.","identifier":"ResetTileProviders","name":"Reset tile providers","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Debug.ResetTileProviders"},{"description":"Shows the borders between chunks in a red highlight.","identifier":"ShowChunkEdges","name":"Show chunk edges","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Debug.ShowChunkEdges"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"GeoJson","properties":[],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Layers","properties":[],"propertyOwners":[{"description":"","name":"Color Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Layers.ColorLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Height Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Layers.HeightLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Night Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Layers.NightLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Overlays","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Layers.Overlays.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Water Masks","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Ariel.Renderable.Layers.WaterMasks.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"ShadowMapping","properties":[{"description":"The number of samples used during shadow mapping calculation (Percentage Closer Filtering).","identifier":"NumberShadowSamples","name":"Number of Shadow Samples","type":"IntProperty","uri":"Scene.Ariel.Renderable.ShadowMapping.NumberShadowSamples"},{"description":"Enables shadow mapping algorithm. Used by renderable rings, too.","identifier":"ShadowMapping","name":"Shadow Mapping","type":"BoolProperty","uri":"Scene.Ariel.Renderable.ShadowMapping.ShadowMapping"},{"description":"The percentage of the correct distance to the surface being shadowed.","identifier":"ZFightingPercentage","name":"Z-Fighting Percentage","type":"FloatProperty","uri":"Scene.Ariel.Renderable.ShadowMapping.ZFightingPercentage"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGlobe"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.Ariel.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.Ariel.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Ariel.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.Ariel.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.Ariel.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.Ariel.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":["moon_solarSystem","moon_giants","moon_uranus","moon_major","moon_major_uranus"],"type":"SceneGraphNode"},{"description":"Label for Uranus' moon Ariel","name":"Ariel Label","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ArielLabel.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ArielLabel.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ArielLabel.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ArielLabel.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ArielLabel.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ArielLabel.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ArielLabel.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ArielLabel.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ArielLabel.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ArielLabel.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ArielLabel.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ArielLabel.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ArielLabel.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ArielLabel.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ArielLabel.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ArielLabel.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ArielLabel.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ArielLabel.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"This determines the blending mode that is applied to the renderable.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ArielLabel.Renderable.BlendMode"},{"description":"The label text color.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.ArielLabel.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ArielLabel.Renderable.DimInAtmosphere"},{"description":"Enable/Disable the Fade-in effect.","identifier":"EnableFading","name":"Enable/Disable Fade-in Effect","type":"BoolProperty","uri":"Scene.ArielLabel.Renderable.EnableFading"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ArielLabel.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ArielLabel.Renderable.Fade"},{"description":"Distance unit for fade-in/-out distance calculations. Defaults to \"au\".","identifier":"FadeUnit","name":"Fade Distance Unit","type":"OptionProperty","uri":"Scene.ArielLabel.Renderable.FadeUnit"},{"description":"The distance range in which the labels should be fully opaque, specified in the chosen unit. The distance from the position of the label to the camera.","identifier":"FadeDistances","name":"Fade Distances","type":"Vec2Property","uri":"Scene.ArielLabel.Renderable.FadeDistances"},{"description":"The distances over which the fading takes place, given in the specified unit. The first value is the distance before the closest distance and the second the one after the furthest distance. For example, with the unit Parsec (pc), a value of {1, 2} will make the label being fully faded out 1 Parsec before the closest distance and 2 Parsec away from the furthest distance.","identifier":"FadeWidths","name":"Fade Widths","type":"Vec2Property","uri":"Scene.ArielLabel.Renderable.FadeWidths"},{"description":"The font size (in points) for the label.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.ArielLabel.Renderable.FontSize"},{"description":"The minimum and maximum size (in pixels) of the label.","identifier":"MinMaxSize","name":"Min and Max Size","type":"IVec2Property","uri":"Scene.ArielLabel.Renderable.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ArielLabel.Renderable.Opacity"},{"description":"Label orientation rendering mode.","identifier":"OrientationOption","name":"Orientation Option","type":"OptionProperty","uri":"Scene.ArielLabel.Renderable.OrientationOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ArielLabel.Renderable.Type"},{"description":"Scales the size of the label, exponentially. The value is used as the exponent in a 10^x computation to scale the label size.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.ArielLabel.Renderable.Size"},{"description":"The text that will be displayed on screen.","identifier":"Text","name":"Text","type":"StringProperty","uri":"Scene.ArielLabel.Renderable.Text"}],"propertyOwners":[],"tags":[],"type":"RenderableLabel"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ArielLabel.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ArielLabel.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ArielLabel.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["solarsystem_labels","moon_labels","major_moon_labels"],"type":"SceneGraphNode"},{"description":"","name":"Ariel Trail","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ArielTrail.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ArielTrail.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ArielTrail.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ArielTrail.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ArielTrail.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ArielTrail.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ArielTrail.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ArielTrail.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ArielTrail.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ArielTrail.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ArielTrail.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ArielTrail.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ArielTrail.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ArielTrail.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ArielTrail.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ArielTrail.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ArielTrail.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ArielTrail.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ArielTrail.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ArielTrail.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ArielTrail.Renderable.Fade"},{"description":"The number of samples along the orbit. This determines the resolution of the trail; the tradeoff being that a higher resolution is able to resolve more detail, but will take more resources while rendering, too. The higher, the smoother the trail, but also more memory will be used.","identifier":"Resolution","name":"Number of samples along the orbit","type":"IntProperty","uri":"Scene.ArielTrail.Renderable.Resolution"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ArielTrail.Renderable.Opacity"},{"description":"The objects period, i.e. the length of its orbit around the parent object given in (Earth) days. In the case of Earth, this would be a sidereal year (=365.242 days). If this values is specified as multiples of the period, it is possible to show the effects of precession.","identifier":"Period","name":"Period (in days)","type":"DoubleProperty","uri":"Scene.ArielTrail.Renderable.Period"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ArielTrail.Renderable.Type"}],"propertyOwners":[{"description":"The appearance of the trail","name":"Appearance","properties":[{"description":"This value determines the RGB main color for the lines and points of the trail.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.ArielTrail.Renderable.Appearance.Color"},{"description":"Toggles whether the trail should fade older points out. If this value is true, the 'Fade' parameter determines the speed of fading. If this value is false, the entire trail is rendered at full opacity and color.","identifier":"EnableFade","name":"Enable line fading of old points","type":"BoolProperty","uri":"Scene.ArielTrail.Renderable.Appearance.EnableFade"},{"description":"The amount of the trail that should be faded. If the value is 0 then the trail will have no fading applied. A value of 0.6 will result in a trail where 60% of the extent of the trail will have fading applied to it. In otherwords, the 40% closest to the head of the trail will be solid and the rest will fade until completely transparent at the end of the trail. A value of 1 will result in a trail that starts fading immediately, becoming fully transparent by the end of the trail. This setting only applies if the 'EnableFade' value is true. If it is false, this setting has no effect.","identifier":"LineFadeAmount","name":"Line Fade Amount","type":"FloatProperty","uri":"Scene.ArielTrail.Renderable.Appearance.LineFadeAmount"},{"description":"The extent of the rendered trail. A value of 0 will result in no trail and a value of 1 will result in a trail that covers the entire extent. The setting only applies if 'EnableFade' is true. If it is false, this setting has no effect.","identifier":"LineLength","name":"Line Length","type":"FloatProperty","uri":"Scene.ArielTrail.Renderable.Appearance.LineLength"},{"description":"Specifies the line width of the trail lines, if the selected rendering method includes lines. If the rendering mode is Points, this value is ignored.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.ArielTrail.Renderable.Appearance.LineWidth"},{"description":"Specifies the base size of the points along the line, if the selected rendering method includes points. If the rendering mode is Lines, this value is ignored. If a subsampling of the values is performed, the subsampled values are half this size.","identifier":"PointSize","name":"Point Size","type":"IntProperty","uri":"Scene.ArielTrail.Renderable.Appearance.PointSize"},{"description":"Determines how the trail should be rendered. If 'Lines' is selected, only the line part is visible, if 'Points' is selected, only the corresponding points (and subpoints) are shown. 'Lines+Points' shows both parts.","identifier":"Rendering","name":"Rendering Mode","type":"OptionProperty","uri":"Scene.ArielTrail.Renderable.Appearance.Rendering"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.ArielTrail.Renderable.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.ArielTrail.Renderable.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.ArielTrail.Renderable.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.ArielTrail.Renderable.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":[],"type":"RenderableTrailOrbit"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ArielTrail.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ArielTrail.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ArielTrail.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["moonTrail_solarSystem","moonTrail_giants","moonTrail_uranus","moonTrail_major_uranus"],"type":"SceneGraphNode"},{"description":"Aries Image","name":"Aries Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Ari.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Ari.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Ari.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Ari.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Ari.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Ari.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Ari.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Ari.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Ari.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Ari.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Ari.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Ari.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Ari.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Ari.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Ari.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Ari.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","zodiac","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Auriga Image","name":"Auriga Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Aur.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Aur.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Aur.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Aur.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Aur.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Aur.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Aur.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Aur.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Aur.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Aur.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Aur.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Aur.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Aur.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Aur.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Aur.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Aur.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Orbits of Barnard's Star around the Milky Way","name":"Barnards Orbit","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.BarnardsOrbit.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.BarnardsOrbit.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.BarnardsOrbit.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.BarnardsOrbit.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.BarnardsOrbit.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.BarnardsOrbit.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.BarnardsOrbit.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.BarnardsOrbit.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.BarnardsOrbit.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.BarnardsOrbit.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.BarnardsOrbit.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the astronomical objects.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.BarnardsOrbit.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.BarnardsOrbit.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.BarnardsOrbit.Renderable.Fade"},{"description":"If the DU mesh is of wire type, this value determines the width of the lines.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.BarnardsOrbit.Renderable.LineWidth"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.BarnardsOrbit.Renderable.Opacity"},{"description":"Debug option for rendering of billboards and texts.","identifier":"RenderOption","name":"Render Option","type":"OptionProperty","uri":"Scene.BarnardsOrbit.Renderable.RenderOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.BarnardsOrbit.Renderable.Type"}],"propertyOwners":[],"tags":[],"type":"RenderableDUMeshes"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.BarnardsOrbit.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.BarnardsOrbit.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.BarnardsOrbit.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Bootes Image","name":"Bootes Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Boo.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Boo.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Boo.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Boo.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Boo.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Boo.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Boo.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Boo.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Boo.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Boo.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Boo.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Boo.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Boo.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Boo.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Boo.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Boo.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Census: 785 L dwarfs, 101 T dwarfs, 17 Y dwarfs. DU Version 6.4.\n      <br> In astronomy, there are dwarf stars-red, white, and brown-dwarf novae,\n      and even dwarf galaxies. As you might imagine, astronomers use the term dwarf\n      when they refer to the smaller objects in any given class. For decades it was\n      believed that M stars were the coolest stars in the Galaxy. Some M stars,\n      called red dwarfs, make up 70% of the stars in the Galaxy, including our\n      nearest known neighbor, Proxima Centauri. However, a new class of objects,\n      even cooler than M stars, was recently discovered and given a spectral type\n      of L. L-type objects straddle the boundary between red dwarfs and brown\n      dwarfs, the latter of which are not massive enough to ignite the nuclear\n      processes necessary for it to shine as a star. L-type objects are typically\n      very dim stars or brown dwarfs. Even cooler than L-type objects are T-type\n      objects. These are mostly brown dwarfs and resemble large, massive,\n      Jupiter-like objects, too large to be planets and typically too small to be\n      stars. Beyond the T dwarfs are the Y-type objects, which are even more\n      dim.(Description from URL) <br><br> Data Reference: The Brown Dwarf Kinematics\n      Project (Faherty+ 2019)","name":"Brown Dwarfs","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Dwarfs.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Dwarfs.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Dwarfs.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Dwarfs.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Dwarfs.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Dwarfs.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Dwarfs.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Dwarfs.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Dwarfs.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Dwarfs.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Dwarfs.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Dwarfs.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Dwarfs.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Dwarfs.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Dwarfs.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Dwarfs.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Dwarfs.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Dwarfs.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the points.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Fade"},{"description":"Set to true if orientation data was read from the dataset.","identifier":"HasOrientationData","name":"Has Orientation Data","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.HasOrientationData"},{"description":"Information about how many points are being rendered.","identifier":"NumberOfDataPoints","name":"Number of Shown Data Points","type":"UIntProperty","uri":"Scene.Dwarfs.Renderable.NumberOfDataPoints"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Opacity"},{"description":"Controls how the planes for the points will be oriented. \"Camera View Direction\" rotates the points so that the plane is orthogonal to the viewing direction of the camera (useful for planar displays), and \"Camera Position Normal\" rotates the points towards the position of the camera (useful for spherical displays, like dome theaters). In both these cases the points will be billboarded towards the camera. In contrast, \"Fixed Rotation\" does not rotate the points at all based on the camera and should be used when the dataset contains orientation information for the points.","identifier":"OrientationRenderOption","name":"Orientation Render Option","type":"OptionProperty","uri":"Scene.Dwarfs.Renderable.OrientationRenderOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Dwarfs.Renderable.Type"},{"description":"If true (default), the color of points rendered on top of each other is blended additively, resulting in a brighter color where points overlap. If false, no such blending will take place and the color of the point will not be modified by blending. Note that this may lead to weird behaviors when the points are rendered with transparency.","identifier":"UseAdditiveBlending","name":"Use Additive Blending","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.UseAdditiveBlending"},{"description":"If true, the orientation data in the dataset is included when rendering the points, if there is any. To see the rotation, you also need to set the \"Orientation Render Option\" to \"Fixed Rotation\".","identifier":"UseOrientationData","name":"Use Orientation Data","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.UseOrientationData"}],"propertyOwners":[{"description":"","name":"Coloring","properties":[{"description":"If true and the outline is enabled, the color map will be applied to the outline rather than the point body. Only works if color mapping is enabled.","identifier":"ApplyColorMapToOutline","name":"Apply Color Map to Outline","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ApplyColorMapToOutline"},{"description":"Determines whether each point should have an outline or not.","identifier":"EnableOutline","name":"Enable Point Outline","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Coloring.EnableOutline"},{"description":"The color of the points, when no color map is used.","identifier":"FixedColor","name":"Fixed Color","type":"Vec3Property","uri":"Scene.Dwarfs.Renderable.Coloring.FixedColor"},{"description":"The color of the outline. Darker colors will be less visible if \"Additive Blending\" is enabled.","identifier":"OutlineColor","name":"Outline Color","type":"Vec3Property","uri":"Scene.Dwarfs.Renderable.Coloring.OutlineColor"},{"description":"Decides the style of the outline (round, square, or a line at the bottom). The style also affects the shape of the points.","identifier":"OutlineStyle","name":"Outline Style","type":"OptionProperty","uri":"Scene.Dwarfs.Renderable.Coloring.OutlineStyle"},{"description":"The thickness of the outline, given as a value relative to the size of the point. A value of 0 will not show any outline, while a value of 1 will cover the whole point.","identifier":"OutlineWidth","name":"Outline Width","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Coloring.OutlineWidth"}],"propertyOwners":[{"description":"","name":"Color Mapping","properties":[{"description":"The color to use for items with values larger than the one in the provided data range, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the above range values is provided, the UseAboveRangeColor property will automatically be set to true.","identifier":"AboveRangeColor","name":"Above Range Color","type":"Vec4Property","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.AboveRangeColor"},{"description":"The color to use for items with values smaller than the one in the provided data range, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the below range values is provided, the UseBelowRangeColor property will automatically be set to true.","identifier":"BelowRangeColor","name":"Below Range Color","type":"Vec4Property","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.BelowRangeColor"},{"description":"If this value is set to 'true', the provided color map is used (if one was provided in the configuration). If no color map was provided, changing this setting does not do anything.","identifier":"Enabled","name":"Color Map Enabled","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.Enabled"},{"description":"The path to the color map file to use for coloring the points.","identifier":"File","name":"Color Map File","type":"StringProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.File"},{"description":"If true, points with values outside the provided range for the coloring will be hidden, i.e. not rendered at all.","identifier":"HideValuesOutsideRange","name":"Hide Values Outside Range","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.HideValuesOutsideRange"},{"description":"If true, the colors of the color map will be read in the inverse order.","identifier":"Invert","name":"Invert Color Map","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.Invert"},{"description":"The color to use for items with values corresponding to missing data values, if enabled. This color can also be read from the color map, but setting this value overrides any value in the color map. If a color value for the below range values is provided, the ShowMissingData property will automatically be set to true.","identifier":"NoDataColor","name":"No Data Color","type":"Vec4Property","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.NoDataColor"},{"description":"This value determines which paramenter is used for coloring the points based on the color map. The property is set based on predefined options specified in the asset file. When changing the parameter, the value range to used for themapping will also be changed. Per default, it is set to the last parameter in the list of options.","identifier":"Parameter","name":"Parameter","type":"OptionProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.Parameter"},{"description":"Set the data range for the color mapping based on the available data for the curently selected data column.","identifier":"SetRangeFromData","name":"Set Data Range from Data","type":"TriggerProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.SetRangeFromData"},{"description":"If true, use a separate color (see NoDataColor) for items with values corresponding to missing data values.","identifier":"ShowMissingData","name":"Show Missing Data","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.ShowMissingData"},{"description":"If true, use a separate color (see AboveRangeColor) for items with values larger than the one in the provided data range. Otherwise, the values will be clamped to use the color at the upper limit of the color map. If a color is provided in the color map, this value will automatically be set to true.","identifier":"UseAboveRangeColor","name":"Use Above Range Color","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.UseAboveRangeColor"},{"description":"If true, use a separate color (see BelowRangeColor) for items with values smaller than the one in the provided data range. Otherwise, the values will be clamped to use the color at the lower limit of the color map. If a color is provided in the color map, this value will automatically be set to true.","identifier":"UseBelowRangeColor","name":"Use Below Range Color","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.UseBelowRangeColor"},{"description":"This value changes the range of values to be mapped with the current color map.","identifier":"ValueRange","name":"Value Range","type":"Vec2Property","uri":"Scene.Dwarfs.Renderable.Coloring.ColorMapping.ValueRange"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.Dwarfs.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.Dwarfs.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Sizing","properties":[{"description":"If true, the Max Size property will be used as an upper limit for the size of the point. This reduces the size of the points when approaching them, so that they stick to a maximum visual size depending on the Max Size value.","identifier":"EnableMaxSizeControl","name":"Enable Max Size Control","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Sizing.EnableMaxSizeControl"},{"description":"Controls the maximum allowed size for the points, when the max size control feature is enabled. This limits the visual size of the points based on the distance to the camera. The larger the value, the larger the points may be. In the background, the computations are made by limiting the size to a certain angle based on the field of view of the camera. So a value of 1 limits the point size to take up a maximum of one degree of the view space.","identifier":"MaxSize","name":"Max Size","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Sizing.MaxSize"},{"description":"An exponential scale value used to set the absolute size of the point. In general, the larger distance the dataset covers, the larger this value should be. If not included, it is computed based on the maximum positional component of the data points. This is useful for showing the dataset at all, but you will likely want to change it to something that looks good. Note that a scale exponent of 0 leads to the points having a diameter of 1 meter, i.e. no exponential scaling.","identifier":"ScaleExponent","name":"Scale Exponent","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Sizing.ScaleExponent"},{"description":"A multiplicative factor used to adjust the size of the points, after the exponential scaling and any max size control effects. Simply just increases or decreases the visual size of the points.","identifier":"ScaleFactor","name":"Scale Factor","type":"FloatProperty","uri":"Scene.Dwarfs.Renderable.Sizing.ScaleFactor"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Texture","properties":[{"description":"If true, the textures will be compressed to preserve graphics card memory. This is enabled per default, but may lead to visible artefacts for certain images, especially up close. Set this to false to disable any hardware compression of the textures, and represent each color channel with 8 bits.","identifier":"AllowCompression","name":"Allow Compression","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Texture.AllowCompression"},{"description":"If true, use a provided sprite texture to render the point. If false, draw the points using the default point shape.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Texture.Enabled"},{"description":"The path to the texture of the point sprite. Note that if multiple textures option is set in the asset, by providing a texture folder, this value will be ignored.","identifier":"File","name":"Point Sprite Texture File","type":"StringProperty","uri":"Scene.Dwarfs.Renderable.Texture.File"},{"description":"This tells which texture mode is being used for this renderable. There are three different texture modes: 1) One single sprite texture used for all points, 2) Multiple textures, that are mapped to the points based on a column in the dataset, and 3) Other, which is used for specific subtypes where the texture is internally controlled by the renderable and can't be set from a file (such as the RenderablePolygonCloud).","identifier":"TextureMode","name":"Texture Mode","type":"StringProperty","uri":"Scene.Dwarfs.Renderable.Texture.TextureMode"},{"description":"If true, include transparency information in the loaded textures, if there is any. If false, all loaded textures will be converted to RGB format. \nThis setting can be used if you have textures with transparency, but do not need the transparency information. This may be the case when using additive blending, for example. Converting the files to RGB on load may then reduce the memory footprint and/or lead to some optimization in terms of rendering speed.","identifier":"UseAlphaChannel","name":"Use Alpha Channel","type":"BoolProperty","uri":"Scene.Dwarfs.Renderable.Texture.UseAlphaChannel"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderablePointCloud"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.Dwarfs.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.Dwarfs.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.Dwarfs.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Caelum Image","name":"Caelum Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cae.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cae.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cae.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cae.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cae.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cae.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cae.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cae.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cae.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cae.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cae.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cae.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cae.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cae.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cae.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cae.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"","name":"Callisto","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Callisto.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Callisto.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Callisto.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Callisto.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Callisto.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Callisto.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Callisto.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Callisto.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Callisto.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Callisto.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Callisto.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Callisto.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Callisto.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Callisto.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Callisto.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Callisto.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Callisto.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Callisto.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The intensity factor for the ambient light used for light shading.","identifier":"AmbientIntensity","name":"Ambient Intensity","type":"FloatProperty","uri":"Scene.Callisto.Renderable.AmbientIntensity"},{"description":"The currently used scale factor whose target value is deteremined by 'TargetLodScaleFactor'.","identifier":"CurrentLodScaleFactor","name":"Current Level of Detail Scale Factor (Read Only)","type":"FloatProperty","uri":"Scene.Callisto.Renderable.CurrentLodScaleFactor"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Callisto.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Fade"},{"description":"The identifier of a scene graph node that should be used as the source of illumination for the globe. If not specified, the solar system's Sun is used.","identifier":"LightSourceNode","name":"Light Source","type":"StringProperty","uri":"Scene.Callisto.Renderable.LightSourceNode"},{"description":"The number of currently active layers. If this value reaches the maximum, bad things will happen.","identifier":"NActiveLayers","name":"Number of active layers","type":"IntProperty","uri":"Scene.Callisto.Renderable.NActiveLayers"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Opacity"},{"description":"The roughness factor that is used for the Oren-Nayar lighting mode.","identifier":"OrenNayarRoughness","name":"orenNayarRoughness","type":"FloatProperty","uri":"Scene.Callisto.Renderable.OrenNayarRoughness"},{"description":"Specifies whether the planet should be shaded by the primary light source or not. If disabled, all parts of the planet are illuminated. Note that if the globe has a corresponding atmosphere, there is a separate setting to control the shadowing induced by the atmosphere.","identifier":"PerformShading","name":"Perform shading","type":"BoolProperty","uri":"Scene.Callisto.Renderable.PerformShading"},{"description":"Tells the rendering engine not to perform distance based performance culling for this globe. Turning this property on will let the globe to be seen at far away distances when normally it would be hidden.","identifier":"RenderAtDistance","name":"Render at Distance","type":"BoolProperty","uri":"Scene.Callisto.Renderable.RenderAtDistance"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Callisto.Renderable.Type"},{"description":"Determines the targeted level-of-detail of the tiles for this globe. A higher value means that the tiles rendered are a higher resolution for the same distance of the camera to the planet.","identifier":"TargetLodScaleFactor","name":"Target Level of Detail Scale Factor","type":"FloatProperty","uri":"Scene.Callisto.Renderable.TargetLodScaleFactor"},{"description":"Determines whether higher-accuracy normals should be used in the rendering. These normals are calculated based on the height field information and are thus only available if the planet has a height map layer.","identifier":"UseAccurateNormals","name":"Use Accurate Normals","type":"BoolProperty","uri":"Scene.Callisto.Renderable.UseAccurateNormals"}],"propertyOwners":[{"description":"","name":"Debug","properties":[{"description":"The number of checks that have to fail/succeed in a row before the dynamic level-of-detail adjusts the actual level-of-detail up or down during a session recording.","identifier":"DynamicLodIterationCount","name":"Data availability checks before LOD factor impact","type":"IntProperty","uri":"Scene.Callisto.Renderable.Debug.DynamicLodIterationCount"},{"description":"If true, the tile level is determined by the area projected on screen. If false, the distance to the center of the tile is used instead.","identifier":"LevelByProjectedAreaElseDistance","name":"Level by projected area (else distance)","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Debug.LevelByProjectedAreaElseDistance"},{"description":"The tile level that is used as the cut off between rendering tiles using the globe model rendering vs the flat in-game rendering method. The value is a trade-off between not having precision errors in the rendering and representing a tile as flat or curved.","identifier":"ModelSpaceRenderingCutoffLevel","name":"Model Space Rendering Cutoff Level","type":"IntProperty","uri":"Scene.Callisto.Renderable.Debug.ModelSpaceRenderingCutoffLevel"},{"description":"If this value is set to true, frustum culling will be performed.","identifier":"PerformFrustumCulling","name":"Perform frustum culling","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Debug.PerformFrustumCulling"},{"description":"Reset all tile provides for the globe and reload the data.","identifier":"ResetTileProviders","name":"Reset tile providers","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Debug.ResetTileProviders"},{"description":"Shows the borders between chunks in a red highlight.","identifier":"ShowChunkEdges","name":"Show chunk edges","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Debug.ShowChunkEdges"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"GeoJson","properties":[],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Labels","properties":[{"description":"Labels are aligned horizontally or circularly related to the planet.","identifier":"AlignmentOption","name":"Alignment Option","type":"OptionProperty","uri":"Scene.Callisto.Renderable.Labels.AlignmentOption"},{"description":"The text color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.Callisto.Renderable.Labels.Color"},{"description":"Labels culling disabled.","identifier":"DisableCulling","name":"Culling Disabled","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Labels.DisableCulling"},{"description":"Labels culling distance from globe's center.","identifier":"DistanceEPS","name":"Culling Distance","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Labels.DistanceEPS"},{"description":"Enables and disables labels' rendering.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Labels.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Labels.Fade"},{"description":"Sets whether the labels fade in when approaching the globe from a distance. If false, no fading happens and the labels immediately has full opacity.","identifier":"FadeInEnabled","name":"Fade In Enabled","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Labels.FadeInEnabled"},{"description":"Sets whether the labels fade out when approaching the surface of the globe. If false, no fading happens and the labels stays in full opacity.","identifier":"FadeOutEnabled","name":"Fade Out Enabled","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Labels.FadeOutEnabled"},{"description":"The distances above the globe's surface at which the labels start fading in or out, given in meters. The final distances are also adjusted by the specified height offset.","identifier":"FadeDistances","name":"Fade-In Distances","type":"Vec2Property","uri":"Scene.Callisto.Renderable.Labels.FadeDistances"},{"description":"Font size for the rendering labels. This is different fromt text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Labels.FontSize"},{"description":"This value moves the label away from the globe surface by the specified distance (in meters).","identifier":"HeightOffset","name":"Height Offset","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Labels.HeightOffset"},{"description":"This value affects the size scale of the labels.","identifier":"LabelsSize","name":"Labels Size","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Labels.LabelsSize"},{"description":"Minimum and maximum label size, in pixels.","identifier":"MinMaxSize","name":"Min/Max Text Size","type":"IVec2Property","uri":"Scene.Callisto.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Labels.Opacity"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Layers","properties":[],"propertyOwners":[{"description":"","name":"Color Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.BlendTileLevels"}],"propertyOwners":[{"description":"","name":"Texture","properties":[{"description":"This value specifies the blend mode that is applied to this layer. The blend mode determines how this layer is added to the underlying layers beneath.","identifier":"BlendMode","name":"Blend Mode","type":"OptionProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.BlendMode"},{"description":"If this value is enabled, the layer will be used for the final composition of the planet. If this value is disabled, the layer will be ignored in the composition.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Fade"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Opacity"},{"description":"If this value is triggered, a script will be executed that will remove this layer before the next frame.","identifier":"Remove","name":"Remove","type":"TriggerProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Remove"},{"description":"If this value is triggered, this layer will be reset. This will delete the local cache for this layer and will trigger a fresh load of all tiles.","identifier":"Reset","name":"Reset","type":"TriggerProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Reset"},{"description":"The type of this Layer. This value is a read-only property and thus cannot be changed.","identifier":"Type","name":"Type","type":"OptionProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Type"}],"propertyOwners":[{"description":"","name":"Adjustment","properties":[{"description":"The type of layer adjustment that is applied to the underlying layer.","identifier":"Type","name":"Type","type":"OptionProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Adjustment.Type"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Settings","properties":[{"description":"This value is used as an exponent to adjust the color for each tile.","identifier":"Gamma","name":"Gamma","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Settings.Gamma"},{"description":"This value is used as a multiplier to adjust the color applied after taking the gamma value as an exponent.","identifier":"Multiplier","name":"Multiplier","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Settings.Multiplier"},{"description":"This value is used as an additive modifier to adjust the color applied after the gamma exponent and the multiplier has been performed.","identifier":"Offset","name":"Offset","type":"FloatProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Settings.Offset"},{"description":"If this value is triggered it will reset all of these values to their default values.","identifier":"SetDefault","name":"Set Default","type":"TriggerProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.Settings.SetDefault"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Tile Provider","properties":[{"description":"The path of the GDAL file or the image file that is to be used in this tile provider.","identifier":"FilePath","name":"File Path","type":"StringProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.TileProvider.FilePath"},{"description":"This value is the preferred size (in pixels) for each tile. Choosing the right value is a tradeoff between more efficiency (larger images) and better quality (smaller images). The tile pixel size has to be smaller than the size of the complete image if a single image is used.","identifier":"TilePixelSize","name":"Tile Pixel Size","type":"IntProperty","uri":"Scene.Callisto.Renderable.Layers.ColorLayers.Texture.TileProvider.TilePixelSize"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"Height Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Layers.HeightLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Night Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Layers.NightLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Overlays","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Layers.Overlays.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Water Masks","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Callisto.Renderable.Layers.WaterMasks.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"ShadowMapping","properties":[{"description":"The number of samples used during shadow mapping calculation (Percentage Closer Filtering).","identifier":"NumberShadowSamples","name":"Number of Shadow Samples","type":"IntProperty","uri":"Scene.Callisto.Renderable.ShadowMapping.NumberShadowSamples"},{"description":"Enables shadow mapping algorithm. Used by renderable rings, too.","identifier":"ShadowMapping","name":"Shadow Mapping","type":"BoolProperty","uri":"Scene.Callisto.Renderable.ShadowMapping.ShadowMapping"},{"description":"The percentage of the correct distance to the surface being shadowed.","identifier":"ZFightingPercentage","name":"Z-Fighting Percentage","type":"FloatProperty","uri":"Scene.Callisto.Renderable.ShadowMapping.ZFightingPercentage"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGlobe"},{"description":"","name":"Rotation","properties":[{"description":"This value specifies the destination frame that is used for the coordinate transformation. This has to be a valid SPICE name.","identifier":"DestinationFrame","name":"Destination","type":"StringProperty","uri":"Scene.Callisto.Rotation.DestinationFrame"},{"description":"A time to lock the rotation to. Setting this to an empty string will unlock the time and return to rotation based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Callisto.Rotation.FixedDate"},{"description":"This value specifies the source frame that is used as the basis for the coordinate transformation. This has to be a valid SPICE name.","identifier":"SourceFrame","name":"Source","type":"StringProperty","uri":"Scene.Callisto.Rotation.SourceFrame"}],"propertyOwners":[],"tags":[],"type":"SpiceRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.Callisto.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Callisto.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.Callisto.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.Callisto.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.Callisto.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":["moon_solarSystem","moon_giants","moon_jupiter","moon_major_jupiter"],"type":"SceneGraphNode"},{"description":"Label for Jupiter's moon Callisto","name":"Callisto Label","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.CallistoLabel.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.CallistoLabel.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.CallistoLabel.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.CallistoLabel.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.CallistoLabel.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.CallistoLabel.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.CallistoLabel.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.CallistoLabel.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.CallistoLabel.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.CallistoLabel.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.CallistoLabel.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.CallistoLabel.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.CallistoLabel.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.CallistoLabel.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.CallistoLabel.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.CallistoLabel.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.CallistoLabel.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.CallistoLabel.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"This determines the blending mode that is applied to the renderable.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.CallistoLabel.Renderable.BlendMode"},{"description":"The label text color.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.CallistoLabel.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.CallistoLabel.Renderable.DimInAtmosphere"},{"description":"Enable/Disable the Fade-in effect.","identifier":"EnableFading","name":"Enable/Disable Fade-in Effect","type":"BoolProperty","uri":"Scene.CallistoLabel.Renderable.EnableFading"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.CallistoLabel.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.CallistoLabel.Renderable.Fade"},{"description":"Distance unit for fade-in/-out distance calculations. Defaults to \"au\".","identifier":"FadeUnit","name":"Fade Distance Unit","type":"OptionProperty","uri":"Scene.CallistoLabel.Renderable.FadeUnit"},{"description":"The distance range in which the labels should be fully opaque, specified in the chosen unit. The distance from the position of the label to the camera.","identifier":"FadeDistances","name":"Fade Distances","type":"Vec2Property","uri":"Scene.CallistoLabel.Renderable.FadeDistances"},{"description":"The distances over which the fading takes place, given in the specified unit. The first value is the distance before the closest distance and the second the one after the furthest distance. For example, with the unit Parsec (pc), a value of {1, 2} will make the label being fully faded out 1 Parsec before the closest distance and 2 Parsec away from the furthest distance.","identifier":"FadeWidths","name":"Fade Widths","type":"Vec2Property","uri":"Scene.CallistoLabel.Renderable.FadeWidths"},{"description":"The font size (in points) for the label.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.CallistoLabel.Renderable.FontSize"},{"description":"The minimum and maximum size (in pixels) of the label.","identifier":"MinMaxSize","name":"Min and Max Size","type":"IVec2Property","uri":"Scene.CallistoLabel.Renderable.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.CallistoLabel.Renderable.Opacity"},{"description":"Label orientation rendering mode.","identifier":"OrientationOption","name":"Orientation Option","type":"OptionProperty","uri":"Scene.CallistoLabel.Renderable.OrientationOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.CallistoLabel.Renderable.Type"},{"description":"Scales the size of the label, exponentially. The value is used as the exponent in a 10^x computation to scale the label size.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.CallistoLabel.Renderable.Size"},{"description":"The text that will be displayed on screen.","identifier":"Text","name":"Text","type":"StringProperty","uri":"Scene.CallistoLabel.Renderable.Text"}],"propertyOwners":[],"tags":[],"type":"RenderableLabel"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.CallistoLabel.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.CallistoLabel.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.CallistoLabel.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["solarsystem_labels","moon_labels","major_moon_labels"],"type":"SceneGraphNode"},{"description":"","name":"Callisto Trail","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.CallistoTrail.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.CallistoTrail.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.CallistoTrail.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.CallistoTrail.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.CallistoTrail.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.CallistoTrail.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.CallistoTrail.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.CallistoTrail.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.CallistoTrail.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.CallistoTrail.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.CallistoTrail.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.CallistoTrail.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.CallistoTrail.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.CallistoTrail.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.CallistoTrail.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.CallistoTrail.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.CallistoTrail.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.CallistoTrail.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.CallistoTrail.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.CallistoTrail.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.CallistoTrail.Renderable.Fade"},{"description":"The number of samples along the orbit. This determines the resolution of the trail; the tradeoff being that a higher resolution is able to resolve more detail, but will take more resources while rendering, too. The higher, the smoother the trail, but also more memory will be used.","identifier":"Resolution","name":"Number of samples along the orbit","type":"IntProperty","uri":"Scene.CallistoTrail.Renderable.Resolution"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.CallistoTrail.Renderable.Opacity"},{"description":"The objects period, i.e. the length of its orbit around the parent object given in (Earth) days. In the case of Earth, this would be a sidereal year (=365.242 days). If this values is specified as multiples of the period, it is possible to show the effects of precession.","identifier":"Period","name":"Period (in days)","type":"DoubleProperty","uri":"Scene.CallistoTrail.Renderable.Period"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.CallistoTrail.Renderable.Type"}],"propertyOwners":[{"description":"The appearance of the trail","name":"Appearance","properties":[{"description":"This value determines the RGB main color for the lines and points of the trail.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.CallistoTrail.Renderable.Appearance.Color"},{"description":"Toggles whether the trail should fade older points out. If this value is true, the 'Fade' parameter determines the speed of fading. If this value is false, the entire trail is rendered at full opacity and color.","identifier":"EnableFade","name":"Enable line fading of old points","type":"BoolProperty","uri":"Scene.CallistoTrail.Renderable.Appearance.EnableFade"},{"description":"The amount of the trail that should be faded. If the value is 0 then the trail will have no fading applied. A value of 0.6 will result in a trail where 60% of the extent of the trail will have fading applied to it. In otherwords, the 40% closest to the head of the trail will be solid and the rest will fade until completely transparent at the end of the trail. A value of 1 will result in a trail that starts fading immediately, becoming fully transparent by the end of the trail. This setting only applies if the 'EnableFade' value is true. If it is false, this setting has no effect.","identifier":"LineFadeAmount","name":"Line Fade Amount","type":"FloatProperty","uri":"Scene.CallistoTrail.Renderable.Appearance.LineFadeAmount"},{"description":"The extent of the rendered trail. A value of 0 will result in no trail and a value of 1 will result in a trail that covers the entire extent. The setting only applies if 'EnableFade' is true. If it is false, this setting has no effect.","identifier":"LineLength","name":"Line Length","type":"FloatProperty","uri":"Scene.CallistoTrail.Renderable.Appearance.LineLength"},{"description":"Specifies the line width of the trail lines, if the selected rendering method includes lines. If the rendering mode is Points, this value is ignored.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.CallistoTrail.Renderable.Appearance.LineWidth"},{"description":"Specifies the base size of the points along the line, if the selected rendering method includes points. If the rendering mode is Lines, this value is ignored. If a subsampling of the values is performed, the subsampled values are half this size.","identifier":"PointSize","name":"Point Size","type":"IntProperty","uri":"Scene.CallistoTrail.Renderable.Appearance.PointSize"},{"description":"Determines how the trail should be rendered. If 'Lines' is selected, only the line part is visible, if 'Points' is selected, only the corresponding points (and subpoints) are shown. 'Lines+Points' shows both parts.","identifier":"Rendering","name":"Rendering Mode","type":"OptionProperty","uri":"Scene.CallistoTrail.Renderable.Appearance.Rendering"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.CallistoTrail.Renderable.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.CallistoTrail.Renderable.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.CallistoTrail.Renderable.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.CallistoTrail.Renderable.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":[],"type":"RenderableTrailOrbit"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.CallistoTrail.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.CallistoTrail.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.CallistoTrail.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["moonTrail_solarSystem","moonTrail_giants","moonTrail_jupiter","moonTrail_major_jupiter"],"type":"SceneGraphNode"},{"description":"Camelopardalis Image","name":"Camelopardalis Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cam.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cam.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cam.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cam.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cam.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cam.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cam.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cam.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cam.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cam.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cam.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cam.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cam.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cam.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cam.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cam.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Cancer Image","name":"Cancer Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cnc.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cnc.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cnc.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cnc.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cnc.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cnc.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cnc.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cnc.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cnc.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cnc.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cnc.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","zodiac","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Canes Venatici Image","name":"Canes Venatici Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-CVn.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-CVn.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-CVn.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-CVn.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-CVn.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-CVn.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-CVn.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-CVn.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-CVn.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-CVn.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-CVn.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-CVn.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-CVn.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-CVn.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-CVn.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-CVn.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Canis Major Image","name":"Canis Major Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-CMa.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-CMa.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-CMa.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-CMa.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-CMa.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-CMa.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-CMa.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-CMa.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-CMa.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-CMa.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-CMa.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-CMa.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-CMa.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-CMa.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMa.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-CMa.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Canis Minor Image","name":"Canis Minor Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-CMi.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-CMi.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-CMi.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-CMi.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-CMi.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-CMi.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-CMi.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-CMi.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-CMi.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-CMi.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-CMi.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-CMi.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-CMi.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-CMi.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-CMi.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-CMi.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Capricornus Image","name":"Capricornus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cap.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cap.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cap.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cap.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cap.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cap.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cap.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cap.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cap.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cap.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cap.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cap.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cap.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cap.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cap.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cap.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","zodiac","daytime_hidden"],"type":"SceneGraphNode"},{"description":"A textured sphere showing the cardinal directions.\n      The sphere is placed on the planet surface and follows the camera's movements.\n    ","name":"Cardinal Directions","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.CardinalDirectionSphere.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.CardinalDirectionSphere.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.CardinalDirectionSphere.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.CardinalDirectionSphere.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.CardinalDirectionSphere.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the fade in and out effects.","identifier":"DisableFadeInOut","name":"Disable Fade-In/Fade-Out effects","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.Renderable.DisableFadeInOut"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.CardinalDirectionSphere.Renderable.Fade"},{"description":"The distance from the center of the Milky Way at which the sphere should start to fade in, given as a percentage of the size of the object. A value of zero means that no fading in will happen.","identifier":"FadeInThreshold","name":"Fade-In Threshold","type":"FloatProperty","uri":"Scene.CardinalDirectionSphere.Renderable.FadeInThreshold"},{"description":"A threshold for when the sphere should start fading out, given as a percentage of how much of the sphere that is visible before the fading should start. A value of zero means that no fading out will happen.","identifier":"FadeOutThreshold","name":"Fade-Out Threshold","type":"FloatProperty","uri":"Scene.CardinalDirectionSphere.Renderable.FadeOutThreshold"},{"description":"If true, mirror the texture along the x-axis.","identifier":"MirrorTexture","name":"Mirror Texture","type":"BoolProperty","uri":"Scene.CardinalDirectionSphere.Renderable.MirrorTexture"},{"description":"The number of segments that the sphere is split into.","identifier":"Segments","name":"Number of Segments","type":"IntProperty","uri":"Scene.CardinalDirectionSphere.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.CardinalDirectionSphere.Renderable.Opacity"},{"description":"Specifies whether the texture is applied to the inside of the sphere, the outside of the sphere, or both.","identifier":"Orientation","name":"Orientation","type":"OptionProperty","uri":"Scene.CardinalDirectionSphere.Renderable.Orientation"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.CardinalDirectionSphere.Renderable.Type"},{"description":"The radius of the sphere in meters.","identifier":"Size","name":"Size (in meters)","type":"FloatProperty","uri":"Scene.CardinalDirectionSphere.Renderable.Size"},{"description":"The path to an image on disk to use as a texture for this sphere. The image is expected to be an equirectangular projection.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.CardinalDirectionSphere.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderableSphereImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.CardinalDirectionSphere.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.CardinalDirectionSphere.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.CardinalDirectionSphere.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"","name":"Cardinal Directions Position","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.CardinalDirectionsPosition.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.CardinalDirectionsPosition.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.CardinalDirectionsPosition.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.CardinalDirectionsPosition.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.CardinalDirectionsPosition.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Rotation","properties":[{"description":"A rotation angle that can be used to rotate the object around its own y-axis, which will be pointing out of the globe's surface.","identifier":"Angle","name":"Angle","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.Rotation.Angle"},{"description":"The globe on which the longitude/latitude is specified.","identifier":"Globe","name":"Attached Globe","type":"StringProperty","uri":"Scene.CardinalDirectionsPosition.Rotation.Globe"},{"description":"The latitude of the location on the globe's surface. The value can range from -90 to 90, with negative values representing the southern hemisphere of the globe. The default value is 0.0.","identifier":"Latitude","name":"Latitude","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.Rotation.Latitude"},{"description":"The longitude of the location on the globe's surface. The value can range from -180 to 180, with negative values representing the western hemisphere of the globe. The default value is 0.0.","identifier":"Longitude","name":"Longitude","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.Rotation.Longitude"},{"description":"If this value is 'true', the lat and lon are updated to match the camera.","identifier":"UseCamera","name":"Use Camera","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.Rotation.UseCamera"},{"description":"If set to true, the heightmap will be used when computing the surface normal. This means that the object will be rotated to lay flat on the surface at the given coordinate and follow the shape of the landscape.","identifier":"UseHeightmap","name":"Use Heightmap","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.Rotation.UseHeightmap"}],"propertyOwners":[],"tags":[],"type":"GlobeRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"The altitude in meters. If the 'UseHeightmap' property is 'true', this is an offset from the actual surface of the globe. If not, this is an offset from the reference ellipsoid. The default value is 0.0.","identifier":"Altitude","name":"Altitude","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.Translation.Altitude"},{"description":"The globe on which the longitude/latitude is specified.","identifier":"Globe","name":"Attached Globe","type":"StringProperty","uri":"Scene.CardinalDirectionsPosition.Translation.Globe"},{"description":"The latitude of the location on the globe's surface. The value can range from -90 to 90, with negative values representing the southern hemisphere of the globe. The default value is 0.0.","identifier":"Latitude","name":"Latitude","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.Translation.Latitude"},{"description":"The longitude of the location on the globe's surface. The value can range from -180 to 180, with negative values representing the western hemisphere of the globe. The default value is 0.0.","identifier":"Longitude","name":"Longitude","type":"DoubleProperty","uri":"Scene.CardinalDirectionsPosition.Translation.Longitude"},{"description":"If this value is 'true', the lat and lon are updated to match the camera.","identifier":"UseCamera","name":"Use Camera","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.Translation.UseCamera"},{"description":"If this value is 'true', the altitude is updated to match the camera.","identifier":"UseCameraAltitude","name":"Use Camera Altitude","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.Translation.UseCameraAltitude"},{"description":"If this value is 'true', the altitude specified in 'Altitude' will be treated as an offset from the heightmap. Otherwise, it will be an offset from the globe's reference ellipsoid. The default value is 'false'.","identifier":"UseHeightmap","name":"Use Heightmap","type":"BoolProperty","uri":"Scene.CardinalDirectionsPosition.Translation.UseHeightmap"}],"propertyOwners":[],"tags":[],"type":"GlobeTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Carina Image","name":"Carina Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Car.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Car.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Car.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Car.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Car.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Car.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Car.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Car.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Car.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Car.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Car.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Car.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Car.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Car.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Car.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Car.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Cassiopeia Image","name":"Cassiopeia Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cas.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cas.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cas.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cas.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cas.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cas.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cas.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cas.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cas.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cas.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cas.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cas.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cas.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cas.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cas.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cas.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Centaurus Image","name":"Centaurus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cen.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cen.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cen.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cen.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cen.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cen.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cen.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cen.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cen.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cen.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cen.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cen.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cen.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cen.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cen.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cen.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Cepheus Image","name":"Cepheus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cep.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cep.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cep.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cep.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cep.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cep.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cep.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cep.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cep.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cep.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cep.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cep.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cep.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cep.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cep.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cep.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Cetus Image","name":"Cetus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cet.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cet.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cet.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cet.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cet.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cet.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cet.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cet.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cet.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cet.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cet.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cet.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cet.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cet.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cet.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cet.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Chamaeleon Image","name":"Chamaeleon Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cha.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cha.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cha.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cha.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cha.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cha.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cha.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cha.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cha.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cha.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cha.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cha.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cha.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cha.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cha.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cha.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"","name":"Charon","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Charon.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Charon.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Charon.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Charon.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Charon.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Charon.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Charon.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Charon.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Charon.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Charon.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Charon.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Charon.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Charon.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Charon.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Charon.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Charon.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Charon.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Charon.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The intensity factor for the ambient light used for light shading.","identifier":"AmbientIntensity","name":"Ambient Intensity","type":"FloatProperty","uri":"Scene.Charon.Renderable.AmbientIntensity"},{"description":"The currently used scale factor whose target value is deteremined by 'TargetLodScaleFactor'.","identifier":"CurrentLodScaleFactor","name":"Current Level of Detail Scale Factor (Read Only)","type":"FloatProperty","uri":"Scene.Charon.Renderable.CurrentLodScaleFactor"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Charon.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Charon.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Charon.Renderable.Fade"},{"description":"The identifier of a scene graph node that should be used as the source of illumination for the globe. If not specified, the solar system's Sun is used.","identifier":"LightSourceNode","name":"Light Source","type":"StringProperty","uri":"Scene.Charon.Renderable.LightSourceNode"},{"description":"The number of currently active layers. If this value reaches the maximum, bad things will happen.","identifier":"NActiveLayers","name":"Number of active layers","type":"IntProperty","uri":"Scene.Charon.Renderable.NActiveLayers"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Charon.Renderable.Opacity"},{"description":"The roughness factor that is used for the Oren-Nayar lighting mode.","identifier":"OrenNayarRoughness","name":"orenNayarRoughness","type":"FloatProperty","uri":"Scene.Charon.Renderable.OrenNayarRoughness"},{"description":"Specifies whether the planet should be shaded by the primary light source or not. If disabled, all parts of the planet are illuminated. Note that if the globe has a corresponding atmosphere, there is a separate setting to control the shadowing induced by the atmosphere.","identifier":"PerformShading","name":"Perform shading","type":"BoolProperty","uri":"Scene.Charon.Renderable.PerformShading"},{"description":"Tells the rendering engine not to perform distance based performance culling for this globe. Turning this property on will let the globe to be seen at far away distances when normally it would be hidden.","identifier":"RenderAtDistance","name":"Render at Distance","type":"BoolProperty","uri":"Scene.Charon.Renderable.RenderAtDistance"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Charon.Renderable.Type"},{"description":"Determines the targeted level-of-detail of the tiles for this globe. A higher value means that the tiles rendered are a higher resolution for the same distance of the camera to the planet.","identifier":"TargetLodScaleFactor","name":"Target Level of Detail Scale Factor","type":"FloatProperty","uri":"Scene.Charon.Renderable.TargetLodScaleFactor"},{"description":"Determines whether higher-accuracy normals should be used in the rendering. These normals are calculated based on the height field information and are thus only available if the planet has a height map layer.","identifier":"UseAccurateNormals","name":"Use Accurate Normals","type":"BoolProperty","uri":"Scene.Charon.Renderable.UseAccurateNormals"}],"propertyOwners":[{"description":"","name":"Debug","properties":[{"description":"The number of checks that have to fail/succeed in a row before the dynamic level-of-detail adjusts the actual level-of-detail up or down during a session recording.","identifier":"DynamicLodIterationCount","name":"Data availability checks before LOD factor impact","type":"IntProperty","uri":"Scene.Charon.Renderable.Debug.DynamicLodIterationCount"},{"description":"If true, the tile level is determined by the area projected on screen. If false, the distance to the center of the tile is used instead.","identifier":"LevelByProjectedAreaElseDistance","name":"Level by projected area (else distance)","type":"BoolProperty","uri":"Scene.Charon.Renderable.Debug.LevelByProjectedAreaElseDistance"},{"description":"The tile level that is used as the cut off between rendering tiles using the globe model rendering vs the flat in-game rendering method. The value is a trade-off between not having precision errors in the rendering and representing a tile as flat or curved.","identifier":"ModelSpaceRenderingCutoffLevel","name":"Model Space Rendering Cutoff Level","type":"IntProperty","uri":"Scene.Charon.Renderable.Debug.ModelSpaceRenderingCutoffLevel"},{"description":"If this value is set to true, frustum culling will be performed.","identifier":"PerformFrustumCulling","name":"Perform frustum culling","type":"BoolProperty","uri":"Scene.Charon.Renderable.Debug.PerformFrustumCulling"},{"description":"Reset all tile provides for the globe and reload the data.","identifier":"ResetTileProviders","name":"Reset tile providers","type":"BoolProperty","uri":"Scene.Charon.Renderable.Debug.ResetTileProviders"},{"description":"Shows the borders between chunks in a red highlight.","identifier":"ShowChunkEdges","name":"Show chunk edges","type":"BoolProperty","uri":"Scene.Charon.Renderable.Debug.ShowChunkEdges"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"GeoJson","properties":[],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Labels","properties":[{"description":"Labels are aligned horizontally or circularly related to the planet.","identifier":"AlignmentOption","name":"Alignment Option","type":"OptionProperty","uri":"Scene.Charon.Renderable.Labels.AlignmentOption"},{"description":"The text color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.Charon.Renderable.Labels.Color"},{"description":"Labels culling disabled.","identifier":"DisableCulling","name":"Culling Disabled","type":"BoolProperty","uri":"Scene.Charon.Renderable.Labels.DisableCulling"},{"description":"Labels culling distance from globe's center.","identifier":"DistanceEPS","name":"Culling Distance","type":"FloatProperty","uri":"Scene.Charon.Renderable.Labels.DistanceEPS"},{"description":"Enables and disables labels' rendering.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Charon.Renderable.Labels.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Charon.Renderable.Labels.Fade"},{"description":"Sets whether the labels fade in when approaching the globe from a distance. If false, no fading happens and the labels immediately has full opacity.","identifier":"FadeInEnabled","name":"Fade In Enabled","type":"BoolProperty","uri":"Scene.Charon.Renderable.Labels.FadeInEnabled"},{"description":"Sets whether the labels fade out when approaching the surface of the globe. If false, no fading happens and the labels stays in full opacity.","identifier":"FadeOutEnabled","name":"Fade Out Enabled","type":"BoolProperty","uri":"Scene.Charon.Renderable.Labels.FadeOutEnabled"},{"description":"The distances above the globe's surface at which the labels start fading in or out, given in meters. The final distances are also adjusted by the specified height offset.","identifier":"FadeDistances","name":"Fade-In Distances","type":"Vec2Property","uri":"Scene.Charon.Renderable.Labels.FadeDistances"},{"description":"Font size for the rendering labels. This is different fromt text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.Charon.Renderable.Labels.FontSize"},{"description":"This value moves the label away from the globe surface by the specified distance (in meters).","identifier":"HeightOffset","name":"Height Offset","type":"FloatProperty","uri":"Scene.Charon.Renderable.Labels.HeightOffset"},{"description":"This value affects the size scale of the labels.","identifier":"LabelsSize","name":"Labels Size","type":"FloatProperty","uri":"Scene.Charon.Renderable.Labels.LabelsSize"},{"description":"Minimum and maximum label size, in pixels.","identifier":"MinMaxSize","name":"Min/Max Text Size","type":"IVec2Property","uri":"Scene.Charon.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Charon.Renderable.Labels.Opacity"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Layers","properties":[],"propertyOwners":[{"description":"","name":"Color Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.BlendTileLevels"}],"propertyOwners":[{"description":"","name":"Black & White [USGS]","properties":[{"description":"This value specifies the blend mode that is applied to this layer. The blend mode determines how this layer is added to the underlying layers beneath.","identifier":"BlendMode","name":"Blend Mode","type":"OptionProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.BlendMode"},{"description":"If this value is enabled, the layer will be used for the final composition of the planet. If this value is disabled, the layer will be ignored in the composition.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Fade"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Opacity"},{"description":"If this value is triggered, a script will be executed that will remove this layer before the next frame.","identifier":"Remove","name":"Remove","type":"TriggerProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Remove"},{"description":"If this value is triggered, this layer will be reset. This will delete the local cache for this layer and will trigger a fresh load of all tiles.","identifier":"Reset","name":"Reset","type":"TriggerProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Reset"},{"description":"The type of this Layer. This value is a read-only property and thus cannot be changed.","identifier":"Type","name":"Type","type":"OptionProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Type"}],"propertyOwners":[{"description":"","name":"Adjustment","properties":[{"description":"The type of layer adjustment that is applied to the underlying layer.","identifier":"Type","name":"Type","type":"OptionProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Adjustment.Type"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Settings","properties":[{"description":"This value is used as an exponent to adjust the color for each tile.","identifier":"Gamma","name":"Gamma","type":"FloatProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Settings.Gamma"},{"description":"This value is used as a multiplier to adjust the color applied after taking the gamma value as an exponent.","identifier":"Multiplier","name":"Multiplier","type":"FloatProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Settings.Multiplier"},{"description":"This value is used as an additive modifier to adjust the color applied after the gamma exponent and the multiplier has been performed.","identifier":"Offset","name":"Offset","type":"FloatProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Settings.Offset"},{"description":"If this value is triggered it will reset all of these values to their default values.","identifier":"SetDefault","name":"Set Default","type":"TriggerProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.Settings.SetDefault"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Tile Provider","properties":[{"description":"The path of the GDAL file or the image file that is to be used in this tile provider.","identifier":"FilePath","name":"File Path","type":"StringProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.TileProvider.FilePath"},{"description":"This value is the preferred size (in pixels) for each tile. Choosing the right value is a tradeoff between more efficiency (larger images) and better quality (smaller images). The tile pixel size has to be smaller than the size of the complete image if a single image is used.","identifier":"TilePixelSize","name":"Tile Pixel Size","type":"IntProperty","uri":"Scene.Charon.Renderable.Layers.ColorLayers.Greyscale_USGS.TileProvider.TilePixelSize"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"Height Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Charon.Renderable.Layers.HeightLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Night Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Charon.Renderable.Layers.NightLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Overlays","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Charon.Renderable.Layers.Overlays.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Water Masks","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Charon.Renderable.Layers.WaterMasks.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"ShadowMapping","properties":[{"description":"The number of samples used during shadow mapping calculation (Percentage Closer Filtering).","identifier":"NumberShadowSamples","name":"Number of Shadow Samples","type":"IntProperty","uri":"Scene.Charon.Renderable.ShadowMapping.NumberShadowSamples"},{"description":"Enables shadow mapping algorithm. Used by renderable rings, too.","identifier":"ShadowMapping","name":"Shadow Mapping","type":"BoolProperty","uri":"Scene.Charon.Renderable.ShadowMapping.ShadowMapping"},{"description":"The percentage of the correct distance to the surface being shadowed.","identifier":"ZFightingPercentage","name":"Z-Fighting Percentage","type":"FloatProperty","uri":"Scene.Charon.Renderable.ShadowMapping.ZFightingPercentage"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGlobe"},{"description":"","name":"Rotation","properties":[{"description":"This value specifies the destination frame that is used for the coordinate transformation. This has to be a valid SPICE name.","identifier":"DestinationFrame","name":"Destination","type":"StringProperty","uri":"Scene.Charon.Rotation.DestinationFrame"},{"description":"A time to lock the rotation to. Setting this to an empty string will unlock the time and return to rotation based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Charon.Rotation.FixedDate"},{"description":"This value specifies the source frame that is used as the basis for the coordinate transformation. This has to be a valid SPICE name.","identifier":"SourceFrame","name":"Source","type":"StringProperty","uri":"Scene.Charon.Rotation.SourceFrame"}],"propertyOwners":[],"tags":[],"type":"SpiceRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.Charon.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Charon.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.Charon.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.Charon.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.Charon.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":["moon_solarSystem","moon_dwarf","moon_pluto","moon_major","moon_major_pluto"],"type":"SceneGraphNode"},{"description":"","name":"Charon Barycentric Trail","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.CharonBarycentricTrail.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.CharonBarycentricTrail.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.CharonBarycentricTrail.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.CharonBarycentricTrail.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.CharonBarycentricTrail.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.CharonBarycentricTrail.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.CharonBarycentricTrail.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.CharonBarycentricTrail.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.CharonBarycentricTrail.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.CharonBarycentricTrail.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.CharonBarycentricTrail.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Fade"},{"description":"The number of samples along the orbit. This determines the resolution of the trail; the tradeoff being that a higher resolution is able to resolve more detail, but will take more resources while rendering, too. The higher, the smoother the trail, but also more memory will be used.","identifier":"Resolution","name":"Number of samples along the orbit","type":"IntProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Resolution"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Opacity"},{"description":"The objects period, i.e. the length of its orbit around the parent object given in (Earth) days. In the case of Earth, this would be a sidereal year (=365.242 days). If this values is specified as multiples of the period, it is possible to show the effects of precession.","identifier":"Period","name":"Period (in days)","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Period"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Type"}],"propertyOwners":[{"description":"The appearance of the trail","name":"Appearance","properties":[{"description":"This value determines the RGB main color for the lines and points of the trail.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.CharonBarycentricTrail.Renderable.Appearance.Color"},{"description":"Toggles whether the trail should fade older points out. If this value is true, the 'Fade' parameter determines the speed of fading. If this value is false, the entire trail is rendered at full opacity and color.","identifier":"EnableFade","name":"Enable line fading of old points","type":"BoolProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Appearance.EnableFade"},{"description":"The amount of the trail that should be faded. If the value is 0 then the trail will have no fading applied. A value of 0.6 will result in a trail where 60% of the extent of the trail will have fading applied to it. In otherwords, the 40% closest to the head of the trail will be solid and the rest will fade until completely transparent at the end of the trail. A value of 1 will result in a trail that starts fading immediately, becoming fully transparent by the end of the trail. This setting only applies if the 'EnableFade' value is true. If it is false, this setting has no effect.","identifier":"LineFadeAmount","name":"Line Fade Amount","type":"FloatProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Appearance.LineFadeAmount"},{"description":"The extent of the rendered trail. A value of 0 will result in no trail and a value of 1 will result in a trail that covers the entire extent. The setting only applies if 'EnableFade' is true. If it is false, this setting has no effect.","identifier":"LineLength","name":"Line Length","type":"FloatProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Appearance.LineLength"},{"description":"Specifies the line width of the trail lines, if the selected rendering method includes lines. If the rendering mode is Points, this value is ignored.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Appearance.LineWidth"},{"description":"Specifies the base size of the points along the line, if the selected rendering method includes points. If the rendering mode is Lines, this value is ignored. If a subsampling of the values is performed, the subsampled values are half this size.","identifier":"PointSize","name":"Point Size","type":"IntProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Appearance.PointSize"},{"description":"Determines how the trail should be rendered. If 'Lines' is selected, only the line part is visible, if 'Points' is selected, only the corresponding points (and subpoints) are shown. 'Lines+Points' shows both parts.","identifier":"Rendering","name":"Rendering Mode","type":"OptionProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Appearance.Rendering"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.CharonBarycentricTrail.Renderable.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":[],"type":"RenderableTrailOrbit"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.CharonBarycentricTrail.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.CharonBarycentricTrail.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.CharonBarycentricTrail.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["moonTrail_solarSystem","moonTrail_dwarf","moonTrail_pluto","moonTrail_major","moonTrail_major_pluto"],"type":"SceneGraphNode"},{"description":"Label for Pluto's moon Charon","name":"Charon Label","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.CharonLabel.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.CharonLabel.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.CharonLabel.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.CharonLabel.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.CharonLabel.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.CharonLabel.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.CharonLabel.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.CharonLabel.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.CharonLabel.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.CharonLabel.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.CharonLabel.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.CharonLabel.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.CharonLabel.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.CharonLabel.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.CharonLabel.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.CharonLabel.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.CharonLabel.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.CharonLabel.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"This determines the blending mode that is applied to the renderable.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.CharonLabel.Renderable.BlendMode"},{"description":"The label text color.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.CharonLabel.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.CharonLabel.Renderable.DimInAtmosphere"},{"description":"Enable/Disable the Fade-in effect.","identifier":"EnableFading","name":"Enable/Disable Fade-in Effect","type":"BoolProperty","uri":"Scene.CharonLabel.Renderable.EnableFading"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.CharonLabel.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.CharonLabel.Renderable.Fade"},{"description":"Distance unit for fade-in/-out distance calculations. Defaults to \"au\".","identifier":"FadeUnit","name":"Fade Distance Unit","type":"OptionProperty","uri":"Scene.CharonLabel.Renderable.FadeUnit"},{"description":"The distance range in which the labels should be fully opaque, specified in the chosen unit. The distance from the position of the label to the camera.","identifier":"FadeDistances","name":"Fade Distances","type":"Vec2Property","uri":"Scene.CharonLabel.Renderable.FadeDistances"},{"description":"The distances over which the fading takes place, given in the specified unit. The first value is the distance before the closest distance and the second the one after the furthest distance. For example, with the unit Parsec (pc), a value of {1, 2} will make the label being fully faded out 1 Parsec before the closest distance and 2 Parsec away from the furthest distance.","identifier":"FadeWidths","name":"Fade Widths","type":"Vec2Property","uri":"Scene.CharonLabel.Renderable.FadeWidths"},{"description":"The font size (in points) for the label.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.CharonLabel.Renderable.FontSize"},{"description":"The minimum and maximum size (in pixels) of the label.","identifier":"MinMaxSize","name":"Min and Max Size","type":"IVec2Property","uri":"Scene.CharonLabel.Renderable.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.CharonLabel.Renderable.Opacity"},{"description":"Label orientation rendering mode.","identifier":"OrientationOption","name":"Orientation Option","type":"OptionProperty","uri":"Scene.CharonLabel.Renderable.OrientationOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.CharonLabel.Renderable.Type"},{"description":"Scales the size of the label, exponentially. The value is used as the exponent in a 10^x computation to scale the label size.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.CharonLabel.Renderable.Size"},{"description":"The text that will be displayed on screen.","identifier":"Text","name":"Text","type":"StringProperty","uri":"Scene.CharonLabel.Renderable.Text"}],"propertyOwners":[],"tags":[],"type":"RenderableLabel"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.CharonLabel.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.CharonLabel.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.CharonLabel.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["solarsystem_labels","moon_labels","major_moon_labels"],"type":"SceneGraphNode"},{"description":"Circinus Image","name":"Circinus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cir.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cir.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cir.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cir.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cir.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cir.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cir.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cir.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cir.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cir.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cir.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cir.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cir.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cir.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cir.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cir.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Columba Image","name":"Columba Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Col.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Col.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Col.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Col.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Col.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Col.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Col.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Col.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Col.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Col.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Col.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Col.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Col.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Col.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Col.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Col.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Coma Berenices Image","name":"Coma Berenices Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Com.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Com.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Com.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Com.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Com.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Com.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Com.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Com.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Com.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Com.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Com.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Com.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Com.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Com.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Com.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Com.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"A Spherical mesh dividing the sky into regions that fit the\n      constellations","name":"Constellation Bounds","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ConstellationBounds.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ConstellationBounds.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ConstellationBounds.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ConstellationBounds.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ConstellationBounds.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ConstellationBounds.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ConstellationBounds.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ConstellationBounds.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ConstellationBounds.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ConstellationBounds.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ConstellationBounds.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ConstellationBounds.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ConstellationBounds.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ConstellationBounds.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ConstellationBounds.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ConstellationBounds.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ConstellationBounds.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ConstellationBounds.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The color of the lines.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.ConstellationBounds.Renderable.Color"},{"description":"Specifies the file that contains the mapping between constellation abbreviations and full names of the constellations. If this value is empty, the abbreviations are used as the full names.","identifier":"NamesFile","name":"Constellation Names File Path","type":"StringProperty","uri":"Scene.ConstellationBounds.Renderable.NamesFile"},{"description":"The constellations that are selected are displayed on the celestial sphere.","identifier":"ConstellationSelection","name":"Constellation Selection","type":"SelectionProperty","uri":"Scene.ConstellationBounds.Renderable.ConstellationSelection"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ConstellationBounds.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ConstellationBounds.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ConstellationBounds.Renderable.Fade"},{"description":"The line width of the constellation.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.ConstellationBounds.Renderable.LineWidth"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ConstellationBounds.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ConstellationBounds.Renderable.Type"},{"description":"A file that contains the vertex locations of the constellations bounds.","identifier":"File","name":"Vertex File Path","type":"StringProperty","uri":"Scene.ConstellationBounds.Renderable.File"}],"propertyOwners":[],"tags":[],"type":"RenderableConstellationBounds"},{"description":"","name":"Rotation","properties":[{"description":"This value specifies the destination frame that is used for the coordinate transformation. This has to be a valid SPICE name.","identifier":"DestinationFrame","name":"Destination","type":"StringProperty","uri":"Scene.ConstellationBounds.Rotation.DestinationFrame"},{"description":"A time to lock the rotation to. Setting this to an empty string will unlock the time and return to rotation based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.ConstellationBounds.Rotation.FixedDate"},{"description":"This value specifies the source frame that is used as the basis for the coordinate transformation. This has to be a valid SPICE name.","identifier":"SourceFrame","name":"Source","type":"StringProperty","uri":"Scene.ConstellationBounds.Rotation.SourceFrame"}],"propertyOwners":[],"tags":[],"type":"SpiceRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ConstellationBounds.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ConstellationBounds.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Census 88 constellations and labels. DU Version 3.4. <br> These\n      modern constellations are largely based on those of the Babylonians and\n      Greeks; however, most cultures have their own figures and stories of the sky.\n      More than half the official constellations adopted by scientists in 1930 were\n      known to the ancients over 2,000 years ago. Each star falls into one of these\n      88 regions. Of course, today we know the stars in any given constellation do\n      not necessarily have any physical relationship with one another. One star may\n      be nearby, while an adjacent star in the sky may be far away.(Description\n      from URL) <br><br> Data Reference: various","name":"Constellations","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Constellations.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Constellations.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Constellations.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Constellations.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Constellations.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Constellations.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Constellations.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Constellations.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Constellations.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Constellations.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Constellations.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Constellations.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Constellations.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Constellations.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Constellations.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Constellations.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Constellations.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Constellations.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The path to a SPECK file that contains the data for the constellation lines.","identifier":"File","name":"Constellation Data File Path","type":"StringProperty","uri":"Scene.Constellations.Renderable.File"},{"description":"Specifies the file that contains the mapping between constellation abbreviations and full names of the constellations. If this value is empty, the abbreviations are used as the full names.","identifier":"NamesFile","name":"Constellation Names File Path","type":"StringProperty","uri":"Scene.Constellations.Renderable.NamesFile"},{"description":"The constellations that are selected are displayed on the celestial sphere.","identifier":"ConstellationSelection","name":"Constellation Selection","type":"SelectionProperty","uri":"Scene.Constellations.Renderable.ConstellationSelection"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Constellations.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the constellations.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.Constellations.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Constellations.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Constellations.Renderable.Fade"},{"description":"The line width of the constellation.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.Constellations.Renderable.LineWidth"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Constellations.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Constellations.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.Constellations.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Constellations.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.Constellations.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Constellations.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.Constellations.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.Constellations.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Constellations.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.Constellations.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableConstellationLines"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.Constellations.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.Constellations.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.Constellations.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["daytime_hidden"],"type":"SceneGraphNode"},{"description":"","name":"Constellations (Extragalactic)","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ConstellationsExtragalactic.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ConstellationsExtragalactic.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ConstellationsExtragalactic.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ConstellationsExtragalactic.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ConstellationsExtragalactic.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The path to a SPECK file that contains the data for the constellation lines.","identifier":"File","name":"Constellation Data File Path","type":"StringProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.File"},{"description":"Specifies the file that contains the mapping between constellation abbreviations and full names of the constellations. If this value is empty, the abbreviations are used as the full names.","identifier":"NamesFile","name":"Constellation Names File Path","type":"StringProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.NamesFile"},{"description":"The constellations that are selected are displayed on the celestial sphere.","identifier":"ConstellationSelection","name":"Constellation Selection","type":"SelectionProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.ConstellationSelection"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the constellations.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Fade"},{"description":"The line width of the constellation.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.LineWidth"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Type"}],"propertyOwners":[{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.ConstellationsExtragalactic.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.ConstellationsExtragalactic.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.ConstellationsExtragalactic.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableConstellationLines"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ConstellationsExtragalactic.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ConstellationsExtragalactic.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ConstellationsExtragalactic.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Corona Australis Image","name":"Corona Australis Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-CrA.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-CrA.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-CrA.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-CrA.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-CrA.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-CrA.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-CrA.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-CrA.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-CrA.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-CrA.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-CrA.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-CrA.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-CrA.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-CrA.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrA.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-CrA.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Corona Borealis Image","name":"Corona Borealis Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-CrB.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-CrB.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-CrB.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-CrB.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-CrB.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-CrB.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-CrB.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-CrB.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-CrB.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-CrB.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-CrB.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-CrB.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-CrB.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-CrB.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-CrB.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-CrB.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Corvus Image","name":"Corvus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Crv.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Crv.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Crv.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Crv.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Crv.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Crv.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Crv.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Crv.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Crv.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Crv.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Crv.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Crv.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Crv.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Crv.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crv.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Crv.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"","name":"Cosmic Background Explorer","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.CBE.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.CBE.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.CBE.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.CBE.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.CBE.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.CBE.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.CBE.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.CBE.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.CBE.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.CBE.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.CBE.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.CBE.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.CBE.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.CBE.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.CBE.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.CBE.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.CBE.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.CBE.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.CBE.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the fade in and out effects.","identifier":"DisableFadeInOut","name":"Disable Fade-In/Fade-Out effects","type":"BoolProperty","uri":"Scene.CBE.Renderable.DisableFadeInOut"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.CBE.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.CBE.Renderable.Fade"},{"description":"The distance from the center of the Milky Way at which the sphere should start to fade in, given as a percentage of the size of the object. A value of zero means that no fading in will happen.","identifier":"FadeInThreshold","name":"Fade-In Threshold","type":"FloatProperty","uri":"Scene.CBE.Renderable.FadeInThreshold"},{"description":"A threshold for when the sphere should start fading out, given as a percentage of how much of the sphere that is visible before the fading should start. A value of zero means that no fading out will happen.","identifier":"FadeOutThreshold","name":"Fade-Out Threshold","type":"FloatProperty","uri":"Scene.CBE.Renderable.FadeOutThreshold"},{"description":"If true, mirror the texture along the x-axis.","identifier":"MirrorTexture","name":"Mirror Texture","type":"BoolProperty","uri":"Scene.CBE.Renderable.MirrorTexture"},{"description":"The number of segments that the sphere is split into.","identifier":"Segments","name":"Number of Segments","type":"IntProperty","uri":"Scene.CBE.Renderable.Segments"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.CBE.Renderable.Opacity"},{"description":"Specifies whether the texture is applied to the inside of the sphere, the outside of the sphere, or both.","identifier":"Orientation","name":"Orientation","type":"OptionProperty","uri":"Scene.CBE.Renderable.Orientation"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.CBE.Renderable.Type"},{"description":"The radius of the sphere in meters.","identifier":"Size","name":"Size (in meters)","type":"FloatProperty","uri":"Scene.CBE.Renderable.Size"},{"description":"The path to an image on disk to use as a texture for this sphere. The image is expected to be an equirectangular projection.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.CBE.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderableSphereImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.CBE.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.CBE.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.CBE.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Crater Image","name":"Crater Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Crt.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Crt.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Crt.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Crt.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Crt.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Crt.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Crt.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Crt.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Crt.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Crt.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Crt.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Crt.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Crt.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Crt.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Crt.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Crt.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Crux Image","name":"Crux Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cru.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cru.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cru.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cru.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cru.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cru.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cru.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cru.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cru.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cru.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cru.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cru.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cru.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cru.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cru.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cru.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Cygnus Image","name":"Cygnus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Cyg.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Cyg.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Cyg.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Cyg.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Cyg.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Cyg.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Cyg.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Cyg.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Cyg.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Cyg.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Cyg.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Census: 63 images and labels. DU Version 1.3. <br> These data are\n      2-D images of Messier objects placed in 3-D space. Not only do we place these\n      images at the proper location and give them the correct orientation, we also\n      size them accurately so that you can fly to the globular cluster M13, for\n      example, and see just how small the cluster of hundreds of thousands of stars\n      is relative to the rest of the Galaxy. Included Messier Objects by number are:\n      6, 7, 11, 16, 18, 21, 23-26, 29, 34-39, 41, 46-48, 50, 52, 67, 93, 103, 2-5,\n      9, 10, 12-15, 19, 22, 28, 30, 53-56, 68-72, 75, 79, 80, 92, 107, 27, 57, 76,\n      97, 8, 17, 20, 78, 1 (Description from URL) <br><br> Data Reference: Largely\n      NOAO and various other sources (each image has a ref)","name":"Deep Sky Objects Images","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.DeepSkyObjectsImages.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.DeepSkyObjectsImages.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.DeepSkyObjectsImages.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.DeepSkyObjectsImages.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.DeepSkyObjectsImages.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the points.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Fade"},{"description":"Set to true if orientation data was read from the dataset.","identifier":"HasOrientationData","name":"Has Orientation Data","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.HasOrientationData"},{"description":"Information about how many points are being rendered.","identifier":"NumberOfDataPoints","name":"Number of Shown Data Points","type":"UIntProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.NumberOfDataPoints"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Opacity"},{"description":"Controls how the planes for the points will be oriented. \"Camera View Direction\" rotates the points so that the plane is orthogonal to the viewing direction of the camera (useful for planar displays), and \"Camera Position Normal\" rotates the points towards the position of the camera (useful for spherical displays, like dome theaters). In both these cases the points will be billboarded towards the camera. In contrast, \"Fixed Rotation\" does not rotate the points at all based on the camera and should be used when the dataset contains orientation information for the points.","identifier":"OrientationRenderOption","name":"Orientation Render Option","type":"OptionProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.OrientationRenderOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Type"},{"description":"If true (default), the color of points rendered on top of each other is blended additively, resulting in a brighter color where points overlap. If false, no such blending will take place and the color of the point will not be modified by blending. Note that this may lead to weird behaviors when the points are rendered with transparency.","identifier":"UseAdditiveBlending","name":"Use Additive Blending","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.UseAdditiveBlending"},{"description":"If true, the orientation data in the dataset is included when rendering the points, if there is any. To see the rotation, you also need to set the \"Orientation Render Option\" to \"Fixed Rotation\".","identifier":"UseOrientationData","name":"Use Orientation Data","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.UseOrientationData"}],"propertyOwners":[{"description":"","name":"Coloring","properties":[{"description":"If true and the outline is enabled, the color map will be applied to the outline rather than the point body. Only works if color mapping is enabled.","identifier":"ApplyColorMapToOutline","name":"Apply Color Map to Outline","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Coloring.ApplyColorMapToOutline"},{"description":"Determines whether each point should have an outline or not.","identifier":"EnableOutline","name":"Enable Point Outline","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Coloring.EnableOutline"},{"description":"The color of the points, when no color map is used.","identifier":"FixedColor","name":"Fixed Color","type":"Vec3Property","uri":"Scene.DeepSkyObjectsImages.Renderable.Coloring.FixedColor"},{"description":"The color of the outline. Darker colors will be less visible if \"Additive Blending\" is enabled.","identifier":"OutlineColor","name":"Outline Color","type":"Vec3Property","uri":"Scene.DeepSkyObjectsImages.Renderable.Coloring.OutlineColor"},{"description":"Decides the style of the outline (round, square, or a line at the bottom). The style also affects the shape of the points.","identifier":"OutlineStyle","name":"Outline Style","type":"OptionProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Coloring.OutlineStyle"},{"description":"The thickness of the outline, given as a value relative to the size of the point. A value of 0 will not show any outline, while a value of 1 will cover the whole point.","identifier":"OutlineWidth","name":"Outline Width","type":"FloatProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Coloring.OutlineWidth"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Sizing","properties":[{"description":"If true, the Max Size property will be used as an upper limit for the size of the point. This reduces the size of the points when approaching them, so that they stick to a maximum visual size depending on the Max Size value.","identifier":"EnableMaxSizeControl","name":"Enable Max Size Control","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Sizing.EnableMaxSizeControl"},{"description":"Controls the maximum allowed size for the points, when the max size control feature is enabled. This limits the visual size of the points based on the distance to the camera. The larger the value, the larger the points may be. In the background, the computations are made by limiting the size to a certain angle based on the field of view of the camera. So a value of 1 limits the point size to take up a maximum of one degree of the view space.","identifier":"MaxSize","name":"Max Size","type":"FloatProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Sizing.MaxSize"},{"description":"An exponential scale value used to set the absolute size of the point. In general, the larger distance the dataset covers, the larger this value should be. If not included, it is computed based on the maximum positional component of the data points. This is useful for showing the dataset at all, but you will likely want to change it to something that looks good. Note that a scale exponent of 0 leads to the points having a diameter of 1 meter, i.e. no exponential scaling.","identifier":"ScaleExponent","name":"Scale Exponent","type":"FloatProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Sizing.ScaleExponent"},{"description":"A multiplicative factor used to adjust the size of the points, after the exponential scaling and any max size control effects. Simply just increases or decreases the visual size of the points.","identifier":"ScaleFactor","name":"Scale Factor","type":"FloatProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Sizing.ScaleFactor"}],"propertyOwners":[{"description":"","name":"Size Mapping","properties":[{"description":"This value determines which parameter is used for scaling of the point. The parameter value will be used as a multiplicative factor to scale the size of the points. Note that they may however still be scaled by max size adjustment effects.","identifier":"Parameter","name":"Parameter Option","type":"OptionProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Sizing.SizeMapping.Parameter"},{"description":"This value is a multiplicative factor that is applied to the data values that are used to scale the points, when size mapping is applied.","identifier":"ScaleFactor","name":"Scale Factor","type":"FloatProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Sizing.SizeMapping.ScaleFactor"},{"description":"If true, the size value in the data is interpreted as the radius of the points. Otherwise, it is interpreted as the diameter.","identifier":"IsRadius","name":"Size is Radius","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Sizing.SizeMapping.IsRadius"},{"description":"If this value is set to 'true' and at least one column was loaded as an option for size mapping, the chosen data column will be used to scale the size of the points. The first option in the list is selected per default.","identifier":"Enabled","name":"Size Mapping Enabled","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Sizing.SizeMapping.Enabled"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"Texture","properties":[{"description":"If true, the textures will be compressed to preserve graphics card memory. This is enabled per default, but may lead to visible artefacts for certain images, especially up close. Set this to false to disable any hardware compression of the textures, and represent each color channel with 8 bits.","identifier":"AllowCompression","name":"Allow Compression","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Texture.AllowCompression"},{"description":"If true, use a provided sprite texture to render the point. If false, draw the points using the default point shape.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Texture.Enabled"},{"description":"This tells which texture mode is being used for this renderable. There are three different texture modes: 1) One single sprite texture used for all points, 2) Multiple textures, that are mapped to the points based on a column in the dataset, and 3) Other, which is used for specific subtypes where the texture is internally controlled by the renderable and can't be set from a file (such as the RenderablePolygonCloud).","identifier":"TextureMode","name":"Texture Mode","type":"StringProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Texture.TextureMode"},{"description":"If true, include transparency information in the loaded textures, if there is any. If false, all loaded textures will be converted to RGB format. \nThis setting can be used if you have textures with transparency, but do not need the transparency information. This may be the case when using additive blending, for example. Converting the files to RGB on load may then reduce the memory footprint and/or lead to some optimization in terms of rendering speed.","identifier":"UseAlphaChannel","name":"Use Alpha Channel","type":"BoolProperty","uri":"Scene.DeepSkyObjectsImages.Renderable.Texture.UseAlphaChannel"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderablePointCloud"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.DeepSkyObjectsImages.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.DeepSkyObjectsImages.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.DeepSkyObjectsImages.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"Point cloud and labels for Deep Sky Objects","name":"Deep Sky Objects Points","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.DeepSkyObjects.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.DeepSkyObjects.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.DeepSkyObjects.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.DeepSkyObjects.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.DeepSkyObjects.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.DeepSkyObjects.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.DeepSkyObjects.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.DeepSkyObjects.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.DeepSkyObjects.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.DeepSkyObjects.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.DimInAtmosphere"},{"description":"Enables/Disables the drawing of the points.","identifier":"DrawElements","name":"Draw Elements","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.DrawElements"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Fade"},{"description":"Set to true if orientation data was read from the dataset.","identifier":"HasOrientationData","name":"Has Orientation Data","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.HasOrientationData"},{"description":"Information about how many points are being rendered.","identifier":"NumberOfDataPoints","name":"Number of Shown Data Points","type":"UIntProperty","uri":"Scene.DeepSkyObjects.Renderable.NumberOfDataPoints"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Opacity"},{"description":"Controls how the planes for the points will be oriented. \"Camera View Direction\" rotates the points so that the plane is orthogonal to the viewing direction of the camera (useful for planar displays), and \"Camera Position Normal\" rotates the points towards the position of the camera (useful for spherical displays, like dome theaters). In both these cases the points will be billboarded towards the camera. In contrast, \"Fixed Rotation\" does not rotate the points at all based on the camera and should be used when the dataset contains orientation information for the points.","identifier":"OrientationRenderOption","name":"Orientation Render Option","type":"OptionProperty","uri":"Scene.DeepSkyObjects.Renderable.OrientationRenderOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.DeepSkyObjects.Renderable.Type"},{"description":"If true (default), the color of points rendered on top of each other is blended additively, resulting in a brighter color where points overlap. If false, no such blending will take place and the color of the point will not be modified by blending. Note that this may lead to weird behaviors when the points are rendered with transparency.","identifier":"UseAdditiveBlending","name":"Use Additive Blending","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.UseAdditiveBlending"},{"description":"If true, the orientation data in the dataset is included when rendering the points, if there is any. To see the rotation, you also need to set the \"Orientation Render Option\" to \"Fixed Rotation\".","identifier":"UseOrientationData","name":"Use Orientation Data","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.UseOrientationData"}],"propertyOwners":[{"description":"","name":"Coloring","properties":[{"description":"If true and the outline is enabled, the color map will be applied to the outline rather than the point body. Only works if color mapping is enabled.","identifier":"ApplyColorMapToOutline","name":"Apply Color Map to Outline","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Coloring.ApplyColorMapToOutline"},{"description":"Determines whether each point should have an outline or not.","identifier":"EnableOutline","name":"Enable Point Outline","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Coloring.EnableOutline"},{"description":"The color of the points, when no color map is used.","identifier":"FixedColor","name":"Fixed Color","type":"Vec3Property","uri":"Scene.DeepSkyObjects.Renderable.Coloring.FixedColor"},{"description":"The color of the outline. Darker colors will be less visible if \"Additive Blending\" is enabled.","identifier":"OutlineColor","name":"Outline Color","type":"Vec3Property","uri":"Scene.DeepSkyObjects.Renderable.Coloring.OutlineColor"},{"description":"Decides the style of the outline (round, square, or a line at the bottom). The style also affects the shape of the points.","identifier":"OutlineStyle","name":"Outline Style","type":"OptionProperty","uri":"Scene.DeepSkyObjects.Renderable.Coloring.OutlineStyle"},{"description":"The thickness of the outline, given as a value relative to the size of the point. A value of 0 will not show any outline, while a value of 1 will cover the whole point.","identifier":"OutlineWidth","name":"Outline Width","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Coloring.OutlineWidth"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Labels","properties":[{"description":"The color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.DeepSkyObjects.Renderable.Labels.Color"},{"description":"This setting determines whether the labels will be visible or not. They are disabled per default.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Labels.Enabled"},{"description":"If enabled, the labels will be rotated to face the camera. For non-linear display rendering (for example fisheye) this should be set to false.","identifier":"FaceCamera","name":"Face Camera","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Labels.FaceCamera"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Labels.Fade"},{"description":"Font size for the labels. This is different from the text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Labels.FontSize"},{"description":"The minimum and maximum size (in pixels) of the labels.","identifier":"MinMaxSize","name":"Min/Max Size","type":"IVec2Property","uri":"Scene.DeepSkyObjects.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Labels.Opacity"},{"description":"The size of the labels in pixels.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Labels.Size"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Sizing","properties":[{"description":"If true, the Max Size property will be used as an upper limit for the size of the point. This reduces the size of the points when approaching them, so that they stick to a maximum visual size depending on the Max Size value.","identifier":"EnableMaxSizeControl","name":"Enable Max Size Control","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Sizing.EnableMaxSizeControl"},{"description":"Controls the maximum allowed size for the points, when the max size control feature is enabled. This limits the visual size of the points based on the distance to the camera. The larger the value, the larger the points may be. In the background, the computations are made by limiting the size to a certain angle based on the field of view of the camera. So a value of 1 limits the point size to take up a maximum of one degree of the view space.","identifier":"MaxSize","name":"Max Size","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Sizing.MaxSize"},{"description":"An exponential scale value used to set the absolute size of the point. In general, the larger distance the dataset covers, the larger this value should be. If not included, it is computed based on the maximum positional component of the data points. This is useful for showing the dataset at all, but you will likely want to change it to something that looks good. Note that a scale exponent of 0 leads to the points having a diameter of 1 meter, i.e. no exponential scaling.","identifier":"ScaleExponent","name":"Scale Exponent","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Sizing.ScaleExponent"},{"description":"A multiplicative factor used to adjust the size of the points, after the exponential scaling and any max size control effects. Simply just increases or decreases the visual size of the points.","identifier":"ScaleFactor","name":"Scale Factor","type":"FloatProperty","uri":"Scene.DeepSkyObjects.Renderable.Sizing.ScaleFactor"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Texture","properties":[{"description":"If true, the textures will be compressed to preserve graphics card memory. This is enabled per default, but may lead to visible artefacts for certain images, especially up close. Set this to false to disable any hardware compression of the textures, and represent each color channel with 8 bits.","identifier":"AllowCompression","name":"Allow Compression","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Texture.AllowCompression"},{"description":"If true, use a provided sprite texture to render the point. If false, draw the points using the default point shape.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Texture.Enabled"},{"description":"The path to the texture of the point sprite. Note that if multiple textures option is set in the asset, by providing a texture folder, this value will be ignored.","identifier":"File","name":"Point Sprite Texture File","type":"StringProperty","uri":"Scene.DeepSkyObjects.Renderable.Texture.File"},{"description":"This tells which texture mode is being used for this renderable. There are three different texture modes: 1) One single sprite texture used for all points, 2) Multiple textures, that are mapped to the points based on a column in the dataset, and 3) Other, which is used for specific subtypes where the texture is internally controlled by the renderable and can't be set from a file (such as the RenderablePolygonCloud).","identifier":"TextureMode","name":"Texture Mode","type":"StringProperty","uri":"Scene.DeepSkyObjects.Renderable.Texture.TextureMode"},{"description":"If true, include transparency information in the loaded textures, if there is any. If false, all loaded textures will be converted to RGB format. \nThis setting can be used if you have textures with transparency, but do not need the transparency information. This may be the case when using additive blending, for example. Converting the files to RGB on load may then reduce the memory footprint and/or lead to some optimization in terms of rendering speed.","identifier":"UseAlphaChannel","name":"Use Alpha Channel","type":"BoolProperty","uri":"Scene.DeepSkyObjects.Renderable.Texture.UseAlphaChannel"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderablePointCloud"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.DeepSkyObjects.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.DeepSkyObjects.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.DeepSkyObjects.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":[],"type":"SceneGraphNode"},{"description":"One of two moons of Mars","name":"Deimos","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Deimos.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Deimos.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Deimos.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Deimos.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Deimos.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Deimos.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Deimos.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Deimos.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Deimos.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Deimos.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Deimos.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Deimos.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Deimos.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Deimos.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Deimos.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Deimos.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Deimos.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Deimos.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"A multiplier for ambient lighting.","identifier":"AmbientIntensity","name":"Ambient Intensity","type":"FloatProperty","uri":"Scene.Deimos.Renderable.AmbientIntensity"},{"description":"Controls the blending function used to calculate the colors of the model with respect to the opacity.","identifier":"BlendingOption","name":"Blending Options","type":"OptionProperty","uri":"Scene.Deimos.Renderable.BlendingOption"},{"description":"A multiplier for diffuse lighting.","identifier":"DiffuseIntensity","name":"Diffuse Intensity","type":"FloatProperty","uri":"Scene.Deimos.Renderable.DiffuseIntensity"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Deimos.Renderable.DimInAtmosphere"},{"description":"Enable or disable the animation for the model if it has any.","identifier":"EnableAnimation","name":"Enable Animation","type":"BoolProperty","uri":"Scene.Deimos.Renderable.EnableAnimation"},{"description":"If true, depth testing is enabled for the model. This means that parts of the model that are occluded by other parts will not be rendered. If disabled, the depth of the model part will not be taken into account in rendering and some parts that should be hidden behind a model might be rendered in front.","identifier":"EnableDepthTest","name":"Enable Depth Test","type":"BoolProperty","uri":"Scene.Deimos.Renderable.EnableDepthTest"},{"description":"Enable OpenGL automatic face culling optimization.","identifier":"EnableFaceCulling","name":"Enable Face Culling","type":"BoolProperty","uri":"Scene.Deimos.Renderable.EnableFaceCulling"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Deimos.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Deimos.Renderable.Fade"},{"description":"The scale of the model. If a numeric value is provided in the asset file, the scale will be that exact value. If instead a unit name is provided, this is the value that that name represents. For example 'Centimeter' becomes 0.01.","identifier":"ModelScale","name":"Model Scale","type":"DoubleProperty","uri":"Scene.Deimos.Renderable.ModelScale"},{"description":"An extra model transform matrix that is applied to the model before all other transformations are applied.","identifier":"ModelTransform","name":"Model Transform","type":"DMat4Property","uri":"Scene.Deimos.Renderable.ModelTransform"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Deimos.Renderable.Opacity"},{"description":"Determines whether shading should be applied to this model, based on the provided list of light sources. If false, the model will be fully illuminated.","identifier":"PerformShading","name":"Perform Shading","type":"BoolProperty","uri":"Scene.Deimos.Renderable.PerformShading"},{"description":"A vector that moves the place of origin for the model.","identifier":"Pivot","name":"Pivot","type":"Vec3Property","uri":"Scene.Deimos.Renderable.Pivot"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Deimos.Renderable.Type"},{"description":"A rotation vector with Euler angles, specified in degrees.","identifier":"RotationVector","name":"Rotation Vector","type":"Vec3Property","uri":"Scene.Deimos.Renderable.RotationVector"},{"description":"A multiplier for specular lighting.","identifier":"SpecularIntensity","name":"Specular Intensity","type":"FloatProperty","uri":"Scene.Deimos.Renderable.SpecularIntensity"}],"propertyOwners":[{"description":"","name":"Light Sources","properties":[],"propertyOwners":[{"description":"","name":"Light Source","properties":[{"description":"Whether the light source is enabled or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Deimos.Renderable.LightSources.Sun.Enabled"},{"description":"The intensity of this light source.","identifier":"Intensity","name":"Intensity","type":"FloatProperty","uri":"Scene.Deimos.Renderable.LightSources.Sun.Intensity"},{"description":"The identifier of the scene graph node to follow.","identifier":"Node","name":"Node","type":"StringProperty","uri":"Scene.Deimos.Renderable.LightSources.Sun.Node"}],"propertyOwners":[],"tags":[],"type":"SceneGraphLightSource"}],"tags":[],"type":""}],"tags":[],"type":"RenderableModel"},{"description":"","name":"Rotation","properties":[{"description":"This value specifies the destination frame that is used for the coordinate transformation. This has to be a valid SPICE name.","identifier":"DestinationFrame","name":"Destination","type":"StringProperty","uri":"Scene.Deimos.Rotation.DestinationFrame"},{"description":"A time to lock the rotation to. Setting this to an empty string will unlock the time and return to rotation based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Deimos.Rotation.FixedDate"},{"description":"This value specifies the source frame that is used as the basis for the coordinate transformation. This has to be a valid SPICE name.","identifier":"SourceFrame","name":"Source","type":"StringProperty","uri":"Scene.Deimos.Rotation.SourceFrame"}],"propertyOwners":[],"tags":[],"type":"SpiceRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.Deimos.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Deimos.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.Deimos.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.Deimos.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.Deimos.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":["moon_solarSystem","moon_terrestrial","moon_mars"],"type":"SceneGraphNode"},{"description":"Label for Mars' moon Deimos","name":"Deimos Label","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.DeimosLabel.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.DeimosLabel.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.DeimosLabel.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.DeimosLabel.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.DeimosLabel.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.DeimosLabel.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.DeimosLabel.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.DeimosLabel.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.DeimosLabel.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.DeimosLabel.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.DeimosLabel.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.DeimosLabel.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.DeimosLabel.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.DeimosLabel.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.DeimosLabel.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.DeimosLabel.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.DeimosLabel.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.DeimosLabel.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"This determines the blending mode that is applied to the renderable.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.DeimosLabel.Renderable.BlendMode"},{"description":"The label text color.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.DeimosLabel.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.DeimosLabel.Renderable.DimInAtmosphere"},{"description":"Enable/Disable the Fade-in effect.","identifier":"EnableFading","name":"Enable/Disable Fade-in Effect","type":"BoolProperty","uri":"Scene.DeimosLabel.Renderable.EnableFading"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DeimosLabel.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.DeimosLabel.Renderable.Fade"},{"description":"Distance unit for fade-in/-out distance calculations. Defaults to \"au\".","identifier":"FadeUnit","name":"Fade Distance Unit","type":"OptionProperty","uri":"Scene.DeimosLabel.Renderable.FadeUnit"},{"description":"The distance range in which the labels should be fully opaque, specified in the chosen unit. The distance from the position of the label to the camera.","identifier":"FadeDistances","name":"Fade Distances","type":"Vec2Property","uri":"Scene.DeimosLabel.Renderable.FadeDistances"},{"description":"The distances over which the fading takes place, given in the specified unit. The first value is the distance before the closest distance and the second the one after the furthest distance. For example, with the unit Parsec (pc), a value of {1, 2} will make the label being fully faded out 1 Parsec before the closest distance and 2 Parsec away from the furthest distance.","identifier":"FadeWidths","name":"Fade Widths","type":"Vec2Property","uri":"Scene.DeimosLabel.Renderable.FadeWidths"},{"description":"The font size (in points) for the label.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.DeimosLabel.Renderable.FontSize"},{"description":"The minimum and maximum size (in pixels) of the label.","identifier":"MinMaxSize","name":"Min and Max Size","type":"IVec2Property","uri":"Scene.DeimosLabel.Renderable.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.DeimosLabel.Renderable.Opacity"},{"description":"Label orientation rendering mode.","identifier":"OrientationOption","name":"Orientation Option","type":"OptionProperty","uri":"Scene.DeimosLabel.Renderable.OrientationOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.DeimosLabel.Renderable.Type"},{"description":"Scales the size of the label, exponentially. The value is used as the exponent in a 10^x computation to scale the label size.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.DeimosLabel.Renderable.Size"},{"description":"The text that will be displayed on screen.","identifier":"Text","name":"Text","type":"StringProperty","uri":"Scene.DeimosLabel.Renderable.Text"}],"propertyOwners":[],"tags":[],"type":"RenderableLabel"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.DeimosLabel.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.DeimosLabel.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.DeimosLabel.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["solarsystem_labels","moon_labels","major_moon_labels"],"type":"SceneGraphNode"},{"description":"Trail for Deimos","name":"Deimos Trail","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.DeimosTrail.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.DeimosTrail.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.DeimosTrail.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.DeimosTrail.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.DeimosTrail.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.DeimosTrail.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.DeimosTrail.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.DeimosTrail.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.DeimosTrail.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.DeimosTrail.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.DeimosTrail.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.DeimosTrail.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.DeimosTrail.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.DeimosTrail.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.DeimosTrail.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.DeimosTrail.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.DeimosTrail.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.DeimosTrail.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.DeimosTrail.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DeimosTrail.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.DeimosTrail.Renderable.Fade"},{"description":"The number of samples along the orbit. This determines the resolution of the trail; the tradeoff being that a higher resolution is able to resolve more detail, but will take more resources while rendering, too. The higher, the smoother the trail, but also more memory will be used.","identifier":"Resolution","name":"Number of samples along the orbit","type":"IntProperty","uri":"Scene.DeimosTrail.Renderable.Resolution"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.DeimosTrail.Renderable.Opacity"},{"description":"The objects period, i.e. the length of its orbit around the parent object given in (Earth) days. In the case of Earth, this would be a sidereal year (=365.242 days). If this values is specified as multiples of the period, it is possible to show the effects of precession.","identifier":"Period","name":"Period (in days)","type":"DoubleProperty","uri":"Scene.DeimosTrail.Renderable.Period"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.DeimosTrail.Renderable.Type"}],"propertyOwners":[{"description":"The appearance of the trail","name":"Appearance","properties":[{"description":"This value determines the RGB main color for the lines and points of the trail.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.DeimosTrail.Renderable.Appearance.Color"},{"description":"Toggles whether the trail should fade older points out. If this value is true, the 'Fade' parameter determines the speed of fading. If this value is false, the entire trail is rendered at full opacity and color.","identifier":"EnableFade","name":"Enable line fading of old points","type":"BoolProperty","uri":"Scene.DeimosTrail.Renderable.Appearance.EnableFade"},{"description":"The amount of the trail that should be faded. If the value is 0 then the trail will have no fading applied. A value of 0.6 will result in a trail where 60% of the extent of the trail will have fading applied to it. In otherwords, the 40% closest to the head of the trail will be solid and the rest will fade until completely transparent at the end of the trail. A value of 1 will result in a trail that starts fading immediately, becoming fully transparent by the end of the trail. This setting only applies if the 'EnableFade' value is true. If it is false, this setting has no effect.","identifier":"LineFadeAmount","name":"Line Fade Amount","type":"FloatProperty","uri":"Scene.DeimosTrail.Renderable.Appearance.LineFadeAmount"},{"description":"The extent of the rendered trail. A value of 0 will result in no trail and a value of 1 will result in a trail that covers the entire extent. The setting only applies if 'EnableFade' is true. If it is false, this setting has no effect.","identifier":"LineLength","name":"Line Length","type":"FloatProperty","uri":"Scene.DeimosTrail.Renderable.Appearance.LineLength"},{"description":"Specifies the line width of the trail lines, if the selected rendering method includes lines. If the rendering mode is Points, this value is ignored.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.DeimosTrail.Renderable.Appearance.LineWidth"},{"description":"Specifies the base size of the points along the line, if the selected rendering method includes points. If the rendering mode is Lines, this value is ignored. If a subsampling of the values is performed, the subsampled values are half this size.","identifier":"PointSize","name":"Point Size","type":"IntProperty","uri":"Scene.DeimosTrail.Renderable.Appearance.PointSize"},{"description":"Determines how the trail should be rendered. If 'Lines' is selected, only the line part is visible, if 'Points' is selected, only the corresponding points (and subpoints) are shown. 'Lines+Points' shows both parts.","identifier":"Rendering","name":"Rendering Mode","type":"OptionProperty","uri":"Scene.DeimosTrail.Renderable.Appearance.Rendering"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.DeimosTrail.Renderable.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.DeimosTrail.Renderable.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.DeimosTrail.Renderable.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.DeimosTrail.Renderable.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":[],"type":"RenderableTrailOrbit"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.DeimosTrail.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.DeimosTrail.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.DeimosTrail.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["moonTrail_solarSystem","moonTrail_terrestrial","moonTrail_mars"],"type":"SceneGraphNode"},{"description":"Delphinus Image","name":"Delphinus Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Del.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Del.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Del.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Del.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Del.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Del.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Del.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Del.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Del.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Del.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Del.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Del.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Del.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Del.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Del.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Del.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"","name":"Dione","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Dione.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Dione.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Dione.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Dione.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Dione.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Dione.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Dione.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Dione.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Dione.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Dione.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Dione.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Dione.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Dione.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Dione.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Dione.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Dione.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Dione.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Dione.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The intensity factor for the ambient light used for light shading.","identifier":"AmbientIntensity","name":"Ambient Intensity","type":"FloatProperty","uri":"Scene.Dione.Renderable.AmbientIntensity"},{"description":"The currently used scale factor whose target value is deteremined by 'TargetLodScaleFactor'.","identifier":"CurrentLodScaleFactor","name":"Current Level of Detail Scale Factor (Read Only)","type":"FloatProperty","uri":"Scene.Dione.Renderable.CurrentLodScaleFactor"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Dione.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Dione.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Dione.Renderable.Fade"},{"description":"The identifier of a scene graph node that should be used as the source of illumination for the globe. If not specified, the solar system's Sun is used.","identifier":"LightSourceNode","name":"Light Source","type":"StringProperty","uri":"Scene.Dione.Renderable.LightSourceNode"},{"description":"The number of currently active layers. If this value reaches the maximum, bad things will happen.","identifier":"NActiveLayers","name":"Number of active layers","type":"IntProperty","uri":"Scene.Dione.Renderable.NActiveLayers"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Dione.Renderable.Opacity"},{"description":"The roughness factor that is used for the Oren-Nayar lighting mode.","identifier":"OrenNayarRoughness","name":"orenNayarRoughness","type":"FloatProperty","uri":"Scene.Dione.Renderable.OrenNayarRoughness"},{"description":"Specifies whether the planet should be shaded by the primary light source or not. If disabled, all parts of the planet are illuminated. Note that if the globe has a corresponding atmosphere, there is a separate setting to control the shadowing induced by the atmosphere.","identifier":"PerformShading","name":"Perform shading","type":"BoolProperty","uri":"Scene.Dione.Renderable.PerformShading"},{"description":"Tells the rendering engine not to perform distance based performance culling for this globe. Turning this property on will let the globe to be seen at far away distances when normally it would be hidden.","identifier":"RenderAtDistance","name":"Render at Distance","type":"BoolProperty","uri":"Scene.Dione.Renderable.RenderAtDistance"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Dione.Renderable.Type"},{"description":"Determines the targeted level-of-detail of the tiles for this globe. A higher value means that the tiles rendered are a higher resolution for the same distance of the camera to the planet.","identifier":"TargetLodScaleFactor","name":"Target Level of Detail Scale Factor","type":"FloatProperty","uri":"Scene.Dione.Renderable.TargetLodScaleFactor"},{"description":"Determines whether higher-accuracy normals should be used in the rendering. These normals are calculated based on the height field information and are thus only available if the planet has a height map layer.","identifier":"UseAccurateNormals","name":"Use Accurate Normals","type":"BoolProperty","uri":"Scene.Dione.Renderable.UseAccurateNormals"}],"propertyOwners":[{"description":"","name":"Debug","properties":[{"description":"The number of checks that have to fail/succeed in a row before the dynamic level-of-detail adjusts the actual level-of-detail up or down during a session recording.","identifier":"DynamicLodIterationCount","name":"Data availability checks before LOD factor impact","type":"IntProperty","uri":"Scene.Dione.Renderable.Debug.DynamicLodIterationCount"},{"description":"If true, the tile level is determined by the area projected on screen. If false, the distance to the center of the tile is used instead.","identifier":"LevelByProjectedAreaElseDistance","name":"Level by projected area (else distance)","type":"BoolProperty","uri":"Scene.Dione.Renderable.Debug.LevelByProjectedAreaElseDistance"},{"description":"The tile level that is used as the cut off between rendering tiles using the globe model rendering vs the flat in-game rendering method. The value is a trade-off between not having precision errors in the rendering and representing a tile as flat or curved.","identifier":"ModelSpaceRenderingCutoffLevel","name":"Model Space Rendering Cutoff Level","type":"IntProperty","uri":"Scene.Dione.Renderable.Debug.ModelSpaceRenderingCutoffLevel"},{"description":"If this value is set to true, frustum culling will be performed.","identifier":"PerformFrustumCulling","name":"Perform frustum culling","type":"BoolProperty","uri":"Scene.Dione.Renderable.Debug.PerformFrustumCulling"},{"description":"Reset all tile provides for the globe and reload the data.","identifier":"ResetTileProviders","name":"Reset tile providers","type":"BoolProperty","uri":"Scene.Dione.Renderable.Debug.ResetTileProviders"},{"description":"Shows the borders between chunks in a red highlight.","identifier":"ShowChunkEdges","name":"Show chunk edges","type":"BoolProperty","uri":"Scene.Dione.Renderable.Debug.ShowChunkEdges"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"GeoJson","properties":[],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Labels","properties":[{"description":"Labels are aligned horizontally or circularly related to the planet.","identifier":"AlignmentOption","name":"Alignment Option","type":"OptionProperty","uri":"Scene.Dione.Renderable.Labels.AlignmentOption"},{"description":"The text color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.Dione.Renderable.Labels.Color"},{"description":"Labels culling disabled.","identifier":"DisableCulling","name":"Culling Disabled","type":"BoolProperty","uri":"Scene.Dione.Renderable.Labels.DisableCulling"},{"description":"Labels culling distance from globe's center.","identifier":"DistanceEPS","name":"Culling Distance","type":"FloatProperty","uri":"Scene.Dione.Renderable.Labels.DistanceEPS"},{"description":"Enables and disables labels' rendering.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Dione.Renderable.Labels.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Dione.Renderable.Labels.Fade"},{"description":"Sets whether the labels fade in when approaching the globe from a distance. If false, no fading happens and the labels immediately has full opacity.","identifier":"FadeInEnabled","name":"Fade In Enabled","type":"BoolProperty","uri":"Scene.Dione.Renderable.Labels.FadeInEnabled"},{"description":"Sets whether the labels fade out when approaching the surface of the globe. If false, no fading happens and the labels stays in full opacity.","identifier":"FadeOutEnabled","name":"Fade Out Enabled","type":"BoolProperty","uri":"Scene.Dione.Renderable.Labels.FadeOutEnabled"},{"description":"The distances above the globe's surface at which the labels start fading in or out, given in meters. The final distances are also adjusted by the specified height offset.","identifier":"FadeDistances","name":"Fade-In Distances","type":"Vec2Property","uri":"Scene.Dione.Renderable.Labels.FadeDistances"},{"description":"Font size for the rendering labels. This is different fromt text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.Dione.Renderable.Labels.FontSize"},{"description":"This value moves the label away from the globe surface by the specified distance (in meters).","identifier":"HeightOffset","name":"Height Offset","type":"FloatProperty","uri":"Scene.Dione.Renderable.Labels.HeightOffset"},{"description":"This value affects the size scale of the labels.","identifier":"LabelsSize","name":"Labels Size","type":"FloatProperty","uri":"Scene.Dione.Renderable.Labels.LabelsSize"},{"description":"Minimum and maximum label size, in pixels.","identifier":"MinMaxSize","name":"Min/Max Text Size","type":"IVec2Property","uri":"Scene.Dione.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Dione.Renderable.Labels.Opacity"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Layers","properties":[],"propertyOwners":[{"description":"","name":"Color Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.BlendTileLevels"}],"propertyOwners":[{"description":"","name":"Texture","properties":[{"description":"This value specifies the blend mode that is applied to this layer. The blend mode determines how this layer is added to the underlying layers beneath.","identifier":"BlendMode","name":"Blend Mode","type":"OptionProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.BlendMode"},{"description":"If this value is enabled, the layer will be used for the final composition of the planet. If this value is disabled, the layer will be ignored in the composition.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Fade"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Opacity"},{"description":"If this value is triggered, a script will be executed that will remove this layer before the next frame.","identifier":"Remove","name":"Remove","type":"TriggerProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Remove"},{"description":"If this value is triggered, this layer will be reset. This will delete the local cache for this layer and will trigger a fresh load of all tiles.","identifier":"Reset","name":"Reset","type":"TriggerProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Reset"},{"description":"The type of this Layer. This value is a read-only property and thus cannot be changed.","identifier":"Type","name":"Type","type":"OptionProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Type"}],"propertyOwners":[{"description":"","name":"Adjustment","properties":[{"description":"The type of layer adjustment that is applied to the underlying layer.","identifier":"Type","name":"Type","type":"OptionProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Adjustment.Type"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Settings","properties":[{"description":"This value is used as an exponent to adjust the color for each tile.","identifier":"Gamma","name":"Gamma","type":"FloatProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Settings.Gamma"},{"description":"This value is used as a multiplier to adjust the color applied after taking the gamma value as an exponent.","identifier":"Multiplier","name":"Multiplier","type":"FloatProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Settings.Multiplier"},{"description":"This value is used as an additive modifier to adjust the color applied after the gamma exponent and the multiplier has been performed.","identifier":"Offset","name":"Offset","type":"FloatProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Settings.Offset"},{"description":"If this value is triggered it will reset all of these values to their default values.","identifier":"SetDefault","name":"Set Default","type":"TriggerProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.Settings.SetDefault"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Tile Provider","properties":[{"description":"The path of the GDAL file or the image file that is to be used in this tile provider.","identifier":"FilePath","name":"File Path","type":"StringProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.TileProvider.FilePath"},{"description":"This value is the preferred size (in pixels) for each tile. Choosing the right value is a tradeoff between more efficiency (larger images) and better quality (smaller images). The tile pixel size has to be smaller than the size of the complete image if a single image is used.","identifier":"TilePixelSize","name":"Tile Pixel Size","type":"IntProperty","uri":"Scene.Dione.Renderable.Layers.ColorLayers.Texture.TileProvider.TilePixelSize"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"Height Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Dione.Renderable.Layers.HeightLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Night Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Dione.Renderable.Layers.NightLayers.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Overlays","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Dione.Renderable.Layers.Overlays.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Water Masks","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Dione.Renderable.Layers.WaterMasks.BlendTileLevels"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"","name":"ShadowMapping","properties":[{"description":"The number of samples used during shadow mapping calculation (Percentage Closer Filtering).","identifier":"NumberShadowSamples","name":"Number of Shadow Samples","type":"IntProperty","uri":"Scene.Dione.Renderable.ShadowMapping.NumberShadowSamples"},{"description":"Enables shadow mapping algorithm. Used by renderable rings, too.","identifier":"ShadowMapping","name":"Shadow Mapping","type":"BoolProperty","uri":"Scene.Dione.Renderable.ShadowMapping.ShadowMapping"},{"description":"The percentage of the correct distance to the surface being shadowed.","identifier":"ZFightingPercentage","name":"Z-Fighting Percentage","type":"FloatProperty","uri":"Scene.Dione.Renderable.ShadowMapping.ZFightingPercentage"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":"RenderableGlobe"},{"description":"","name":"Rotation","properties":[{"description":"This value specifies the destination frame that is used for the coordinate transformation. This has to be a valid SPICE name.","identifier":"DestinationFrame","name":"Destination","type":"StringProperty","uri":"Scene.Dione.Rotation.DestinationFrame"},{"description":"A time to lock the rotation to. Setting this to an empty string will unlock the time and return to rotation based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Dione.Rotation.FixedDate"},{"description":"This value specifies the source frame that is used as the basis for the coordinate transformation. This has to be a valid SPICE name.","identifier":"SourceFrame","name":"Source","type":"StringProperty","uri":"Scene.Dione.Rotation.SourceFrame"}],"propertyOwners":[],"tags":[],"type":"SpiceRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.Dione.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.Dione.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.Dione.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.Dione.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.Dione.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":["moon_solarSystem","moon_giants","moon_saturn","moon_major_saturn"],"type":"SceneGraphNode"},{"description":"Label for Saturn's moon Dione","name":"Dione Label","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.DioneLabel.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.DioneLabel.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.DioneLabel.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.DioneLabel.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.DioneLabel.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.DioneLabel.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.DioneLabel.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.DioneLabel.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.DioneLabel.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.DioneLabel.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.DioneLabel.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.DioneLabel.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.DioneLabel.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.DioneLabel.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.DioneLabel.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.DioneLabel.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.DioneLabel.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.DioneLabel.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"This determines the blending mode that is applied to the renderable.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.DioneLabel.Renderable.BlendMode"},{"description":"The label text color.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.DioneLabel.Renderable.Color"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.DioneLabel.Renderable.DimInAtmosphere"},{"description":"Enable/Disable the Fade-in effect.","identifier":"EnableFading","name":"Enable/Disable Fade-in Effect","type":"BoolProperty","uri":"Scene.DioneLabel.Renderable.EnableFading"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DioneLabel.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.DioneLabel.Renderable.Fade"},{"description":"Distance unit for fade-in/-out distance calculations. Defaults to \"au\".","identifier":"FadeUnit","name":"Fade Distance Unit","type":"OptionProperty","uri":"Scene.DioneLabel.Renderable.FadeUnit"},{"description":"The distance range in which the labels should be fully opaque, specified in the chosen unit. The distance from the position of the label to the camera.","identifier":"FadeDistances","name":"Fade Distances","type":"Vec2Property","uri":"Scene.DioneLabel.Renderable.FadeDistances"},{"description":"The distances over which the fading takes place, given in the specified unit. The first value is the distance before the closest distance and the second the one after the furthest distance. For example, with the unit Parsec (pc), a value of {1, 2} will make the label being fully faded out 1 Parsec before the closest distance and 2 Parsec away from the furthest distance.","identifier":"FadeWidths","name":"Fade Widths","type":"Vec2Property","uri":"Scene.DioneLabel.Renderable.FadeWidths"},{"description":"The font size (in points) for the label.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.DioneLabel.Renderable.FontSize"},{"description":"The minimum and maximum size (in pixels) of the label.","identifier":"MinMaxSize","name":"Min and Max Size","type":"IVec2Property","uri":"Scene.DioneLabel.Renderable.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.DioneLabel.Renderable.Opacity"},{"description":"Label orientation rendering mode.","identifier":"OrientationOption","name":"Orientation Option","type":"OptionProperty","uri":"Scene.DioneLabel.Renderable.OrientationOption"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.DioneLabel.Renderable.Type"},{"description":"Scales the size of the label, exponentially. The value is used as the exponent in a 10^x computation to scale the label size.","identifier":"Size","name":"Size","type":"FloatProperty","uri":"Scene.DioneLabel.Renderable.Size"},{"description":"The text that will be displayed on screen.","identifier":"Text","name":"Text","type":"StringProperty","uri":"Scene.DioneLabel.Renderable.Text"}],"propertyOwners":[],"tags":[],"type":"RenderableLabel"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.DioneLabel.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.DioneLabel.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.DioneLabel.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["solarsystem_labels","moon_labels","major_moon_labels"],"type":"SceneGraphNode"},{"description":"Trail of Saturn's moon Dione as observed by Saturn","name":"Dione Trail","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.DioneTrail.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.DioneTrail.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.DioneTrail.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.DioneTrail.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.DioneTrail.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.DioneTrail.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.DioneTrail.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.DioneTrail.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.DioneTrail.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.DioneTrail.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.DioneTrail.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.DioneTrail.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.DioneTrail.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.DioneTrail.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.DioneTrail.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.DioneTrail.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.DioneTrail.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.DioneTrail.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.DioneTrail.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.DioneTrail.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.DioneTrail.Renderable.Fade"},{"description":"The number of samples along the orbit. This determines the resolution of the trail; the tradeoff being that a higher resolution is able to resolve more detail, but will take more resources while rendering, too. The higher, the smoother the trail, but also more memory will be used.","identifier":"Resolution","name":"Number of samples along the orbit","type":"IntProperty","uri":"Scene.DioneTrail.Renderable.Resolution"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.DioneTrail.Renderable.Opacity"},{"description":"The objects period, i.e. the length of its orbit around the parent object given in (Earth) days. In the case of Earth, this would be a sidereal year (=365.242 days). If this values is specified as multiples of the period, it is possible to show the effects of precession.","identifier":"Period","name":"Period (in days)","type":"DoubleProperty","uri":"Scene.DioneTrail.Renderable.Period"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.DioneTrail.Renderable.Type"}],"propertyOwners":[{"description":"The appearance of the trail","name":"Appearance","properties":[{"description":"This value determines the RGB main color for the lines and points of the trail.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.DioneTrail.Renderable.Appearance.Color"},{"description":"Toggles whether the trail should fade older points out. If this value is true, the 'Fade' parameter determines the speed of fading. If this value is false, the entire trail is rendered at full opacity and color.","identifier":"EnableFade","name":"Enable line fading of old points","type":"BoolProperty","uri":"Scene.DioneTrail.Renderable.Appearance.EnableFade"},{"description":"The amount of the trail that should be faded. If the value is 0 then the trail will have no fading applied. A value of 0.6 will result in a trail where 60% of the extent of the trail will have fading applied to it. In otherwords, the 40% closest to the head of the trail will be solid and the rest will fade until completely transparent at the end of the trail. A value of 1 will result in a trail that starts fading immediately, becoming fully transparent by the end of the trail. This setting only applies if the 'EnableFade' value is true. If it is false, this setting has no effect.","identifier":"LineFadeAmount","name":"Line Fade Amount","type":"FloatProperty","uri":"Scene.DioneTrail.Renderable.Appearance.LineFadeAmount"},{"description":"The extent of the rendered trail. A value of 0 will result in no trail and a value of 1 will result in a trail that covers the entire extent. The setting only applies if 'EnableFade' is true. If it is false, this setting has no effect.","identifier":"LineLength","name":"Line Length","type":"FloatProperty","uri":"Scene.DioneTrail.Renderable.Appearance.LineLength"},{"description":"Specifies the line width of the trail lines, if the selected rendering method includes lines. If the rendering mode is Points, this value is ignored.","identifier":"LineWidth","name":"Line Width","type":"FloatProperty","uri":"Scene.DioneTrail.Renderable.Appearance.LineWidth"},{"description":"Specifies the base size of the points along the line, if the selected rendering method includes points. If the rendering mode is Lines, this value is ignored. If a subsampling of the values is performed, the subsampled values are half this size.","identifier":"PointSize","name":"Point Size","type":"IntProperty","uri":"Scene.DioneTrail.Renderable.Appearance.PointSize"},{"description":"Determines how the trail should be rendered. If 'Lines' is selected, only the line part is visible, if 'Points' is selected, only the corresponding points (and subpoints) are shown. 'Lines+Points' shows both parts.","identifier":"Rendering","name":"Rendering Mode","type":"OptionProperty","uri":"Scene.DioneTrail.Renderable.Appearance.Rendering"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Translation","properties":[{"description":"A time to lock the position to. Setting this to an empty string will unlock the time and return to position based on current simulation time.","identifier":"FixedDate","name":"Fixed Date","type":"StringProperty","uri":"Scene.DioneTrail.Renderable.Translation.FixedDate"},{"description":"This is the SPICE NAIF name for the parent of the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'SOLAR SYSTEM BARYCENTER') or a NAIF integer id code (such as '0').","identifier":"Observer","name":"Observer","type":"StringProperty","uri":"Scene.DioneTrail.Renderable.Translation.Observer"},{"description":"This is the SPICE NAIF name for the reference frame in which the position should be retrieved. The default value is GALACTIC.","identifier":"Frame","name":"Reference Frame","type":"StringProperty","uri":"Scene.DioneTrail.Renderable.Translation.Frame"},{"description":"This is the SPICE NAIF name for the body whose translation is to be computed by the SpiceTranslation. It can either be a fully qualified name (such as 'EARTH') or a NAIF integer id code (such as '399').","identifier":"Target","name":"Target","type":"StringProperty","uri":"Scene.DioneTrail.Renderable.Translation.Target"}],"propertyOwners":[],"tags":[],"type":"SpiceTranslation"}],"tags":[],"type":"RenderableTrailOrbit"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.DioneTrail.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.DioneTrail.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.DioneTrail.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["moonTrail_solarSystem","moonTrail_giants","moonTrail_saturn","moonTrail_major_saturn"],"type":"SceneGraphNode"},{"description":"Dorado Image","name":"Dorado Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Dor.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Dor.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Dor.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Dor.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Dor.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Dor.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Dor.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Dor.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Dor.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Dor.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Dor.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Dor.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Dor.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Dor.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dor.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Dor.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","southern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Draco Image","name":"Draco Image","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.ImageConstellation-Dra.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.ImageConstellation-Dra.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.ImageConstellation-Dra.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.ImageConstellation-Dra.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.ImageConstellation-Dra.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"Decides whether the plane should automatically adjust in size to match the aspect ratio of the content. Otherwise it will remain in the given size.","identifier":"AutoScale","name":"Auto Scale","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.Renderable.AutoScale"},{"description":"Specifies whether the plane should be a billboard, which means that it is always facing the camera. If it is not, it can be oriented using other transformations.","identifier":"Billboard","name":"Billboard Mode","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.Renderable.Billboard"},{"description":"Determines the blending mode that is applied to this plane.","identifier":"BlendMode","name":"Blending Mode","type":"OptionProperty","uri":"Scene.ImageConstellation-Dra.Renderable.BlendMode"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.Renderable.DimInAtmosphere"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.ImageConstellation-Dra.Renderable.Fade"},{"description":"If false, the image plane will not be mirrored when viewed from the backside. This is usually desirable when the image shows data at a specific location, but not if it is displaying text for example.","identifier":"MirrorBackside","name":"Mirror Backside of Image Plane","type":"BoolProperty","uri":"Scene.ImageConstellation-Dra.Renderable.MirrorBackside"},{"description":"An RGB color to multiply with the plane's texture. Useful for applying a color to grayscale images.","identifier":"MultiplyColor","name":"Multiply Color","type":"Vec3Property","uri":"Scene.ImageConstellation-Dra.Renderable.MultiplyColor"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.ImageConstellation-Dra.Renderable.Opacity"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.ImageConstellation-Dra.Renderable.Type"},{"description":"The size of the plane in meters.","identifier":"Size","name":"Size","type":"Vec2Property","uri":"Scene.ImageConstellation-Dra.Renderable.Size"},{"description":"A path to an image file to use as a texture for the plane.","identifier":"Texture","name":"Texture","type":"StringProperty","uri":"Scene.ImageConstellation-Dra.Renderable.Texture"}],"propertyOwners":[],"tags":[],"type":"RenderablePlaneImageLocal"},{"description":"","name":"Rotation","properties":[{"description":"This value is the used as a 3x3 rotation matrix that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Rotation","name":"Rotation","type":"Vec3Property","uri":"Scene.ImageConstellation-Dra.Rotation.Rotation"}],"propertyOwners":[],"tags":[],"type":"StaticRotation"},{"description":"","name":"Scale","properties":[{"description":"This value is used as a scaling factor for the scene graph node that this transformation is attached to relative to its parent.","identifier":"Scale","name":"Scale","type":"DoubleProperty","uri":"Scene.ImageConstellation-Dra.Scale.Scale"}],"propertyOwners":[],"tags":[],"type":"StaticScale"},{"description":"","name":"Translation","properties":[{"description":"This value is used as a static offset (in meters) that is applied to the scene graph node that this transformation is attached to relative to its parent.","identifier":"Position","name":"Position","type":"DVec3Property","uri":"Scene.ImageConstellation-Dra.Translation.Position"}],"propertyOwners":[],"tags":[],"type":"StaticTranslation"}],"tags":["ImageConstellation","northern","daytime_hidden"],"type":"SceneGraphNode"},{"description":"Third rock from the Sun","name":"Earth","properties":[{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera is 'approaching' the scene graph node.","identifier":"ApproachFactor","name":"Approach Factor","type":"DoubleProperty","uri":"Scene.Earth.ApproachFactor"},{"description":"The bounding sphere of the scene graph node meaning that everything that this scene graph node renders must be contained within this sphere. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed bounding sphere is used.","identifier":"BoundingSphere","name":"Bounding Sphere","type":"DoubleProperty","uri":"Scene.Earth.BoundingSphere"},{"description":"If this value is set to 'true', the screenspace-based properties are calculated at regular intervals. If these values are set to 'false', they are not updated.","identifier":"ComputeScreenSpaceData","name":"Compute Screen Space Data","type":"BoolProperty","uri":"Scene.Earth.ComputeScreenSpaceData"},{"description":"The distance from the camera to the node surface.","identifier":"DistanceFromCamToNode","name":"DistanceFromCamToNode","type":"DoubleProperty","uri":"Scene.Earth.DistanceFromCamToNode"},{"description":"This read-only property contains the evaluated value for the bounding sphere. This is the actual value that is used internally within the software. If the BoundingSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedBoundingSphere","name":"Evaluated Bounding Sphere","type":"DoubleProperty","uri":"Scene.Earth.EvaluatedBoundingSphere"},{"description":"This read-only property contains the evaluated value for the interaction sphere. This is the actual value that is used internally within the software. If the InteractionSphere property is set to -1, it is the computed value, otherwise it matches the one set in the property.","identifier":"EvaluatedInteractionSphere","name":"Evaluated Interaction Sphere","type":"DoubleProperty","uri":"Scene.Earth.EvaluatedInteractionSphere"},{"description":"This is the description for the scene graph node to be shown in the gui. Example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Earth.GuiDescription"},{"description":"This represents if the scene graph node should be shown in the gui. Example: false.","identifier":"GuiHidden","name":"Gui Hidden","type":"BoolProperty","uri":"Scene.Earth.GuiHidden"},{"description":"This is the name for the scene graph node in the gui. Example: Earth.","identifier":"GuiName","name":"Gui Name","type":"StringProperty","uri":"Scene.Earth.GuiName"},{"description":"This is the path for the scene graph node in the gui example: /Solar System/Planets/Earth.","identifier":"GuiPath","name":"Gui Path","type":"StringProperty","uri":"Scene.Earth.GuiPath"},{"description":"The minimum radius that the camera is allowed to get close to this scene graph node. This value is only used as an override to the bounding sphere calculated by the Renderable, if present. If this value is -1, the Renderable's computed interaction sphere is used.","identifier":"InteractionSphere","name":"Interaction Sphere","type":"DoubleProperty","uri":"Scene.Earth.InteractionSphere"},{"description":"This value is a multiplication factor for the interaction sphere that determines when the camera has 'reached' the scene graph node.","identifier":"ReachFactor","name":"Reach Factor","type":"DoubleProperty","uri":"Scene.Earth.ReachFactor"},{"description":"The screen size of the radius of the node.","identifier":"ScreenSizeRadius","name":"ScreenSizeRadius","type":"DoubleProperty","uri":"Scene.Earth.ScreenSizeRadius"},{"description":"The x,y position in screen space. Can be used for placing GUI elements.","identifier":"ScreenSpacePosition","name":"ScreenSpacePosition","type":"IVec2Property","uri":"Scene.Earth.ScreenSpacePosition"},{"description":"Determines if the node is currently visible on screen.","identifier":"ScreenVisibility","name":"ScreenVisibility","type":"BoolProperty","uri":"Scene.Earth.ScreenVisibility"},{"description":"If enabled the bounding sphere of this scene graph node is rendered as a debug method. The interaction sphere is rendered in cyan and the bounding sphere in purple. If only one is visible, this may be because the spheres have equal size and are overlapping.","identifier":"ShowDebugSphere","name":"Show Debug Sphere","type":"BoolProperty","uri":"Scene.Earth.ShowDebugSphere"},{"description":"Only relevant when using touch interaction. If true, the 'direct manipulation' scheme will be used when interacting with this scene graph node, meaning that the positions on the interaction sphere that intersects with the touch points will directly follow the motion of the touch points. Works best for objects that have an interaction sphere of about the same size as the bounding sphere, and that are somewhat spherical. Note that using this feature might significalty reduce the performance.","identifier":"SupportsDirectInteraction","name":"Supports Direct Interaction","type":"BoolProperty","uri":"Scene.Earth.SupportsDirectInteraction"},{"description":"The distace in world coordinates between node and camera at which the screenspace object will become visible.","identifier":"VisibilityDistance","name":"VisibilityDistance","type":"FloatProperty","uri":"Scene.Earth.VisibilityDistance"}],"propertyOwners":[{"description":"","name":"Renderable","properties":[{"description":"The intensity factor for the ambient light used for light shading.","identifier":"AmbientIntensity","name":"Ambient Intensity","type":"FloatProperty","uri":"Scene.Earth.Renderable.AmbientIntensity"},{"description":"The currently used scale factor whose target value is deteremined by 'TargetLodScaleFactor'.","identifier":"CurrentLodScaleFactor","name":"Current Level of Detail Scale Factor (Read Only)","type":"FloatProperty","uri":"Scene.Earth.Renderable.CurrentLodScaleFactor"},{"description":"Decides if the object should be dimmed (i.e. faded out) when the camera is in the sunny part of an atmosphere.","identifier":"DimInAtmosphere","name":"Dim In Atmosphere","type":"BoolProperty","uri":"Scene.Earth.Renderable.DimInAtmosphere"},{"description":"Enables/Disables Eclipse shadows on this globe.","identifier":"Eclipse","name":"Eclipse","type":"BoolProperty","uri":"Scene.Earth.Renderable.Eclipse"},{"description":"Enables the rendering of eclipse shadows using hard shadows.","identifier":"EclipseHardShadows","name":"Eclipse Hard Shadows","type":"BoolProperty","uri":"Scene.Earth.Renderable.EclipseHardShadows"},{"description":"Determines whether this object will be visible or not.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Earth.Renderable.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Earth.Renderable.Fade"},{"description":"The identifier of a scene graph node that should be used as the source of illumination for the globe. If not specified, the solar system's Sun is used.","identifier":"LightSourceNode","name":"Light Source","type":"StringProperty","uri":"Scene.Earth.Renderable.LightSourceNode"},{"description":"The number of currently active layers. If this value reaches the maximum, bad things will happen.","identifier":"NActiveLayers","name":"Number of active layers","type":"IntProperty","uri":"Scene.Earth.Renderable.NActiveLayers"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Earth.Renderable.Opacity"},{"description":"The roughness factor that is used for the Oren-Nayar lighting mode.","identifier":"OrenNayarRoughness","name":"orenNayarRoughness","type":"FloatProperty","uri":"Scene.Earth.Renderable.OrenNayarRoughness"},{"description":"Specifies whether the planet should be shaded by the primary light source or not. If disabled, all parts of the planet are illuminated. Note that if the globe has a corresponding atmosphere, there is a separate setting to control the shadowing induced by the atmosphere.","identifier":"PerformShading","name":"Perform shading","type":"BoolProperty","uri":"Scene.Earth.Renderable.PerformShading"},{"description":"Tells the rendering engine not to perform distance based performance culling for this globe. Turning this property on will let the globe to be seen at far away distances when normally it would be hidden.","identifier":"RenderAtDistance","name":"Render at Distance","type":"BoolProperty","uri":"Scene.Earth.Renderable.RenderAtDistance"},{"description":"The type of the renderable.","identifier":"Type","name":"Renderable Type","type":"StringProperty","uri":"Scene.Earth.Renderable.Type"},{"description":"Determines the targeted level-of-detail of the tiles for this globe. A higher value means that the tiles rendered are a higher resolution for the same distance of the camera to the planet.","identifier":"TargetLodScaleFactor","name":"Target Level of Detail Scale Factor","type":"FloatProperty","uri":"Scene.Earth.Renderable.TargetLodScaleFactor"},{"description":"Determines whether higher-accuracy normals should be used in the rendering. These normals are calculated based on the height field information and are thus only available if the planet has a height map layer.","identifier":"UseAccurateNormals","name":"Use Accurate Normals","type":"BoolProperty","uri":"Scene.Earth.Renderable.UseAccurateNormals"}],"propertyOwners":[{"description":"","name":"Debug","properties":[{"description":"The number of checks that have to fail/succeed in a row before the dynamic level-of-detail adjusts the actual level-of-detail up or down during a session recording.","identifier":"DynamicLodIterationCount","name":"Data availability checks before LOD factor impact","type":"IntProperty","uri":"Scene.Earth.Renderable.Debug.DynamicLodIterationCount"},{"description":"If true, the tile level is determined by the area projected on screen. If false, the distance to the center of the tile is used instead.","identifier":"LevelByProjectedAreaElseDistance","name":"Level by projected area (else distance)","type":"BoolProperty","uri":"Scene.Earth.Renderable.Debug.LevelByProjectedAreaElseDistance"},{"description":"The tile level that is used as the cut off between rendering tiles using the globe model rendering vs the flat in-game rendering method. The value is a trade-off between not having precision errors in the rendering and representing a tile as flat or curved.","identifier":"ModelSpaceRenderingCutoffLevel","name":"Model Space Rendering Cutoff Level","type":"IntProperty","uri":"Scene.Earth.Renderable.Debug.ModelSpaceRenderingCutoffLevel"},{"description":"If this value is set to true, frustum culling will be performed.","identifier":"PerformFrustumCulling","name":"Perform frustum culling","type":"BoolProperty","uri":"Scene.Earth.Renderable.Debug.PerformFrustumCulling"},{"description":"Reset all tile provides for the globe and reload the data.","identifier":"ResetTileProviders","name":"Reset tile providers","type":"BoolProperty","uri":"Scene.Earth.Renderable.Debug.ResetTileProviders"},{"description":"Shows the borders between chunks in a red highlight.","identifier":"ShowChunkEdges","name":"Show chunk edges","type":"BoolProperty","uri":"Scene.Earth.Renderable.Debug.ShowChunkEdges"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"GeoJson","properties":[],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Labels","properties":[{"description":"Labels are aligned horizontally or circularly related to the planet.","identifier":"AlignmentOption","name":"Alignment Option","type":"OptionProperty","uri":"Scene.Earth.Renderable.Labels.AlignmentOption"},{"description":"The text color of the labels.","identifier":"Color","name":"Color","type":"Vec3Property","uri":"Scene.Earth.Renderable.Labels.Color"},{"description":"Labels culling disabled.","identifier":"DisableCulling","name":"Culling Disabled","type":"BoolProperty","uri":"Scene.Earth.Renderable.Labels.DisableCulling"},{"description":"Labels culling distance from globe's center.","identifier":"DistanceEPS","name":"Culling Distance","type":"FloatProperty","uri":"Scene.Earth.Renderable.Labels.DistanceEPS"},{"description":"Enables and disables labels' rendering.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Earth.Renderable.Labels.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Earth.Renderable.Labels.Fade"},{"description":"Sets whether the labels fade in when approaching the globe from a distance. If false, no fading happens and the labels immediately has full opacity.","identifier":"FadeInEnabled","name":"Fade In Enabled","type":"BoolProperty","uri":"Scene.Earth.Renderable.Labels.FadeInEnabled"},{"description":"Sets whether the labels fade out when approaching the surface of the globe. If false, no fading happens and the labels stays in full opacity.","identifier":"FadeOutEnabled","name":"Fade Out Enabled","type":"BoolProperty","uri":"Scene.Earth.Renderable.Labels.FadeOutEnabled"},{"description":"The distances above the globe's surface at which the labels start fading in or out, given in meters. The final distances are also adjusted by the specified height offset.","identifier":"FadeDistances","name":"Fade-In Distances","type":"Vec2Property","uri":"Scene.Earth.Renderable.Labels.FadeDistances"},{"description":"Font size for the rendering labels. This is different fromt text size.","identifier":"FontSize","name":"Font Size","type":"FloatProperty","uri":"Scene.Earth.Renderable.Labels.FontSize"},{"description":"This value moves the label away from the globe surface by the specified distance (in meters).","identifier":"HeightOffset","name":"Height Offset","type":"FloatProperty","uri":"Scene.Earth.Renderable.Labels.HeightOffset"},{"description":"This value affects the size scale of the labels.","identifier":"LabelsSize","name":"Labels Size","type":"FloatProperty","uri":"Scene.Earth.Renderable.Labels.LabelsSize"},{"description":"Minimum and maximum label size, in pixels.","identifier":"MinMaxSize","name":"Min/Max Text Size","type":"IVec2Property","uri":"Scene.Earth.Renderable.Labels.MinMaxSize"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Earth.Renderable.Labels.Opacity"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Layers","properties":[],"propertyOwners":[{"description":"","name":"Color Layers","properties":[{"description":"If this value is enabled, images between different levels are interpolated, rather than switching between levels abruptly. This makes transitions smoother and more visually pleasing.","identifier":"BlendTileLevels","name":"Blend between levels","type":"BoolProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.BlendTileLevels"}],"propertyOwners":[{"description":"Temporal coverage: 02 July 2012 - Present. The Advanced Microwave\n    Scanning Radiometer-E/Advanced Microwave Scanning Radiometer-2 (AMSR-E/AMSR2) unified\n    \"Sea Ice Concentration (12 km)\" layer displays the percent of sea ice concentration in\n    the polar regions as a daily composite of the AMSR2 1:30 a.m. ascending and 1:30 p.m.\n    descending half-orbit passes, at a spatial resolution of 12 km. (Description from NASA\n    Worldview)","name":"AMSR2 GCOM W1 Sea Ice Concentration (Temporal)","properties":[{"description":"This value specifies the blend mode that is applied to this layer. The blend mode determines how this layer is added to the underlying layers beneath.","identifier":"BlendMode","name":"Blend Mode","type":"OptionProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.BlendMode"},{"description":"If this value is enabled, the layer will be used for the final composition of the planet. If this value is disabled, the layer will be ignored in the composition.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Enabled"},{"description":"This value is used by the system to be able to fade out objects independently from the Opacity value selected by the user. This value should not be directly manipulated through a user interface, but instead used by other components of the system programmatically.","identifier":"Fade","name":"Fade","type":"FloatProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Fade"},{"description":"This is the description for the scene graph node to be shown in the gui example: Earth is a special place.","identifier":"GuiDescription","name":"Gui Description","type":"StringProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.GuiDescription"},{"description":"This value determines the opacity of this object. A value of 0 means completely transparent.","identifier":"Opacity","name":"Opacity","type":"FloatProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Opacity"},{"description":"If this value is triggered, a script will be executed that will remove this layer before the next frame.","identifier":"Remove","name":"Remove","type":"TriggerProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Remove"},{"description":"If this value is triggered, this layer will be reset. This will delete the local cache for this layer and will trigger a fresh load of all tiles.","identifier":"Reset","name":"Reset","type":"TriggerProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Reset"},{"description":"The type of this Layer. This value is a read-only property and thus cannot be changed.","identifier":"Type","name":"Type","type":"OptionProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Type"}],"propertyOwners":[{"description":"","name":"Adjustment","properties":[{"description":"The type of layer adjustment that is applied to the underlying layer.","identifier":"Type","name":"Type","type":"OptionProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Adjustment.Type"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Settings","properties":[{"description":"This value is used as an exponent to adjust the color for each tile.","identifier":"Gamma","name":"Gamma","type":"FloatProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Settings.Gamma"},{"description":"This value is used as a multiplier to adjust the color applied after taking the gamma value as an exponent.","identifier":"Multiplier","name":"Multiplier","type":"FloatProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Settings.Multiplier"},{"description":"This value is used as an additive modifier to adjust the color applied after the gamma exponent and the multiplier has been performed.","identifier":"Offset","name":"Offset","type":"FloatProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Settings.Offset"},{"description":"If this value is triggered it will reset all of these values to their default values.","identifier":"SetDefault","name":"Set Default","type":"TriggerProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.Settings.SetDefault"}],"propertyOwners":[],"tags":[],"type":""},{"description":"","name":"Tile Provider","properties":[{"description":"If the 'UseFixedTime' is enabled, this time will be used instead of the actual time taken from OpenSpace for the displayed tiles.","identifier":"FixedTime","name":"Fixed Time","type":"StringProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.TileProvider.FixedTime"},{"description":"If this value is enabled, the time-varying timevarying dataset will always use the time that is specified in the 'FixedTime' property, rather than using the actual time from OpenSpace.","identifier":"UseFixedTime","name":"Use Fixed Time","type":"BoolProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.AMSR2_GCOM_W1_Sea_Ice_Concentration_Temporal.TileProvider.UseFixedTime"}],"propertyOwners":[],"tags":[],"type":""}],"tags":[],"type":""},{"description":"Temporal coverage: 03 July 2002 - Present. True Color: Red = Band 1,\n    Green = Band 4, Blue = Band 3. These images are called true-color or natural color\n    because this combination of wavelengths is similar to what the human eye would see.\n    The images are natural-looking images of land surface, oceanic and atmospheric\n    features. The downside of this set of bands is that they tend to produce a hazy image.\n    The MODIS Corrected Reflectance imagery is available only as near real-time imagery.\n    The imagery can be visualized in Worldview and the Global Imagery Browse Services\n    (GIBS). The sensor resolution is 500 m and 250 m (Bands 1 and 2 have a sensor\n    resolution of 250 m, Bands 3 - 7 have a sensor resolution of 500m, and Bands 8 - 36\n    are 1 km. Band 1 is used to sharpen Band 3, 4, 6, and 7), imagery resolution is 250 m,\n    and the temporal resolution is daily. (Description from NASA Worldview)","name":"Aqua Modis (Temporal)","properties":[{"description":"This value specifies the blend mode that is applied to this layer. The blend mode determines how this layer is added to the underlying layers beneath.","identifier":"BlendMode","name":"Blend Mode","type":"OptionProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.Aqua_Modis_Temporal.BlendMode"},{"description":"If this value is enabled, the layer will be used for the final composition of the planet. If this value is disabled, the layer will be ignored in the composition.","identifier":"Enabled","name":"Enabled","type":"BoolProperty","uri":"Scene.Earth.Renderable.Layers.ColorLayers.Aqua_Modis_Temporal.Enabled"},{"description":"This value is u