# Features
  - The entire user interface of OpenSpace is reworked to be more user friendly and provide more flexibility when using the software (#3608)
    - Better organization of the scene menu and the properties contained within it
    - All windows are now resizable and dockable
    - Complete control over which buttons are shown on the toolbar
    - Added support for internationalization of the front-end text
    - A new notification system informing of warnings and errors
    - A new panel designed for Night's Sky shows
  	- Support for a greater range of dates
  	- Redesign and future-proofing of all aspects of the user interface
  - The documentation page (https://docs.openspaceproject.com) has been redesigned and now contains a lot more information to both present existing assets in OpenSpace, as well as example files helping the creation of new datasets
  - It is possible to store the profile and configuration that were used for the last start of OpenSpace from the Launcher (#3410)
  - Adding support for sending Telemetry about OpenSpace using the opensoundcontrol protocol, making data available for Sonification purposes (#3461)
  - The `OpenSpaceData` folder that can contain optional has now been moved from living _next_ to the OpenSpace installation to be being place inside the `user` folder (#3567)
  - When using the `Z` and `X` keys, the sensitivity change now increases gradually (#3064, #3065)
  - Exoplanets
    - Add the ability to show a label for added Exoplanet Systems (#3318)
    - Each exoplanet now has a color layer indicating their size (terrestrial, super-earth, neptune-like, or gas giant and larger) (#3412)
    - Add the option to specify a default texture for added exoplanets (#3353)
  - Add the movement of stars according to their proper motion if velocity information is included in the star datasets (#3561)
  - Add the ability to drag and drop WMS files to add them as a layer to the current anchor node
  - Add the ability to drag and drop an entire folder, which will add all files contained within
  - Make it possible to feather the border frame color of ScreenSpace objects
  - Add support for correction meshes created by the ScalableSDK (sgct/sgct#101)
  - Add support for sending OpenSpace windows via the NDI library (sgct/sgct#102)
  - Improvements to the logging of elements in the ScriptLog (#3389)
    - The contents of actions that are triggered are no longer stored in the script log file
    - Added a new option `VerboseScriptLog` to the `openspace.cfg` to re-enable the old behavior and include a lot of more information in the script log
  - Add the ability to configure the horizontal field of view per window (#3584)
  - Cleanup and simplify the properties in `RenderableGlobe` (#3408)
    - Restructure "general properties" into shadow mapping and regular ones
    - Add values that could not be set from parameters (e.g. from asset or script)
  - Add the ability to prevent windows from taking screenshots (sgct/sgct#87)
  - Geodectic position and distance of the camera now correctly displays for non-globe objects
  - Add support to mirror any window horizontally or vertically
  - The `DebugModule` now also shows the node ID in the frame information overlay

## Launcher
  - The Launcher application now respects the operating system's darkmode settings when in the profile editor and Window Configuration editor (#3369)
  - Add support for subfolders to better organize both configurations and profiles
  - The Profile editor now uses a normal Save dialog instead of the previous need to use the duplicate + renaming paradigm
  - Add a submenu to the "New" button to either duplicate an existing profile or create a new empty one (#3601)
  - Add a new Notification section to the Launcher window in which important information will be shared (#3595)
  - Improve the graphic design to indicate when a button is currently unavailable
  - Change the layout of the Window Configuration editor to provide more explicit options which window should have Overlay rendering and 3D rendering
  - Add a new panel to the Profile editor to control which WebUI button appears on the taskbar (#3569)
  - User-generated profiles and window configurations now show a small U icon in the profile selection (#3611)
  - Add keyboard shortcuts for adding and removing windows in the Window Configuration editor
  - Add the option to select the tilt of a fisheye rendering
  - Make it possible to pick window blitting when selecting a projection (#3568)
  - The time picker in the Profile editor is now a tabbed window (#3562)

## UI
  - Add a new hint to determine if a scene graph node should focusable and only provide user-interface elements to focus on scene graph nodes that are focusable (#3508)
  - Fix a large amount of user-interface accessibility issues (#3088, #3089, #3090, #3092, #3094, #3096, #3097, #3098, #3099, #3100, #3101, #3103, #3441, #3443, #3616)
    - Improve the contrast ratios for many elements for better visibility
    - The entire user interface is now keyboard navigable
    - More consistent coloring of user interface elements
  - Add the ability to specify a background color and a text color for actions buttons (#3551)
  - Add a new optional parameter to overwrite an existing session recording file
  - Change the visibility level setting of the "on-screen version" setting to "User"
  - Improve the naming of the GeoJSON component in the RenderableGlobe (#2883)

# Content
## New Profiles
  - Add new calibrator asset and profile (closes #2268)

## New Assets
  - Add Kuiper constellation of satellites
  - Add a new asset defining the supergalactic transformation matrix once and reusing it in other assets
  - Add new assets for defined new coordinate systems related to Earth's magnetosphere (#3392)

## New Maps
  - Add Esri Wayback layers (#3382)
  - Add WMS layer for Titan HiSAR map (#3565)
  - Add new maps for the Globe representation of Phobos (#1397)

## Updates to existing Assets/Profiles
  - Remove the `default_full` profile as it has outlived its usefulness and it now can be replicated user-side through the Profile editor
  - Updates to the `nightssky` profile
  - Remove the `touch` profile as it did not have a coherent use-case apart from showing a now-defunct user interface
  - Remove "Up" keybind and retire the `property_helper` and `renderable_helper` assets (#3604)
  - Change the tint of the SunGlare to be more yellow (#3459)
  - Neptune and Uranus now use the correct period length
  - Remove the Indian anti-satellite debris asset as the last of its known debris has reentered the atmosphere (#3529)
  - Updated the exoplanet, exoplanet candidate, and brown dwarf datasets of the Digital Universe
  - The Digital Unierse assets have been rearranged and reordered in the user interface (#3460)
  - Update SPICE kernel data for the Rosetta spacecraft (#3370)
  - Add a new Sweden-based WMS caching server to access Earth map layers
  - Split up the JWST and Lagrange points assets into smaller assets (#3432)
  - Change the color of the constellation boundaries (#3458)
  - The Milky Way galaxy object is now parented to the root, making it not disappear when SPICE information for the solar system runs out (#3232)
  - Add missing tags for the Moon (#3406)

## Content creation
  - Add new `ScreenSpaceInsetBlackout` class that can be used to display a configurable black-out frame allowing to overlay secondary projectors onto the dome surface (#3657)
  - Add new `ScreenSpaceRenderableRenderable` class that allows the rendering of any `Renderable` class into a screenspace object using a custom camera location (#3575)
  - Add the ability to specify longitude and latitude subdivisions in RenderableSphericalGrid (#3494)
  - Add horizons-based NewHorizons asset
  - Move Voyager and Pioneer horizons files into separate folders
  - Create new interstellar horizons file that replaces previous voyager-pioneer one (#3273)
  - Harmonizing `OrientationRenderOption` and `Billboard` settings.  Make RenderablePlanes use the new setting (#3630)
  - Add a new image plane class that displays online images keyed by the current simulation time (#3646)
  - Exoplanets added through the user interface now have the `{exoplanet_planet}` tag 
  - The `SampleInterval` parameter option for the `RenderableTrailTrajectory` is now optional and uses a default of 2 days by default
  - Add a new time-varying dashboard item class that can display information from a local disk keyed to the current simulation time  (#3621)
  - Add new Kepler data reader for the IAU's Minor Planet Center database files (#3591)
  - Add new class `TimelineScale` to complement `TimelineRotation` and `TimelineTranslation` (#3536)
  - Invalid GeoJSON geometries will now load after attempting to fix them (#3452)
  - Add a "time offset" option to the `SpiceRotation` and `SpiceTranslation` (#3544, Thanks @dawagner)
  - Add the ability to run a task file at startup (#3612)
  - Automatically reload texture for `RenderableSphereImageLocal` when the file on disk changes (#3500)
  - Add new renderable `RenderableSwitch` class that switches between two renderables (#3597)
  - Add the ability to the `RenderablePlane` to perform distance-based scaling (#3598)
  - Allow OptionProperty to receive either indices or the textual representation of the value when setting them through the `openspace.setPropertyValue` function (#3524)
  - Add the ability to choose the domain filtering in the asset for a fieldline sequence (#3437)
  - Add new types for Scale, Translation, and Rotation that combines multiple instances together
  - Missing Horizons files in a `HorizonsTranslation` are now considered an error instead of a warning
  - A missing image in a  `ScreenSpaceImageLocal` is now an error instead of a warning
  - Add new `TimeFrame` that parses Spice kernels (#3600)
  - The `Layers`s specification in a `RenderableGlobe` is now optional
  - Add a new DashboardItem to show the camera's orientation (#3542)
  - Add a new Lua function (`openspace.setGuiOrder`) to specify the order in which scene graph nodes are displayed. This can be either based on an explicit ordering by name or through a numerical order (#3337) 
  - Nautical miles is now a valid distance units wherever they are accepted
  - Add the ability to limit-rate the dashboard updating (#3527)
  - The `RenderableDebugPlane` is now a  `ScreenSpaceRenderable` (#3483)

### Lua
  - All Lua environments used for executing scripts and loading assets are by default now sandboxed and no longer have access to operating system functions (#3378)
  - Improve performance when using the `setPropertyValue` function (#3579)
  - Add the ability to combine Tags in the `openspace.setPropertyValue` function supporting the operations of intersection (`&`), union (`|`), and negation (`~`) (#3638)
  - Add a new Lua function `openspace.navigation.setFocus` that simplifies the programmatic setting of the current focus node (#3534)
  - Moved a number of functions related to globe locations from the `globebrowsing` and `pathnavigation` names into the `navigation` name (#3613)
    - `jumpToGeo`, `flyToGeo`, `flyToGeo2`, `localPositionFromGeo`, `isFlying`, `flyTo`, `flyToHeight`, `flyToNavigationState`, `zoomToFocus`, `zoomToDistance`, `zoomToDistanceRelative`, `jumpTo`, `jumptoNavigationState` 
  - Add a new Lua function `openspace.asset.reload` to reload a dynamically loaded asset (#3543, Thanks @dawagner)
  - Add new Lua function `openspace.scheduleScript` with the the ability to schedule scripts based on wall-clock time 
  - Add possibility to set timestamp when using `openspace.pathnavigation.jumpToNavigationState`
  - Add new Lua functions (`openspace.registerRepeatedScript` and `openspace.removeRepeatedScript`)  to repeatedly execute Lua scripts (#3416)
  - Add a new Lua function (`openspace.readFileLines`) to read a file line-by-line
  - Add support to `openspace.addCustomProperty` to add TriggerPropertys (closes #3487)
  - Add a new Lua function (`openspace.resolveShortcut`) that can resolve ShellLink files on Windows 
  - Missions use an identifier instead of the user-facing name as a unique identifying string in all functions that operate on missions
  - The `LuaTranslation`, `LuaRotation`, and `LuaScale` scripts now have access to the `openspace` Lua function table
  - Add two new functions, `openspace.ramInUse()` and `openspace.vramInUse()`, to report an estimate of the amount of memory and video memory currently being in use by OpenSpace
  - Update Lua interpreter to version 5.4.7

### API
  - A few number of breaking changes have been made to the JavaScript and Python APIs see XXX for more detailed information

# Bug Fixes
  - With large screens, the user-interface did become sluggish and unresponsive (#3386)
  - Trying to delete a globe layer through the user interface would crash the application (#3357)
  - Adding an atmosphere at runtime would sometimes crash the application (#3498)
  - Enabling the shadow component on a planet that doesn't have a ring system crashed the application (#3404)
  - Models with baked animations would occasionally lead to a crash (#3395)
  - The initial LoadingScreen froze when displayed in a small window while trying to load a profile with a large number of scene graph nodes (#3473)
  - Using an invalid vector in the asset file would cause the application to crash (#3635)
  - The operating systems locale was used in a number of file reading operations, causing issues for languages where the decimal separator is not `.` (#3474)
  - Moving a globebrowsing layer to the top of a list that only has two layers would cause a crash (#3414)
  - Specifying IPv4 addresses with leading 0s would cause the autodetection of the cluster ID to fail
  - WMI privilege errors was crashing the application (OpenSpace/Ghoul#112)
  - A number of assets caused crashes and errors when loading and unloading them (#3430)
  - The field lines for the Ganymede magnetic field were not shown correctly in the JUICE profile
  - Stars disappeared when setting the MilkyWaySphere opacity to 1 (#3304)
  - The `RenderableSphericalGrid` was not layered correctly with regard to other elements in the scene
  - It was not possible to use all keys on a non-English keyboard in the user interface (#3594)
  - The computation of field-of-view settings for viewports that are rotated was incorrect (SGCT/SGCT#96, SGCT/SGCT#97, SGCT/SGCT#98)
  - The `Rotation` of a `ScreenSpace` was not settable from an asset file
  - The `openspace.fadeOut` function did not disable the object at end of the fading
  - The Horizons file editor was not using the correct ID for the "Center Body"
  - TLE files with CRLF line endings did not parse correctly on Linux (#3326)
  - Shader files with CRLF line endings did not parse correctly on Linux (#3472)
  - Displaying multiple items with different font sizes and spacing did cause layout issues in Dashboards (#3614)
  - Vector-style dictionaries in asset files did not sort correctly when containing more than 9 numerical keys
  - Drag and dropping GIF files caused them to be added as images, not videos, thus preventing their playback
  - TileIndex and Size Reference layers did not show up at all (#3356)
  - The UTC time string in the Pluto trail had the wrong formatting, preventing asset loading
  - The BlackLevel mask was using the incorrect blending mode (SGCT/SGCT#99)
  - Error in the window configuration file syntax were not printed correctly into the log file and only the console
  - The Horizons editor now provides a more comprehensive message when it returns the "News" section (#3622)
  - The opacity value of a `ScreenSpace` object was not applied to the border color (#3355)
  - The prototype-based temporal tile provider did not work when using "Today" or "Yesterday"
  - A new generated configuration file was created in the temporary folder every time OpenSpace was started (#3449)
  - Changing the `FormatString` in the `DashboardItemElapsedTime` did not change the output (#3519, Thanks @dawagner)
  - The lowest time unit parameter in the `DashboardItemElapsedTime` was not used correctly (#3515, Thanks @dawagner)
  - The plural version of the unit string was not correctly applied in the `DashboardItemElapsedTime` (#3516, Thanks @dawagner)
  - Updates to the field-of-view settings for windows under some circumstances would cause floating-point inaccuracies
  - The non-main dashboard was not showing up in the user interface when added to a `ScreenSpaceDashboard`
  - The text in the `DashboardItemMission` was not aligned correctly (#3540)
  - When multiple RenderableTravelSpeeds were in the scene, it was not possible to change their colors (#3381)
  - Reparenting a scene graph node was not correctly updating the entire scene graph structure, leading to an error message when closing the application (#3603)
  - The `RequestedUnit` of a `DashboardItemDistance` was hidden in the user interface (#3435)
  - The path for the `RenderableFluxNode` was not correctly read
  - Parameters from the `setPropertyValue` function were not parsed correctly from ScriptLog in the Properties editor
  - The number of capture threads was too high, impacting performance when rendering frames
  - Navigating to a globe that has a `SolidColor` layer led to shader warnings (#3405)
  - The constellation asset caused a crash when it was the first asset to be loaded with a sync folder existing
  - It was not possible to drag and drop shortcut files on Windows (#2544)
  - User interface elements did not display the correct mouse cursors depending on the expected input modality (#2244)
  - Transferring large files across a synced connection was taking a long time (sgct/sgct#77)
  - The "Release" (as opposed to RelWithDebInfo) build in Windows was crashing on startup (#1657)
  - The render ordering of different 2D objects was incorrect
  - The "Clear Projections" button in the `ProjectionComponent` was presented as a checkbox
  - The "ResetTileProviders" in `RenderableGlobe` was represented as a checkbox


# Breaking Changes
## Content
  - The Touch profile no longer exists.  

## Lua
  - `openspace.scriptScheduler.setModeApplicationTime`, `openspace.scriptScheduler.setModeRecordedTime`, and `openspace.scriptScheduler.setModeSimulationTime` removed
  - FBX format handling in Assimp has changed and causes a 90 degree rotation (assimp/assimp#849)
  - `openspace.pathnavigation.jumpToNavigationState` takes three arguments instead of two. The second argument is new and lets you set the timestamp in the jump. 
  - Updated paths for lagrange point assets. For example: `assets\scene\solarsystem\planets\earth\lagrange_points\l2.asset` -> `assets\scene\solarsystem\planets\earth\lagrange_points\l2\l2.asset` 
  - `openspace.exoplanet.addExoplanetSystem` can no longer take a list of star names. Instead, use the new function `openspace.exoplanet.addExoplanetSystems` to add multiple exoplanet systems in one function call 
  - AllowAdresses has been moved (@TODO: elaborate. #3445)
  - `openspace.fadeOut` now also disables the object once it has faded out

## Asset creation
  - `RenderableBoxGrid` no longer takes a `LabelsComponent` (#3479)
  - `RenderableDebugPlane` no longer exists. It has been replaced by a new screenspace type: `ScreenSpaceDebugPlane`. (#3483)
  - `RenderableDistanceLabel` now takes a string for its `DistanceUnit`, instead of a number (#3485)
  - Default blending for `RenderableSphere`s have changed from additive to "normal" blending. This may change the visuals of any created spheres. The classes `RenderableSphereImageOnline` and `RenderableSphereImageLocal` now have two new settings for controlling how they are endered: `BlendingOption` and `DisableDepth`. https://github.com/OpenSpace/OpenSpace/commit/3c61857127eb97908a877738885d6fb10b21af97
  - `RenderableRadialGrid` now creates a grid with 10 segments in the radial and angular direction. Previously, it was a ring per default (https://github.com/OpenSpace/OpenSpace/commit/7f4bf7399397227bdd8dcec701139d0d9dac3f2a). To fix it, set the `GridSegments` attribute to `{1, 1}` in your asset that creates the `RenderableRadialGrid`.
  - (@TODO: ) (#3584)
  - Assets `property_helper.asset` and `renderable_helper.asset` have been removed in favor of functions in Lua API (#3604)
  - The `default_keybindings.asset` has been split up into two assets, one with keybindings (`default_keybindings.asset`) and one with just the actions (`default_actions.asset`). As a result, the previous `default_actions.asset` has been renamed to `solarsystem_actions.asset`. 
  - Asset `scene/solarsystem/missions/voyagerpioneer/voyager1_2__pioneer10_11.asset` has been replaced with  `scene/solarsystem/missions/interstellar_horizons.asset` and now also includes New Horizons (https://github.com/OpenSpace/OpenSpace/commit/b111b24e8ae49a23b90cef608a42a45a9d9fa35e)
  - The y-value for Dashboard location is now inverted compared to how it was before, so that the y-values are specified as positive values instead of negative (#3614)
  - `RenderablePointCloud`s `OrientationRenderOption` parameter/property has been renamed to `Billboard` (https://github.com/OpenSpace/OpenSpace/pull/3630)

## Properties
  - Changed identifier of property `EnabledMinimumAllowedDistance` to `EnableMinimumAllowedDistance` in order to match `EnableMaximumAllowedDistance` (https://github.com/OpenSpace/OpenSpace/commit/5a862c27d8b0d85c11d79300c7a60f1a077732e8)
  - Changed identifier for property owner in `RenderableGlobe` from `GeoJson` to `GeographicOverlays` (https://github.com/OpenSpace/OpenSpace/commit/e93ad7910f2bc93d884aab6b8a3d3535538b75e9)

## Other 
  - This release includes a number of __keybindings__ changes, partly motivated by the UI redesign: 
    - Removed keybindings to `Up` arrow key (that interpolated the time to now). The action still exists in the actions panel
  - `ESC` to exit OpenSpace has been replaced with `Ctrl+Q` 
  - `TAB` and `Shift+TAB` for showing/hiding UI features have been replaced with `F1` and `Shift+F1`
  - `Alt+R` to hide rendering on master node has been removed. The action still exists in the actions panel
